/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.events;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.jfr.JfrEvent;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrNativeEventWriterDataAccess;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.events.JVMInformation;
import java.util.Map;
import java.util.Properties;
import jdk.jfr.Event;
import jdk.jfr.Name;
import jdk.jfr.Period;
import org.graalvm.nativeimage.StackValue;

@Name(value="EndChunkPeriodEvents")
@Period(value="endChunk")
public class EndChunkNativePeriodicEvents
extends Event {
    private static String formatOSInformation() {
        String name = System.getProperty("os.name");
        String ver = System.getProperty("os.version");
        String arch = System.getProperty("os.arch");
        return name + " (" + ver + ") arch:" + arch;
    }

    public static void emit() {
        EndChunkNativePeriodicEvents.emitClassLoadingStatistics(Heap.getHeap().getClassCount(), 0L);
        EndChunkNativePeriodicEvents.emitJVMInformation(JVMInformation.getJVMInfo());
        EndChunkNativePeriodicEvents.emitOSInformation(EndChunkNativePeriodicEvents.formatOSInformation());
        EndChunkNativePeriodicEvents.emitInitialEnvironmentVariables(EndChunkNativePeriodicEvents.getEnvironmentVariables());
        EndChunkNativePeriodicEvents.emitInitialSystemProperties(EndChunkNativePeriodicEvents.getSystemProperties());
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    private static void emitInitialEnvironmentVariables(StringEntry[] envs) {
        if (SubstrateJVM.isRecording() && SubstrateJVM.get().isEnabled(JfrEvent.InitialEnvironmentVariable)) {
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initializeThreadLocalNativeBuffer(data);
            for (StringEntry env : envs) {
                JfrNativeEventWriter.beginEventWrite(data, false);
                JfrNativeEventWriter.putLong(data, JfrEvent.InitialEnvironmentVariable.getId());
                JfrNativeEventWriter.putLong(data, JfrTicks.elapsedTicks());
                JfrNativeEventWriter.putString(data, env.key);
                JfrNativeEventWriter.putString(data, env.value);
                JfrNativeEventWriter.endEventWrite(data, false);
            }
        }
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    private static void emitInitialSystemProperties(StringEntry[] systemProperties) {
        if (SubstrateJVM.isRecording() && SubstrateJVM.get().isEnabled(JfrEvent.InitialSystemProperty)) {
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initializeThreadLocalNativeBuffer(data);
            for (StringEntry systemProperty : systemProperties) {
                JfrNativeEventWriter.beginEventWrite(data, false);
                JfrNativeEventWriter.putLong(data, JfrEvent.InitialSystemProperty.getId());
                JfrNativeEventWriter.putLong(data, JfrTicks.elapsedTicks());
                JfrNativeEventWriter.putString(data, systemProperty.key);
                JfrNativeEventWriter.putString(data, systemProperty.value);
                JfrNativeEventWriter.endEventWrite(data, false);
            }
        }
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    private static void emitClassLoadingStatistics(long loadedClassCount, long unloadedClassCount) {
        if (SubstrateJVM.isRecording() && SubstrateJVM.get().isEnabled(JfrEvent.ClassLoadingStatistics)) {
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initializeThreadLocalNativeBuffer(data);
            JfrNativeEventWriter.beginEventWrite(data, false);
            JfrNativeEventWriter.putLong(data, JfrEvent.ClassLoadingStatistics.getId());
            JfrNativeEventWriter.putLong(data, JfrTicks.elapsedTicks());
            JfrNativeEventWriter.putLong(data, loadedClassCount);
            JfrNativeEventWriter.putLong(data, unloadedClassCount);
            JfrNativeEventWriter.endEventWrite(data, false);
        }
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    private static void emitJVMInformation(JVMInformation jvmInformation) {
        if (SubstrateJVM.isRecording() && SubstrateJVM.get().isEnabled(JfrEvent.JVMInformation)) {
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initializeThreadLocalNativeBuffer(data);
            JfrNativeEventWriter.beginEventWrite(data, false);
            JfrNativeEventWriter.putLong(data, JfrEvent.JVMInformation.getId());
            JfrNativeEventWriter.putLong(data, JfrTicks.elapsedTicks());
            JfrNativeEventWriter.putString(data, jvmInformation.getJvmName());
            JfrNativeEventWriter.putString(data, jvmInformation.getJvmVersion());
            JfrNativeEventWriter.putString(data, jvmInformation.getJvmArguments());
            JfrNativeEventWriter.putString(data, jvmInformation.getJvmFlags());
            JfrNativeEventWriter.putString(data, jvmInformation.getJavaArguments());
            JfrNativeEventWriter.putLong(data, jvmInformation.getJvmStartTime());
            JfrNativeEventWriter.putLong(data, jvmInformation.getJvmPid());
            JfrNativeEventWriter.endEventWrite(data, false);
        }
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    private static void emitOSInformation(String osVersion) {
        if (SubstrateJVM.isRecording() && SubstrateJVM.get().isEnabled(JfrEvent.OSInformation)) {
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initializeThreadLocalNativeBuffer(data);
            JfrNativeEventWriter.beginEventWrite(data, false);
            JfrNativeEventWriter.putLong(data, JfrEvent.OSInformation.getId());
            JfrNativeEventWriter.putLong(data, JfrTicks.elapsedTicks());
            JfrNativeEventWriter.putString(data, osVersion);
            JfrNativeEventWriter.endEventWrite(data, false);
        }
    }

    private static StringEntry[] getEnvironmentVariables() {
        Map<String, String> env = System.getenv();
        StringEntry[] result = new StringEntry[env.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : env.entrySet()) {
            result[i] = new StringEntry(entry.getKey(), entry.getValue());
            ++i;
        }
        return result;
    }

    public static StringEntry[] getSystemProperties() {
        Properties properties = System.getProperties();
        StringEntry[] result = new StringEntry[properties.size()];
        int i = 0;
        for (String key : properties.stringPropertyNames()) {
            result[i] = new StringEntry(key, properties.getProperty(key));
            ++i;
        }
        return result;
    }

    private static class StringEntry {
        public final String key;
        public final String value;

        StringEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

