/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.annotate.Uninterruptible;

public enum HubType {
    Instance(0),
    InstanceReference(1),
    StoredContinuation(2),
    Other(3),
    TypeArray(4),
    ObjectArray(5);

    private final int value;

    private HubType(int value) {
        this.value = value;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getValue() {
        return this.value;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isInstance(int hubType) {
        return hubType <= StoredContinuation.getValue();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isReferenceInstance(int hubType) {
        return hubType == InstanceReference.getValue();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isStoredContinuation(int hubType) {
        return hubType == StoredContinuation.getValue();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isArray(int hubType) {
        return hubType >= TypeArray.getValue();
    }
}

