/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.graal.nodes.NewStoredContinuationNode;
import com.oracle.svm.core.heap.CodeReferenceMapDecoder;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.thread.Continuation;
import com.oracle.svm.core.thread.Safepoint;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.api.directives.GraalDirectives;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.util.TypeConversion;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class StoredContinuationImpl {
    private static final int HEADER_SIZE = 24;
    public static final int PAYLOAD_OFFSET = 24;
    public static final int OBJECT_MONITOR_OFFSET = 8;
    private static final int SIZE_OFFSET_TO_PAYLOAD = -8;
    private static final int FRAME_COUNT_OFFSET_TO_PAYLOAD = -4;
    private static final int VALID_OFFSET_START = -8;
    private static final int FRAME_META_START_OFFSET_TO_PAYLOAD = 0;
    private static final int FRAME_META_SIZE = 8;
    private static final int SIZE_OFFSET_IN_FRAME_META = 0;
    private static final int REFERENCE_MAP_INDEX_OFFSET_IN_FRAME_META = 4;

    @Uninterruptible(reason="in allocation of StoredContinuation instance")
    public static void initializeNewlyAllocated(Object obj, int payloadSize) {
        Word p = Word.objectToUntrackedPointer((Object)obj).add(24);
        p.writeInt(-8, payloadSize, LocationIdentity.init());
        p.writeInt(-4, 0, LocationIdentity.init());
    }

    private static StoredContinuation allocate(int payloadSize) {
        assert (payloadSize % 8 == 0);
        StoredContinuation f = NewStoredContinuationNode.allocate(payloadSize);
        assert (StoredContinuationImpl.readPayloadSize(f) == payloadSize);
        return f;
    }

    @Uninterruptible(reason="read StoredContinuation")
    private static boolean checkOffset(StoredContinuation f, int offset) {
        assert (offset % 4 == 0);
        if (offset >= 0 ? !$assertionsDisabled && offset >= StoredContinuationImpl.readSize(f) : !$assertionsDisabled && offset < -8) {
            throw new AssertionError();
        }
        return true;
    }

    @Uninterruptible(reason="read StoredContinuation")
    private static boolean checkPayloadOffset(StoredContinuation f, int offset) {
        assert (offset % 4 == 0);
        assert (offset >= 0);
        assert (offset < StoredContinuationImpl.readSize(f));
        return true;
    }

    @Uninterruptible(reason="read StoredContinuation")
    private static int readPayloadInt(StoredContinuation f, int offset) {
        assert (StoredContinuationImpl.checkOffset(f, offset));
        return StoredContinuationImpl.payloadLocation(f).readInt(offset);
    }

    @Uninterruptible(reason="write StoredContinuation")
    private static void writePayloadInt(StoredContinuation f, int offset, int value) {
        assert (StoredContinuationImpl.checkPayloadOffset(f, offset));
        StoredContinuationImpl.payloadLocation(f).writeInt(offset, value);
    }

    @Uninterruptible(reason="read StoredContinuation")
    private static int readPayloadSize(StoredContinuation f) {
        return StoredContinuationImpl.readPayloadInt(f, -8);
    }

    @Uninterruptible(reason="read StoredContinuation")
    public static int readAllFrameSize(StoredContinuation f) {
        return StoredContinuationImpl.readPayloadSize(f) - StoredContinuationImpl.readFrameMetaSize(f);
    }

    @Uninterruptible(reason="read StoredContinuation")
    public static int readSize(StoredContinuation f) {
        return StoredContinuationImpl.readPayloadSize(f) + 24;
    }

    @Uninterruptible(reason="read StoredContinuation")
    public static int readFrameCount(StoredContinuation f) {
        return StoredContinuationImpl.readPayloadInt(f, -4);
    }

    @Uninterruptible(reason="read StoredContinuation")
    private static int readFrameMetaSize(StoredContinuation f) {
        return 0 + StoredContinuationImpl.readFrameCount(f) * 8;
    }

    @Uninterruptible(reason="read StoredContinuation")
    public static int readFrameSize(StoredContinuation f, int frameIndex) {
        return StoredContinuationImpl.payloadLocation(f).readInt(0 + frameIndex * 8 + 0);
    }

    @Uninterruptible(reason="read StoredContinuation")
    private static int readReferenceMapIndex(StoredContinuation f, int frameIndex) {
        return StoredContinuationImpl.payloadLocation(f).readInt(0 + frameIndex * 8 + 4);
    }

    @Uninterruptible(reason="read/write StoredContinuation")
    private static Pointer payloadLocation(StoredContinuation f) {
        return Word.objectToUntrackedPointer((Object)f).add(24);
    }

    @Uninterruptible(reason="read/write StoredContinuation")
    public static Pointer payloadFrameStart(StoredContinuation f) {
        return StoredContinuationImpl.payloadLocation(f).add(StoredContinuationImpl.readFrameMetaSize(f));
    }

    public static int allocateFromCurrentStack(Continuation cont, Pointer rootSp, Pointer leafSp, CodePointer leafIp) {
        return StoredContinuationImpl.allocateFromStack(cont, rootSp, leafSp, leafIp, (IsolateThread)WordFactory.nullPointer());
    }

    public static int allocateFromForeignStack(Continuation cont, Pointer rootSp, IsolateThread thread) {
        return StoredContinuationImpl.allocateFromStack(cont, rootSp, (Pointer)WordFactory.nullPointer(), (CodePointer)WordFactory.nullPointer(), thread);
    }

    private static int allocateFromStack(Continuation cont, Pointer rootSp, Pointer leafSP, CodePointer leafIp, IsolateThread otherThread) {
        boolean isCurrentThread = leafSP.isNonNull();
        YieldVisitor visitor = new YieldVisitor(rootSp, leafSP, leafIp);
        Pointer resultLeafSP = leafSP;
        if (isCurrentThread) {
            VMError.guarantee(otherThread.isNull());
            JavaStackWalker.walkCurrentThread(leafSP, visitor);
        } else {
            JavaStackWalker.walkThread(otherThread, visitor);
            resultLeafSP = visitor.leafSP;
        }
        if (visitor.preemptStatus != 0) {
            return visitor.preemptStatus;
        }
        if (!isCurrentThread) {
            cont.setIP(visitor.leafIP);
        }
        VMError.guarantee(resultLeafSP.isNonNull());
        int frameCount = visitor.frameSizeReferenceMapIndex.size();
        int payloadSize = 8 * frameCount + UnsignedUtils.safeToInt((UnsignedWord)rootSp.subtract((UnsignedWord)resultLeafSP));
        cont.stored = StoredContinuationImpl.allocate(payloadSize);
        int allFrameSize = 0;
        for (int i = 0; i < frameCount; ++i) {
            Pair<Integer, Integer> frameSizeRefMapInxPair = visitor.frameSizeReferenceMapIndex.get(i);
            StoredContinuationImpl.writePayloadInt(cont.stored, 0 + i * 8 + 0, (Integer)frameSizeRefMapInxPair.getLeft());
            StoredContinuationImpl.writePayloadInt(cont.stored, 0 + i * 8 + 4, (Integer)frameSizeRefMapInxPair.getRight());
            allFrameSize += ((Integer)frameSizeRefMapInxPair.getLeft()).intValue();
        }
        StoredContinuationImpl.fillUninterruptibly(cont.stored, resultLeafSP, allFrameSize, frameCount);
        return 0;
    }

    @Uninterruptible(reason="Prevent modifications to the stack while copying.")
    private static void fillUninterruptibly(StoredContinuation stored, Pointer sp, int size, int frameCount) {
        Pointer p = StoredContinuationImpl.payloadLocation(stored);
        p.writeInt(-4, frameCount);
        VMError.guarantee(size == StoredContinuationImpl.readAllFrameSize(stored));
        Pointer frameStart = StoredContinuationImpl.payloadFrameStart(stored);
        UnmanagedMemoryUtil.copy(sp, frameStart, WordFactory.unsigned((int)size));
        Object opaque = GraalDirectives.opaque((Object)stored);
        Heap.getHeap().dirtyAllReferencesOf(opaque);
    }

    @AlwaysInline(value="de-virtualize calls to visitors")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean walkStoredContinuationFromPointer(Pointer baseAddress, RawFrameVisitor frameVisitor, ObjectReferenceVisitor refVisitor, Object holderObject) {
        int frameIndex;
        StoredContinuation f = (StoredContinuation)holderObject;
        Pointer payloadStart = StoredContinuationImpl.payloadLocation(f);
        assert (payloadStart.subtract((UnsignedWord)baseAddress).equal(24)) : "base address not pointing to frame instance";
        int frameCount = StoredContinuationImpl.readFrameCount(f);
        int size = StoredContinuationImpl.readPayloadSize(f);
        Pointer curFrame = StoredContinuationImpl.payloadFrameStart(f);
        NonmovableArray<Byte> referenceMapEncoding = CodeInfoTable.getImageCodeCache().getStackReferenceMapEncoding();
        for (frameIndex = 0; frameIndex < frameCount; ++frameIndex) {
            int frameSize = StoredContinuationImpl.readFrameSize(f, frameIndex);
            int referenceMapIndex = StoredContinuationImpl.readReferenceMapIndex(f, frameIndex);
            if (frameVisitor != null && !frameVisitor.visitRawFrame(frameIndex, curFrame)) {
                return false;
            }
            if (refVisitor != null && !CodeReferenceMapDecoder.walkOffsetsFromPointer((PointerBase)curFrame, referenceMapEncoding, referenceMapIndex, refVisitor, holderObject)) {
                return false;
            }
            curFrame = curFrame.add(frameSize);
        }
        assert (frameIndex == frameCount);
        assert (frameCount == 0 || curFrame.subtract((UnsignedWord)payloadStart).equal(size));
        return true;
    }

    @Fold
    protected static int getByteArrayBaseOffset() {
        return ConfigurationValues.getObjectLayout().getArrayBaseOffset(JavaKind.Byte);
    }

    private static class YieldVisitor
    extends StackFrameVisitor {
        int preemptStatus = 0;
        Pointer rootSP;
        Pointer leafSP;
        CodePointer leafIP;
        List<Pair<Integer, Integer>> frameSizeReferenceMapIndex = new ArrayList<Pair<Integer, Integer>>();
        final NonmovableArray<Byte> expectedReferenceMap;
        private static boolean startFromNextFrame = false;

        YieldVisitor(Pointer rootSp, Pointer verifyLeafSp, CodePointer leafIp) {
            if (verifyLeafSp.isNonNull() && !verifyLeafSp.belowThan((UnsignedWord)rootSp)) {
                throw VMError.shouldNotReachHere(String.format("expecting leafSp (%x) < rootSp (%x)", verifyLeafSp.rawValue(), rootSp.rawValue()));
            }
            this.rootSP = rootSp;
            this.leafSP = verifyLeafSp;
            this.leafIP = leafIp;
            this.expectedReferenceMap = CodeInfoAccess.getStackReferenceMapEncoding(CodeInfoTable.getImageCodeInfo());
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected boolean visitFrame(Pointer sp, CodePointer ip, CodeInfo codeInfo, DeoptimizedFrame deoptimizedFrame) {
            block6: {
                FrameInfoQueryResult frameInfo = CodeInfoTable.lookupCodeInfoQueryResult(codeInfo, ip).getFrameInfo();
                if (frameInfo.getSourceClass().equals(StoredContinuationImpl.class) && frameInfo.getSourceMethodName().equals("allocateFromStack")) {
                    this.preemptStatus = -2;
                    return false;
                }
                if (this.leafSP.isNull()) {
                    if (startFromNextFrame) {
                        this.leafSP = sp;
                        this.leafIP = ip;
                        break block6;
                    } else {
                        if (frameInfo.getSourceClass().equals(Safepoint.class) && frameInfo.getSourceMethodName().equals("enterSlowPathSafepointCheck")) {
                            startFromNextFrame = true;
                        }
                        return true;
                    }
                }
                if (this.frameSizeReferenceMapIndex.isEmpty()) {
                    VMError.guarantee(this.leafSP.equal((UnsignedWord)sp));
                    VMError.guarantee(this.leafIP.equal((ComparableWord)ip));
                }
            }
            VMError.guarantee(this.expectedReferenceMap.equal((ComparableWord)CodeInfoAccess.getStackReferenceMapEncoding(codeInfo)));
            long relIp = CodeInfoAccess.relativeIP(codeInfo, ip);
            int frameSize = TypeConversion.asU4((long)CodeInfoAccess.lookupTotalFrameSize(codeInfo, relIp));
            int referenceMapIndex = TypeConversion.asS4((long)CodeInfoAccess.lookupStackReferenceMapIndex(codeInfo, relIp));
            this.frameSizeReferenceMapIndex.add((Pair<Integer, Integer>)Pair.create((Object)frameSize, (Object)referenceMapIndex));
            Pointer currentFrameEnd = sp.add(frameSize);
            VMError.guarantee(currentFrameEnd.belowOrEqual((UnsignedWord)this.rootSP));
            return currentFrameEnd.notEqual((UnsignedWord)this.rootSP);
        }
    }

    public static interface RawFrameVisitor {
        public boolean visitRawFrame(int var1, Pointer var2);
    }
}

