/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.meta;

import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallLinkage;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodes.Cancellable;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.GraphEncoder;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GeneratedInvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.ParameterPlugin;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.SnippetParameterInfo;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;
import org.graalvm.compiler.replacements.ConstantBindingParameterPlugin;
import org.graalvm.compiler.replacements.PEGraphDecoder;
import org.graalvm.compiler.replacements.ReplacementsImpl;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.util.DirectAnnotationAccess;

public class SubstrateReplacements
extends ReplacementsImpl {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private Builder builder;
    private InvocationPlugins snippetInvocationPlugins;
    private byte[] snippetEncoding;
    private Object[] snippetObjects;
    private NodeClass<?>[] snippetNodeClasses;
    private Map<ResolvedJavaMethod, Integer> snippetStartOffsets;
    private final WordTypes wordTypes;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateReplacements(Providers providers, SnippetReflectionProvider snippetReflection, BytecodeProvider bytecodeProvider, TargetDescription target, WordTypes wordTypes, GraphMakerFactory graphMakerFactory) {
        super((DebugHandlersFactory)new GraalDebugHandlersFactory(snippetReflection), providers, snippetReflection, bytecodeProvider, target);
        this.wordTypes = wordTypes;
        this.builder = new Builder(graphMakerFactory);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerImmutableObjects(Feature.CompilationAccess access) {
        access.registerAsImmutable((Object)this);
        access.registerAsImmutable((Object)this.snippetEncoding);
        access.registerAsImmutable((Object)this.snippetObjects);
        access.registerAsImmutable(this.snippetNodeClasses);
        access.registerAsImmutable(this.snippetStartOffsets, SubstrateReplacements::isImmutable);
    }

    private static boolean isImmutable(Object o) {
        return !(o instanceof SubstrateForeignCallLinkage) && !(o instanceof SubstrateTargetDescription);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Collection<StructuredGraph> getSnippetGraphs(boolean trackNodeSourcePosition, OptionValues options) {
        ArrayList<StructuredGraph> result = new ArrayList<StructuredGraph>(this.snippetStartOffsets.size());
        for (ResolvedJavaMethod method : this.snippetStartOffsets.keySet()) {
            result.add(this.getSnippet(method, null, null, null, trackNodeSourcePosition, null, options));
        }
        return result;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public NodeClass<?>[] getSnippetNodeClasses() {
        return this.snippetNodeClasses;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Collection<ResolvedJavaMethod> getSnippetMethods() {
        return this.snippetStartOffsets.keySet();
    }

    public void setGraphBuilderPlugins(GraphBuilderConfiguration.Plugins plugins) {
        GraphBuilderConfiguration.Plugins copy = new GraphBuilderConfiguration.Plugins(plugins);
        copy.clearInlineInvokePlugins();
        for (InlineInvokePlugin plugin : plugins.getInlineInvokePlugins()) {
            copy.appendInlineInvokePlugin((InlineInvokePlugin)(plugin == this ? new SnippetInlineInvokePlugin() : plugin));
        }
        super.setGraphBuilderPlugins(copy);
    }

    public StructuredGraph getSnippet(final ResolvedJavaMethod method, ResolvedJavaMethod recursiveEntry, Object[] args, BitSet nonNullParameters, boolean trackNodeSourcePosition, NodeSourcePosition replaceePosition, OptionValues options) {
        Integer startOffset = this.snippetStartOffsets.get(method);
        if (startOffset == null) {
            throw VMError.shouldNotReachHere("snippet not found: " + method.format("%H.%n(%p)"));
        }
        ConstantBindingParameterPlugin parameterPlugin = null;
        if (args != null) {
            parameterPlugin = new ConstantBindingParameterPlugin(args, this.providers.getMetaAccess(), this.snippetReflection);
        }
        final EncodedGraph encodedGraph = new EncodedGraph(this.snippetEncoding, startOffset.intValue(), this.snippetObjects, this.snippetNodeClasses, null, null, false, trackNodeSourcePosition);
        try (DebugContext debug = this.openSnippetDebugContext("SVMSnippet_", method, options);){
            StructuredGraph result = new StructuredGraph.Builder(options, debug).method(method).trackNodeSourcePosition(trackNodeSourcePosition).recordInlinedMethods(false).setIsSubstitution(true).build();
            PEGraphDecoder graphDecoder = new PEGraphDecoder(ConfigurationValues.getTarget().arch, result, (CoreProviders)this.providers, null, this.snippetInvocationPlugins, new InlineInvokePlugin[0], (ParameterPlugin)parameterPlugin, null, null, null, new ConcurrentHashMap(), new ConcurrentHashMap(), true){
                private IntrinsicContext intrinsic;
                {
                    super(architecture, graph, providers, loopExplosionPlugin, invocationPlugins, inlineInvokePlugins, parameterPlugin, nodePlugins, peRootForInlining, sourceLanguagePositionProvider, specialCallTargetCache, invocationPluginCache, needsExplicitException);
                    this.intrinsic = new IntrinsicContext(method, null, this.providers.getReplacements().getDefaultReplacementBytecodeProvider(), IntrinsicContext.CompilationContext.INLINE_AFTER_PARSING, false);
                }

                protected EncodedGraph lookupEncodedGraph(ResolvedJavaMethod lookupMethod, BytecodeProvider intrinsicBytecodeProvider, boolean isSubstitution, boolean track) {
                    if (lookupMethod.equals(method)) {
                        assert (!track || encodedGraph.trackNodeSourcePosition());
                        return encodedGraph;
                    }
                    throw VMError.shouldNotReachHere(method.format("%H.%n(%p)"));
                }

                public IntrinsicContext getIntrinsic() {
                    return this.intrinsic;
                }
            };
            graphDecoder.decode(method, true, trackNodeSourcePosition);
            assert (result.verify());
            StructuredGraph structuredGraph = result;
            return structuredGraph;
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerSnippet(final ResolvedJavaMethod method, ResolvedJavaMethod original, final Object receiver, final boolean trackNodeSourcePosition, final OptionValues options) {
        assert (DirectAnnotationAccess.isAnnotationPresent((AnnotatedElement)method, Snippet.class)) : "Snippet must be annotated with @" + Snippet.class.getSimpleName() + " " + method;
        assert (method.hasBytecodes()) : "Snippet must not be abstract or native";
        assert (this.builder.graphs.get(method) == null) : "snippet registered twice: " + method.getName();
        assert (this.builder.registered.add(method)) : "snippet registered twice: " + method.getName();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try (DebugContext debug = SubstrateReplacements.this.openSnippetDebugContext("Snippet_", method, options);){
                    Object[] args = SubstrateReplacements.prepareConstantArguments(receiver);
                    StructuredGraph graph = SubstrateReplacements.this.makeGraph(debug, SubstrateReplacements.this.defaultBytecodeProvider, method, args, SnippetParameterInfo.getNonNullParameters((SnippetParameterInfo)SubstrateReplacements.this.getSnippetParameterInfo(method)), null, trackNodeSourcePosition, null);
                    for (MethodCallTargetNode callTarget : graph.getNodes(MethodCallTargetNode.TYPE)) {
                        ResolvedJavaMethod callee = callTarget.targetMethod();
                        if (SubstrateReplacements.this.builder.delayedInvocationPluginMethods.contains(callee)) continue;
                        throw VMError.shouldNotReachHere("method " + callee.format("%h.%n") + " not inlined in snippet " + method.format("%h.%n") + " (maybe not final?)");
                    }
                    SubstrateReplacements.this.builder.graphs.put(method, graph);
                }
            }
        };
        this.builder.deferred.add(run);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Set<ResolvedJavaMethod> getDelayedInvocationPluginMethods() {
        return this.builder.delayedInvocationPluginMethods;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void encodeSnippets() {
        GraphEncoder encoder = new GraphEncoder(ConfigurationValues.getTarget().arch);
        while (!this.builder.deferred.isEmpty()) {
            this.builder.deferred.pop().run();
        }
        for (StructuredGraph structuredGraph : this.builder.graphs.values()) {
            encoder.prepare(structuredGraph);
        }
        encoder.finishPrepare();
        this.snippetStartOffsets = new HashMap<ResolvedJavaMethod, Integer>();
        for (Map.Entry entry : this.builder.graphs.entrySet()) {
            this.snippetStartOffsets.put((ResolvedJavaMethod)entry.getKey(), encoder.encode((StructuredGraph)entry.getValue()));
        }
        this.snippetEncoding = encoder.getEncoding();
        this.snippetObjects = encoder.getObjects();
        this.snippetNodeClasses = encoder.getNodeClasses();
        this.snippetInvocationPlugins = SubstrateReplacements.makeInvocationPlugins(this.getGraphBuilderPlugins(), this.builder, Function.identity());
        this.builder.graphs.clear();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static InvocationPlugins makeInvocationPlugins(GraphBuilderConfiguration.Plugins plugins, Builder builder, Function<Object, Object> objectReplacer) {
        HashMap<ResolvedJavaMethod, InvocationPlugin> result = new HashMap<ResolvedJavaMethod, InvocationPlugin>(builder.delayedInvocationPluginMethods.size());
        for (ResolvedJavaMethod method : builder.delayedInvocationPluginMethods) {
            ResolvedJavaMethod replacedMethod = (ResolvedJavaMethod)objectReplacer.apply(method);
            InvocationPlugin plugin = plugins.getInvocationPlugins().lookupInvocation(replacedMethod, HostedOptionValues.singleton());
            assert (plugin != null) : "expected invocation plugin for " + replacedMethod;
            result.put(replacedMethod, plugin);
        }
        return new InvocationPlugins(result, null);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected void copyFrom(SubstrateReplacements copyFrom, Function<Object, Object> objectReplacer) {
        this.snippetInvocationPlugins = SubstrateReplacements.makeInvocationPlugins(this.getGraphBuilderPlugins(), copyFrom.builder, objectReplacer);
        this.snippetEncoding = Arrays.copyOf(copyFrom.snippetEncoding, copyFrom.snippetEncoding.length);
        this.snippetNodeClasses = Arrays.copyOf(copyFrom.snippetNodeClasses, copyFrom.snippetNodeClasses.length);
        this.snippetObjects = new Object[copyFrom.snippetObjects.length];
        for (int i = 0; i < this.snippetObjects.length; ++i) {
            this.snippetObjects[i] = objectReplacer.apply(copyFrom.snippetObjects[i]);
        }
        this.snippetStartOffsets = new HashMap<ResolvedJavaMethod, Integer>(copyFrom.snippetStartOffsets.size());
        for (Map.Entry<ResolvedJavaMethod, Integer> entry : copyFrom.snippetStartOffsets.entrySet()) {
            this.snippetStartOffsets.put((ResolvedJavaMethod)objectReplacer.apply(entry.getKey()), entry.getValue());
        }
    }

    public boolean hasSubstitution(ResolvedJavaMethod method, OptionValues options) {
        return false;
    }

    public StructuredGraph getInlineSubstitution(ResolvedJavaMethod original, int invokeBci, Invoke.InlineControl inlineControl, boolean trackNodeSourcePosition, NodeSourcePosition replaceePosiion, StructuredGraph.AllowAssumptions allowAssumptions, OptionValues options) {
        return null;
    }

    public StructuredGraph getIntrinsicGraph(ResolvedJavaMethod method, CompilationIdentifier compilationId, DebugContext debug, StructuredGraph.AllowAssumptions allowAssumptions, Cancellable cancellable) {
        return null;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected final ReplacementsImpl.GraphMaker createGraphMaker(ResolvedJavaMethod substitute, ResolvedJavaMethod substitutedMethod) {
        return this.builder.graphMakerFactory.create(this, substitute, substitutedMethod);
    }

    private static Object[] prepareConstantArguments(Object receiver) {
        if (receiver != null) {
            return new Object[]{receiver};
        }
        return null;
    }

    public <T> T getInjectedArgument(Class<T> capability) {
        if (capability.isAssignableFrom(WordTypes.class)) {
            return (T)this.wordTypes;
        }
        return (T)super.getInjectedArgument(capability);
    }

    public Stamp getInjectedStamp(Class<?> type, boolean nonNull) {
        JavaKind kind = JavaKind.fromJavaClass(type);
        if (kind == JavaKind.Object) {
            ResolvedJavaType returnType = this.providers.getMetaAccess().lookupJavaType(type);
            if (this.wordTypes.isWord((JavaType)returnType)) {
                return this.wordTypes.getWordStamp(returnType);
            }
            return StampFactory.object((TypeReference)TypeReference.createWithoutAssumptions((ResolvedJavaType)returnType), (boolean)nonNull);
        }
        return StampFactory.forKind((JavaKind)kind);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected class SnippetInlineInvokePlugin
    implements InlineInvokePlugin {
        protected SnippetInlineInvokePlugin() {
        }

        public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
            assert (b.parsingIntrinsic());
            assert (SubstrateReplacements.this.builder != null);
            Class intrinsifyingPlugin = SubstrateReplacements.this.getIntrinsifyingPlugin(method);
            if (intrinsifyingPlugin != null && GeneratedInvocationPlugin.class.isAssignableFrom(intrinsifyingPlugin)) {
                SubstrateReplacements.this.builder.delayedInvocationPluginMethods.add(method);
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            return InlineInvokePlugin.InlineInfo.createIntrinsicInlineInfo((ResolvedJavaMethod)method, (BytecodeProvider)SubstrateReplacements.this.defaultBytecodeProvider);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected static class Builder {
        protected final GraphMakerFactory graphMakerFactory;
        protected final Map<ResolvedJavaMethod, StructuredGraph> graphs;
        protected final Deque<Runnable> deferred;
        protected final HashSet<ResolvedJavaMethod> registered;
        protected final Set<ResolvedJavaMethod> delayedInvocationPluginMethods;

        protected Builder(GraphMakerFactory graphMakerFactory) {
            this.graphMakerFactory = graphMakerFactory;
            this.graphs = new HashMap<ResolvedJavaMethod, StructuredGraph>();
            this.deferred = new ArrayDeque<Runnable>();
            this.registered = new HashSet();
            this.delayedInvocationPluginMethods = new HashSet<ResolvedJavaMethod>();
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static interface GraphMakerFactory {
        public ReplacementsImpl.GraphMaker create(ReplacementsImpl var1, ResolvedJavaMethod var2, ResolvedJavaMethod var3);
    }
}

