/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.JfrGCEventSupport;
import com.oracle.svm.core.heap.GCCause;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.UnsignedWord;

class JfrGCEvents {
    JfrGCEvents() {
    }

    public static long getTicks() {
        if (!JfrGCEvents.hasJfrSupport()) {
            return 0L;
        }
        return JfrGCEvents.jfrSupport().getTicks();
    }

    public static long startGCPhasePause() {
        if (!JfrGCEvents.hasJfrSupport()) {
            return 0L;
        }
        return JfrGCEvents.jfrSupport().startGCPhasePause();
    }

    public static void emitGarbageCollectionEvent(UnsignedWord gcEpoch, GCCause cause, long start) {
        if (!JfrGCEvents.hasJfrSupport()) {
            return;
        }
        JfrGCEvents.jfrSupport().emitGarbageCollectionEvent(gcEpoch, cause, start);
    }

    public static void emitGCPhasePauseEvent(UnsignedWord gcEpoch, String name, long startTicks) {
        if (!JfrGCEvents.hasJfrSupport()) {
            return;
        }
        JfrGCEvents.jfrSupport().emitGCPhasePauseEvent(gcEpoch, name, startTicks);
    }

    @Fold
    static boolean hasJfrSupport() {
        return ImageSingletons.contains(JfrGCEventSupport.class);
    }

    @Fold
    static JfrGCEventSupport jfrSupport() {
        return (JfrGCEventSupport)ImageSingletons.lookup(JfrGCEventSupport.class);
    }
}

