/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.c;

import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.ComparableWord;

@Platforms(value={Platform.HOSTED_ONLY.class})
class HostedNonmovableArray<T>
implements NonmovableArray<T> {
    private final Object array;

    HostedNonmovableArray(Object array) {
        this.array = array;
    }

    Object getArray() {
        return this.array;
    }

    public boolean equal(ComparableWord val) {
        if (val != this && val instanceof HostedNonmovableArray) {
            return ((HostedNonmovableArray)val).array == this.array;
        }
        return val == this;
    }

    public boolean notEqual(ComparableWord val) {
        return !this.equal(val);
    }

    public boolean isNull() {
        return this.array == null;
    }

    public boolean isNonNull() {
        return !this.isNull();
    }

    public long rawValue() {
        throw VMError.shouldNotReachHere("The image heap contains an instance of NonmovableArray, which is currently not supported. Unwrap the actual array object using NonmovableArrays.getHostedArray() and reference it directly, then use NonmovableArrays.fromImageHeap() at runtime.");
    }

    @Deprecated
    public boolean equals(Object obj) {
        throw VMError.shouldNotReachHere("equals() not supported on words");
    }

    public int hashCode() {
        throw VMError.shouldNotReachHere("hashCode() not supported on words");
    }
}

