/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.CalleeSavedRegisters;
import com.oracle.svm.core.RegisterDumper;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.RuntimeCodeInfoHistory;
import com.oracle.svm.core.code.RuntimeCodeInfoMemory;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.locks.VMLockSupport;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.stack.JavaFrameAnchor;
import com.oracle.svm.core.stack.JavaFrameAnchors;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.ThreadStackPrinter;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMOperationControl;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.FastThreadLocalBytes;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfos;
import com.oracle.svm.core.util.Counter;
import java.util.Arrays;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class SubstrateDiagnostics {
    private static final FastThreadLocalBytes<CCharPointer> threadOnlyAttachedForCrashHandler = FastThreadLocalFactory.createBytes(() -> 1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setOnlyAttachedForCrashHandler(IsolateThread thread) {
        threadOnlyAttachedForCrashHandler.getAddress(thread).write((byte)1);
    }

    private static boolean isThreadOnlyAttachedForCrashHandler(IsolateThread thread) {
        return threadOnlyAttachedForCrashHandler.getAddress(thread).read() != 0;
    }

    @Fold
    static FatalErrorState fatalErrorState() {
        return (FatalErrorState)ImageSingletons.lookup(FatalErrorState.class);
    }

    public static boolean isFatalErrorHandlingInProgress() {
        return SubstrateDiagnostics.fatalErrorState().diagnosticThread.get().isNonNull();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isFatalErrorHandlingThread() {
        return SubstrateDiagnostics.fatalErrorState().diagnosticThread.get() == CurrentIsolate.getCurrentThread();
    }

    public static int maxInvocations() {
        int result = 0;
        DiagnosticThunkRegistry thunks = DiagnosticThunkRegistry.singleton();
        for (int i = 0; i < thunks.size(); ++i) {
            result += thunks.getThunk(i).maxInvocationCount();
        }
        return result;
    }

    public static void printLocationInfo(Log log, UnsignedWord value, boolean allowJavaHeapAccess, boolean allowUnsafeOperations) {
        if (value.notEqual(0) && !RuntimeCodeInfoMemory.singleton().printLocationInfo(log, value, allowJavaHeapAccess, allowUnsafeOperations) && !VMThreads.printLocationInfo(log, value, allowUnsafeOperations) && !Heap.getHeap().printLocationInfo(log, value, allowJavaHeapAccess, allowUnsafeOperations)) {
            log.string("is an unknown value");
        }
    }

    public static void printInformation(Log log, Pointer sp, CodePointer ip) {
        SubstrateDiagnostics.printInformation(log, sp, ip, (RegisterDumper.Context)WordFactory.nullPointer(), false);
    }

    public static void printInformation(Log log, Pointer sp, CodePointer ip, RegisterDumper.Context registerContext, boolean frameHasCalleeSavedRegisters) {
        ErrorContext errorContext = (ErrorContext)StackValue.get(ErrorContext.class);
        errorContext.setStackPointer(sp);
        errorContext.setInstructionPointer(ip);
        errorContext.setRegisterContext(registerContext);
        errorContext.setFrameHasCalleeSavedRegisters(frameHasCalleeSavedRegisters);
        int numDiagnosticThunks = DiagnosticThunkRegistry.singleton().size();
        for (int i = 0; i < numDiagnosticThunks; ++i) {
            DiagnosticThunk thunk = DiagnosticThunkRegistry.singleton().getThunk(i);
            int invocationCount = DiagnosticThunkRegistry.singleton().getInitialInvocationCount(i);
            if (invocationCount > thunk.maxInvocationCount()) continue;
            thunk.printDiagnostics(log, errorContext, 1, invocationCount);
        }
    }

    public static boolean printFatalError(Log log, Pointer sp, CodePointer ip) {
        return SubstrateDiagnostics.printFatalError(log, sp, ip, (RegisterDumper.Context)WordFactory.nullPointer(), false);
    }

    public static boolean printFatalError(Log log, Pointer sp, CodePointer ip, RegisterDumper.Context registerContext, boolean frameHasCalleeSavedRegisters) {
        log.newline();
        if (!SubstrateDiagnostics.fatalErrorState().trySet(log, sp, ip, registerContext, frameHasCalleeSavedRegisters) && !SubstrateDiagnostics.isFatalErrorHandlingThread()) {
            log.string("Error: printDiagnostics already in progress by another thread.").newline();
            log.newline();
            return false;
        }
        SubstrateDiagnostics.printFatalErrorForCurrentState();
        return true;
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="This method is single threaded. The fields 'diagnosticThunkIndex' and 'invocationCount' are only volatile to ensure that the updated field values are written right away.")
    private static void printFatalErrorForCurrentState() {
        assert (SubstrateDiagnostics.isFatalErrorHandlingThread());
        FatalErrorState fatalErrorState = SubstrateDiagnostics.fatalErrorState();
        Log log = fatalErrorState.log;
        if (fatalErrorState.diagnosticThunkIndex > 0) {
            log.resetIndentation();
        }
        ErrorContext errorContext = fatalErrorState.getErrorContext();
        int numDiagnosticThunks = DiagnosticThunkRegistry.singleton().size();
        while (fatalErrorState.diagnosticThunkIndex < numDiagnosticThunks) {
            int index = fatalErrorState.diagnosticThunkIndex;
            DiagnosticThunk thunk = DiagnosticThunkRegistry.singleton().getThunk(index);
            if (fatalErrorState.invocationCount == 0) {
                fatalErrorState.invocationCount = DiagnosticThunkRegistry.singleton().getInitialInvocationCount(index) - 1;
            }
            while (++fatalErrorState.invocationCount <= thunk.maxInvocationCount()) {
                try {
                    thunk.printDiagnostics(log, errorContext, 3, fatalErrorState.invocationCount);
                    break;
                }
                catch (Throwable e) {
                    SubstrateDiagnostics.dumpException(log, thunk, e);
                }
            }
            ++fatalErrorState.diagnosticThunkIndex;
            fatalErrorState.invocationCount = 0;
        }
        fatalErrorState.clear();
    }

    static void dumpRuntimeCompilation(Log log) {
        assert (VMOperation.isInProgressAtSafepoint());
        try {
            RuntimeCodeInfoHistory.singleton().printRecentOperations(log, true);
        }
        catch (Exception e) {
            SubstrateDiagnostics.dumpException(log, "DumpCodeCacheHistory", (Throwable)e);
        }
        log.newline();
        try {
            boolean allowJavaHeapAccess = DiagnosticLevel.javaHeapAccessAllowed(1);
            boolean allowUnsafeOperations = DiagnosticLevel.unsafeOperationsAllowed(1);
            RuntimeCodeInfoMemory.singleton().printTable(log, allowJavaHeapAccess, allowUnsafeOperations);
        }
        catch (Exception e) {
            SubstrateDiagnostics.dumpException(log, "DumpRuntimeCodeInfoMemory", (Throwable)e);
        }
        log.newline();
        try {
            Deoptimizer.logRecentDeoptimizationEvents(log);
        }
        catch (Exception e) {
            SubstrateDiagnostics.dumpException(log, "DumpRecentDeoptimizations", (Throwable)e);
        }
    }

    private static void dumpException(Log log, DiagnosticThunk thunk, Throwable e) {
        SubstrateDiagnostics.dumpException(log, thunk.getClass().getName(), e);
    }

    private static void dumpException(Log log, String currentDumper, Throwable e) {
        log.newline().string("[!!! Exception while executing ").string(currentDumper).string(": ").string(e.getClass().getName()).string("]");
        log.resetIndentation().newline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
    private static long getTotalFrameSize(Pointer sp, CodePointer ip) {
        DeoptimizedFrame deoptFrame = Deoptimizer.checkDeoptimized(sp);
        if (deoptFrame != null) {
            return deoptFrame.getSourceTotalFrameSize();
        }
        UntetheredCodeInfo untetheredInfo = CodeInfoTable.lookupCodeInfo(ip);
        if (untetheredInfo.isNonNull()) {
            Object tether = CodeInfoAccess.acquireTether(untetheredInfo);
            try {
                CodeInfo codeInfo = CodeInfoAccess.convert(untetheredInfo, tether);
                long l = SubstrateDiagnostics.getTotalFrameSize0(ip, codeInfo);
                return l;
            }
            finally {
                CodeInfoAccess.releaseTether(untetheredInfo, tether);
            }
        }
        return -1L;
    }

    @Uninterruptible(reason="Wrap the now safe call to interruptibly look up the frame size.", calleeMustBe=false)
    private static long getTotalFrameSize0(CodePointer ip, CodeInfo codeInfo) {
        return CodeInfoAccess.lookupTotalFrameSize(codeInfo, CodeInfoAccess.relativeIP(codeInfo, ip));
    }

    private static void logFrameAnchors(Log log, IsolateThread thread) {
        JavaFrameAnchor anchor = JavaFrameAnchors.getFrameAnchor(thread);
        if (anchor.isNull()) {
            log.string("No anchors").newline();
        }
        while (anchor.isNonNull()) {
            log.string("Anchor ").zhex(anchor.rawValue()).string(" LastJavaSP ").zhex(anchor.getLastJavaSP().rawValue()).string(" LastJavaIP ").zhex(anchor.getLastJavaIP().rawValue()).newline();
            anchor = anchor.getPreviousAnchor();
        }
    }

    public static void updateInitialInvocationCounts(String configuration) throws IllegalArgumentException {
        String entry;
        int end;
        int pos = 0;
        while ((end = configuration.indexOf(44, pos)) >= 0) {
            entry = configuration.substring(pos, end);
            SubstrateDiagnostics.updateInitialInvocationCount(entry);
            pos = end + 1;
        }
        entry = configuration.substring(pos);
        SubstrateDiagnostics.updateInitialInvocationCount(entry);
    }

    private static void updateInitialInvocationCount(String entry) throws IllegalArgumentException {
        int pos = entry.indexOf(58);
        if (pos <= 0 || pos == entry.length() - 1) {
            throw new IllegalArgumentException("'" + entry + "' has an invalid format.");
        }
        String pattern = entry.substring(0, pos);
        int initialInvocationCount = SubstrateDiagnostics.parseInvocationCount(entry, pos);
        int matches = 0;
        int numDiagnosticThunks = DiagnosticThunkRegistry.singleton().size();
        for (int i = 0; i < numDiagnosticThunks; ++i) {
            DiagnosticThunk thunk = DiagnosticThunkRegistry.singleton().getThunk(i);
            if (!SubstrateDiagnostics.matches(thunk.getClass().getSimpleName(), pattern)) continue;
            DiagnosticThunkRegistry.singleton().setInitialInvocationCount(i, initialInvocationCount);
            ++matches;
        }
        if (matches == 0) {
            throw new IllegalArgumentException("the pattern '" + entry + "' not match any diagnostic thunk.");
        }
    }

    private static int parseInvocationCount(String entry, int pos) {
        int initialInvocationCount = 0;
        try {
            initialInvocationCount = Integer.parseInt(entry.substring(pos + 1));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (initialInvocationCount < 1) {
            throw new IllegalArgumentException("'" + entry + "' does not specify an integer value >= 1.");
        }
        return initialInvocationCount;
    }

    private static boolean matches(String text, String pattern) {
        assert (pattern.length() > 0);
        return SubstrateDiagnostics.matches(text, 0, pattern, 0);
    }

    private static boolean matches(String text, int t, String pattern, int p) {
        int textPos = t;
        int patternPos = p;
        while (textPos < text.length()) {
            if (patternPos >= pattern.length()) {
                return false;
            }
            if (pattern.charAt(patternPos) == '*') {
                if (patternPos + 1 >= pattern.length()) {
                    return true;
                }
                while (textPos < text.length()) {
                    if (SubstrateDiagnostics.matches(text, textPos, pattern, patternPos + 1)) {
                        return true;
                    }
                    ++textPos;
                }
                return false;
            }
            if (text.charAt(textPos) == pattern.charAt(patternPos)) {
                ++textPos;
                ++patternPos;
                continue;
            }
            return false;
        }
        while (patternPos < pattern.length() && pattern.charAt(patternPos) == '*') {
            ++patternPos;
        }
        return patternPos == pattern.length();
    }

    public static class DiagnosticThunkRegistry {
        private DiagnosticThunk[] diagnosticThunks = new DiagnosticThunk[]{new DumpRegisters(), new DumpInstructions(), new DumpTopOfCurrentThreadStack(), new DumpDeoptStubPointer(), new DumpTopFrame(), new DumpThreads(), new DumpCurrentThreadLocals(), new DumpCurrentVMOperation(), new DumpVMOperationHistory(), new DumpCodeCacheHistory(), new DumpRuntimeCodeInfoMemory(), new DumpRecentDeoptimizations(), new DumpCounters(), new DumpCurrentThreadFrameAnchors(), new DumpCurrentThreadDecodedStackTrace(), new DumpOtherStackTraces(), new VMLockSupport.DumpVMMutexes()};
        private int[] initialInvocationCount = new int[this.diagnosticThunks.length];

        @Fold
        public static synchronized DiagnosticThunkRegistry singleton() {
            if (!ImageSingletons.contains(DiagnosticThunkRegistry.class)) {
                ImageSingletons.add(DiagnosticThunkRegistry.class, (Object)new DiagnosticThunkRegistry());
            }
            return (DiagnosticThunkRegistry)ImageSingletons.lookup(DiagnosticThunkRegistry.class);
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        DiagnosticThunkRegistry() {
            Arrays.fill(this.initialInvocationCount, 1);
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public synchronized void register(DiagnosticThunk diagnosticThunk) {
            this.diagnosticThunks = Arrays.copyOf(this.diagnosticThunks, this.diagnosticThunks.length + 1);
            this.diagnosticThunks[this.diagnosticThunks.length - 1] = diagnosticThunk;
            this.initialInvocationCount = Arrays.copyOf(this.initialInvocationCount, this.initialInvocationCount.length + 1);
            this.initialInvocationCount[this.initialInvocationCount.length - 1] = 1;
        }

        @Fold
        int size() {
            return this.diagnosticThunks.length;
        }

        DiagnosticThunk getThunk(int index) {
            return this.diagnosticThunks[index];
        }

        int getInitialInvocationCount(int index) {
            return this.initialInvocationCount[index];
        }

        void setInitialInvocationCount(int index, int value) {
            this.initialInvocationCount[index] = value;
        }
    }

    public static abstract class DiagnosticThunk {
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate during printing diagnostics.")
        public abstract void printDiagnostics(Log var1, ErrorContext var2, int var3, int var4);

        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public abstract int maxInvocationCount();
    }

    @RawStructure
    public static interface ErrorContext
    extends PointerBase {
        @RawField
        public Pointer getStackPointer();

        @RawField
        public void setStackPointer(Pointer var1);

        @RawField
        public CodePointer getInstructionPointer();

        @RawField
        public void setInstructionPointer(CodePointer var1);

        @RawField
        public RegisterDumper.Context getRegisterContext();

        @RawField
        public void setRegisterContext(RegisterDumper.Context var1);

        @RawField
        public boolean frameHasCalleeSavedRegisters();

        @RawField
        public void setFrameHasCalleeSavedRegisters(boolean var1);
    }

    public static class DiagnosticLevel {
        private static final int JAVA_HEAP_ACCESS = 1;
        private static final int UNSAFE_ACCESS = 2;
        private static final int SAFE = 1;
        private static final int FULL = 3;

        public static boolean javaHeapAccessAllowed(int level) {
            return (level & 1) != 0;
        }

        public static boolean unsafeOperationsAllowed(int level) {
            return (level & 2) != 0;
        }
    }

    private static class DumpOtherStackTraces
    extends DiagnosticThunk {
        private DumpOtherStackTraces() {
        }

        @Override
        public int maxInvocationCount() {
            return 1;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            if (VMOperation.isInProgressAtSafepoint()) {
                IsolateThread vmThread = VMThreads.firstThreadUnsafe();
                while (vmThread.isNonNull()) {
                    if (vmThread != CurrentIsolate.getCurrentThread()) {
                        try {
                            log.string("Thread ").zhex((WordBase)vmThread).string(":").indent(true);
                            DumpOtherStackTraces.printFrameAnchors(log, vmThread);
                            DumpOtherStackTraces.printStackTrace(log, vmThread);
                            log.indent(false);
                        }
                        catch (Exception e) {
                            SubstrateDiagnostics.dumpException(log, this, e);
                        }
                    }
                    vmThread = VMThreads.nextThread(vmThread);
                }
            }
        }

        private static void printFrameAnchors(Log log, IsolateThread vmThread) {
            log.string("Frame anchors:").indent(true);
            SubstrateDiagnostics.logFrameAnchors(log, vmThread);
            log.indent(false);
        }

        private static void printStackTrace(Log log, IsolateThread vmThread) {
            log.string("Stacktrace:").indent(true);
            JavaStackWalker.walkThread(vmThread, ThreadStackPrinter.StackFramePrintVisitor.SINGLETON, log);
            log.redent(false);
        }
    }

    private static class DumpCurrentThreadDecodedStackTrace
    extends DiagnosticThunk {
        private static final ThreadStackPrinter.Stage0StackFramePrintVisitor[] PRINT_VISITORS = new ThreadStackPrinter.Stage0StackFramePrintVisitor[]{ThreadStackPrinter.StackFramePrintVisitor.SINGLETON, ThreadStackPrinter.Stage1StackFramePrintVisitor.SINGLETON, ThreadStackPrinter.Stage0StackFramePrintVisitor.SINGLETON};

        private DumpCurrentThreadDecodedStackTrace() {
        }

        @Override
        public int maxInvocationCount() {
            return 3;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            Pointer sp = context.getStackPointer();
            CodePointer ip = context.getInstructionPointer();
            log.string("Stacktrace for the failing thread ").zhex((WordBase)CurrentIsolate.getCurrentThread()).string(":").indent(true);
            ThreadStackPrinter.printStacktrace(sp, ip, PRINT_VISITORS[invocationCount - 1], log);
            log.indent(false);
        }
    }

    private static class DumpCurrentThreadFrameAnchors
    extends DiagnosticThunk {
        private DumpCurrentThreadFrameAnchors() {
        }

        @Override
        public int maxInvocationCount() {
            return 1;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            IsolateThread currentThread = CurrentIsolate.getCurrentThread();
            log.string("Java frame anchors for the failing thread ").zhex((WordBase)currentThread).string(":").indent(true);
            SubstrateDiagnostics.logFrameAnchors(log, currentThread);
            log.indent(false);
        }
    }

    private static class DumpCounters
    extends DiagnosticThunk {
        private DumpCounters() {
        }

        @Override
        public int maxInvocationCount() {
            return 1;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            log.string("Counters:").indent(true);
            Counter.logValues(log);
            log.indent(false);
        }
    }

    private static class DumpRecentDeoptimizations
    extends DiagnosticThunk {
        private DumpRecentDeoptimizations() {
        }

        @Override
        public int maxInvocationCount() {
            return 1;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            if (DeoptimizationSupport.enabled()) {
                Deoptimizer.logRecentDeoptimizationEvents(log);
            }
        }
    }

    private static class DumpRuntimeCodeInfoMemory
    extends DiagnosticThunk {
        private DumpRuntimeCodeInfoMemory() {
        }

        @Override
        public int maxInvocationCount() {
            return 3;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            if (DeoptimizationSupport.enabled()) {
                boolean allowJavaHeapAccess = DiagnosticLevel.javaHeapAccessAllowed(maxDiagnosticLevel) && invocationCount < 3;
                boolean allowUnsafeOperations = DiagnosticLevel.unsafeOperationsAllowed(maxDiagnosticLevel) && invocationCount < 2;
                RuntimeCodeInfoMemory.singleton().printTable(log, allowJavaHeapAccess, allowUnsafeOperations);
            }
        }
    }

    private static class DumpCodeCacheHistory
    extends DiagnosticThunk {
        private DumpCodeCacheHistory() {
        }

        @Override
        public int maxInvocationCount() {
            return 2;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            if (DeoptimizationSupport.enabled()) {
                boolean allowJavaHeapAccess = DiagnosticLevel.javaHeapAccessAllowed(maxDiagnosticLevel) && invocationCount < 2;
                RuntimeCodeInfoHistory.singleton().printRecentOperations(log, allowJavaHeapAccess);
            }
        }
    }

    private static class DumpVMOperationHistory
    extends DiagnosticThunk {
        private DumpVMOperationHistory() {
        }

        @Override
        public int maxInvocationCount() {
            return 2;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            boolean allowJavaHeapAccess = DiagnosticLevel.javaHeapAccessAllowed(maxDiagnosticLevel) && invocationCount < 2;
            VMOperationControl.printRecentEvents(log, allowJavaHeapAccess);
        }
    }

    private static class DumpCurrentVMOperation
    extends DiagnosticThunk {
        private DumpCurrentVMOperation() {
        }

        @Override
        public int maxInvocationCount() {
            return 2;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            boolean allowJavaHeapAccess = DiagnosticLevel.javaHeapAccessAllowed(maxDiagnosticLevel) && invocationCount < 2;
            VMOperationControl.printCurrentVMOperation(log, allowJavaHeapAccess);
            log.newline();
        }
    }

    private static class DumpCurrentThreadLocals
    extends DiagnosticThunk {
        private DumpCurrentThreadLocals() {
        }

        @Override
        public int maxInvocationCount() {
            return 2;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            IsolateThread currentThread = CurrentIsolate.getCurrentThread();
            if (SubstrateDiagnostics.isThreadOnlyAttachedForCrashHandler(currentThread)) {
                if (invocationCount == 1) {
                    log.string("The failing thread ").zhex((WordBase)currentThread).string(" does not have a full set of VM thread locals as it is an unattached thread.").newline();
                    log.newline();
                }
            } else {
                log.string("VM thread locals for the failing thread ").zhex((WordBase)currentThread).string(":").indent(true);
                boolean allowJavaHeapAccess = DiagnosticLevel.javaHeapAccessAllowed(maxDiagnosticLevel) && invocationCount < 2;
                VMThreadLocalInfos.dumpToLog(log, currentThread, allowJavaHeapAccess);
                log.indent(false);
            }
        }
    }

    private static class DumpThreads
    extends DiagnosticThunk {
        private DumpThreads() {
        }

        @Override
        public int maxInvocationCount() {
            return 3;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            boolean allowUnsafeOperations;
            boolean allowJavaHeapAccess = DiagnosticLevel.javaHeapAccessAllowed(maxDiagnosticLevel) && invocationCount < 3;
            boolean bl = allowUnsafeOperations = DiagnosticLevel.unsafeOperationsAllowed(maxDiagnosticLevel) && invocationCount < 2;
            if (allowUnsafeOperations || VMOperation.isInProgressAtSafepoint()) {
                log.string("Threads:").indent(true);
                IsolateThread thread = VMThreads.firstThreadUnsafe();
                while (thread.isNonNull()) {
                    log.zhex((WordBase)thread).spaces(1).string(VMThreads.StatusSupport.getStatusString(thread));
                    if (allowJavaHeapAccess) {
                        Thread threadObj = JavaThreads.fromVMThread(thread);
                        log.string(" \"").string(threadObj.getName()).string("\" - ").object(threadObj);
                        if (threadObj.isDaemon()) {
                            log.string(", daemon");
                        }
                    }
                    log.string(", stack(").zhex((WordBase)VMThreads.StackEnd.get(thread)).string(",").zhex((WordBase)VMThreads.StackBase.get(thread)).string(")");
                    log.newline();
                    thread = VMThreads.nextThread(thread);
                }
                log.indent(false);
            }
        }
    }

    private static class DumpTopFrame
    extends DiagnosticThunk {
        private DumpTopFrame() {
        }

        @Override
        public int maxInvocationCount() {
            return 1;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            Pointer sp = context.getStackPointer();
            CodePointer ip = context.getInstructionPointer();
            log.string("Top frame info:").indent(true);
            if (sp.isNonNull() && ip.isNonNull()) {
                long totalFrameSize = SubstrateDiagnostics.getTotalFrameSize(sp, ip);
                DeoptimizedFrame deoptFrame = Deoptimizer.checkDeoptimized(sp);
                if (deoptFrame != null) {
                    log.string("RSP ").zhex((WordBase)sp).string(" frame was deoptimized:").newline();
                    log.string("SourcePC ").zhex((WordBase)deoptFrame.getSourcePC()).newline();
                    log.string("SourceTotalFrameSize ").signed(totalFrameSize).newline();
                } else if (totalFrameSize != -1L) {
                    log.string("TotalFrameSize in CodeInfoTable ").signed(totalFrameSize).newline();
                }
                if (totalFrameSize == -1L) {
                    log.string("Does not look like a Java Frame. Use JavaFrameAnchors to find LastJavaSP:").newline();
                    JavaFrameAnchor anchor = JavaFrameAnchors.getFrameAnchor();
                    while (anchor.isNonNull() && anchor.getLastJavaSP().belowOrEqual((UnsignedWord)sp)) {
                        anchor = anchor.getPreviousAnchor();
                    }
                    if (anchor.isNonNull()) {
                        log.string("Found matching Anchor:").zhex((WordBase)anchor).newline();
                        Pointer lastSp = anchor.getLastJavaSP();
                        log.string("LastJavaSP ").zhex((WordBase)lastSp).newline();
                        CodePointer lastIp = anchor.getLastJavaIP();
                        log.string("LastJavaIP ").zhex((WordBase)lastIp).newline();
                    }
                }
            }
            log.indent(false);
        }
    }

    private static class DumpDeoptStubPointer
    extends DiagnosticThunk {
        private DumpDeoptStubPointer() {
        }

        @Override
        public int maxInvocationCount() {
            return 1;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            if (DeoptimizationSupport.enabled()) {
                log.string("DeoptStubPointer address: ").zhex((WordBase)DeoptimizationSupport.getDeoptStubPointer()).newline().newline();
            }
        }
    }

    private static class DumpTopOfCurrentThreadStack
    extends DiagnosticThunk {
        private DumpTopOfCurrentThreadStack() {
        }

        @Override
        public int maxInvocationCount() {
            return 1;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            Pointer sp = context.getStackPointer();
            UnsignedWord stackBase = VMThreads.StackBase.get();
            log.string("Top of stack (sp=").zhex((WordBase)sp).string("):").indent(true);
            int bytesToPrint = DumpTopOfCurrentThreadStack.computeBytesToPrint(sp, stackBase);
            log.hexdump((PointerBase)sp, 8, bytesToPrint / 8);
            log.indent(false).newline();
        }

        private static int computeBytesToPrint(Pointer sp, UnsignedWord stackBase) {
            if (stackBase.equal(0)) {
                return 128;
            }
            int bytesToPrint = 512;
            UnsignedWord availableBytes = stackBase.subtract((UnsignedWord)sp);
            if (availableBytes.belowThan(bytesToPrint)) {
                bytesToPrint = NumUtil.safeToInt((long)availableBytes.rawValue());
            }
            return bytesToPrint;
        }
    }

    private static class DumpInstructions
    extends DiagnosticThunk {
        private DumpInstructions() {
        }

        @Override
        public int maxInvocationCount() {
            return 3;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            if (invocationCount < 3) {
                DumpInstructions.printBytesBeforeAndAfterIp(log, context.getInstructionPointer(), invocationCount);
            } else if (invocationCount == 3) {
                DumpInstructions.printWord(log, context.getInstructionPointer());
            }
        }

        private static void printBytesBeforeAndAfterIp(Log log, CodePointer ip, int invocationCount) {
            int bytesToPrint = 64 >> invocationCount;
            DumpInstructions.hexDump(log, ip, bytesToPrint, bytesToPrint);
        }

        private static void printWord(Log log, CodePointer ip) {
            DumpInstructions.hexDump(log, ip, 0, ConfigurationValues.getTarget().wordSize);
        }

        private static void hexDump(Log log, CodePointer ip, int bytesBefore, int bytesAfter) {
            log.string("Printing Instructions (ip=").zhex((WordBase)ip).string("):").indent(true);
            log.hexdump((PointerBase)((Pointer)ip).subtract(bytesBefore), 1, bytesBefore + bytesAfter);
            log.indent(false).newline();
        }
    }

    private static class DumpRegisters
    extends DiagnosticThunk {
        private DumpRegisters() {
        }

        @Override
        public int maxInvocationCount() {
            return 4;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            boolean allowUnsafeOperations;
            boolean printLocationInfo = invocationCount < 4;
            boolean allowJavaHeapAccess = DiagnosticLevel.javaHeapAccessAllowed(maxDiagnosticLevel) && invocationCount < 3;
            boolean bl = allowUnsafeOperations = DiagnosticLevel.unsafeOperationsAllowed(maxDiagnosticLevel) && invocationCount < 2;
            if (context.getRegisterContext().isNonNull()) {
                log.string("General purpose register values:").indent(true);
                RegisterDumper.singleton().dumpRegisters(log, context.getRegisterContext(), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
                log.indent(false);
            } else if (CalleeSavedRegisters.supportedByPlatform() && context.frameHasCalleeSavedRegisters()) {
                CalleeSavedRegisters.singleton().dumpRegisters(log, context.getStackPointer(), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
            }
        }
    }

    public static class FatalErrorState {
        UninterruptibleUtils.AtomicWord<IsolateThread> diagnosticThread = new UninterruptibleUtils.AtomicWord();
        volatile int diagnosticThunkIndex = 0;
        volatile int invocationCount = 0;
        Log log = null;
        private final byte[] errorContextData;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public FatalErrorState() {
            int errorContextSize = SizeOf.get(ErrorContext.class);
            this.errorContextData = new byte[errorContextSize];
        }

        public ErrorContext getErrorContext() {
            return (ErrorContext)NonmovableArrays.addressOf(NonmovableArrays.fromImageHeap((Object)this.errorContextData), 0);
        }

        public boolean trySet(Log log, Pointer sp, CodePointer ip, RegisterDumper.Context registerContext, boolean frameHasCalleeSavedRegisters) {
            if (this.diagnosticThread.compareAndSet((IsolateThread)WordFactory.nullPointer(), CurrentIsolate.getCurrentThread())) {
                assert (this.diagnosticThunkIndex == 0);
                assert (this.invocationCount == 0);
                this.log = log;
                ErrorContext errorContext = this.getErrorContext();
                errorContext.setStackPointer(sp);
                errorContext.setInstructionPointer(ip);
                errorContext.setRegisterContext(registerContext);
                errorContext.setFrameHasCalleeSavedRegisters(frameHasCalleeSavedRegisters);
                return true;
            }
            return false;
        }

        public void clear() {
            this.log = null;
            ErrorContext errorContext = this.getErrorContext();
            errorContext.setStackPointer((Pointer)WordFactory.nullPointer());
            errorContext.setInstructionPointer((CodePointer)WordFactory.nullPointer());
            errorContext.setRegisterContext((RegisterDumper.Context)WordFactory.nullPointer());
            errorContext.setFrameHasCalleeSavedRegisters(false);
            this.diagnosticThunkIndex = 0;
            this.invocationCount = 0;
            this.diagnosticThread.set((IsolateThread)WordFactory.nullPointer());
        }
    }
}

