/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;

final class IgnoreSIGPIPEStartupHook
implements Runnable {
    private static final CEntryPointLiteral<Signal.SignalDispatcher> NOOP_SIGNAL_HANDLER = CEntryPointLiteral.create(IgnoreSIGPIPEStartupHook.class, (String)"noopSignalHandler", (Class[])new Class[]{Integer.TYPE});

    IgnoreSIGPIPEStartupHook() {
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    @Uninterruptible(reason="empty signal handler, Isolate is not set up")
    static void noopSignalHandler(int sig) {
    }

    @Override
    public void run() {
        Signal.SignalDispatcher signalResult = PosixUtils.installSignalHandler(Signal.SignalEnum.SIGPIPE.getCValue(), (Signal.SignalDispatcher)NOOP_SIGNAL_HANDLER.getFunctionPointer());
        VMError.guarantee(signalResult != Signal.SIG_ERR(), "IgnoreSIGPIPEFeature.run: Could not ignore SIGPIPE");
    }
}

