/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.meta;

import com.oracle.svm.core.meta.ObjectConstantEquality;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Array;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MethodHandleAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;

public abstract class SharedConstantReflectionProvider
implements ConstantReflectionProvider {
    public Boolean constantEquals(Constant x, Constant y) {
        if (x == y) {
            return true;
        }
        if (x instanceof SubstrateObjectConstant) {
            return y instanceof SubstrateObjectConstant && ObjectConstantEquality.get().test((SubstrateObjectConstant)x, (SubstrateObjectConstant)y);
        }
        return x.equals(y);
    }

    public Integer readArrayLength(JavaConstant array) {
        if (array.getJavaKind() != JavaKind.Object || array.isNull() || !SubstrateObjectConstant.asObject((Constant)array).getClass().isArray()) {
            return null;
        }
        return Array.getLength(SubstrateObjectConstant.asObject((Constant)array));
    }

    public JavaConstant readArrayElement(JavaConstant array, int index) {
        if (array.getJavaKind() != JavaKind.Object || array.isNull()) {
            return null;
        }
        Object a = SubstrateObjectConstant.asObject((Constant)array);
        if (!a.getClass().isArray() || index < 0 || index >= Array.getLength(a)) {
            return null;
        }
        if (a instanceof Object[]) {
            Object element = ((Object[])a)[index];
            return SubstrateObjectConstant.forObject(element);
        }
        return JavaConstant.forBoxedPrimitive((Object)Array.get(a, index));
    }

    public JavaConstant boxPrimitive(JavaConstant source) {
        if (!source.getJavaKind().isPrimitive()) {
            return null;
        }
        return SubstrateObjectConstant.forObject(source.asBoxedPrimitive());
    }

    public JavaConstant unboxPrimitive(JavaConstant source) {
        if (!source.getJavaKind().isObject()) {
            return null;
        }
        return JavaConstant.forBoxedPrimitive((Object)SubstrateObjectConstant.asObject((Constant)source));
    }

    public JavaConstant forString(String value) {
        return SubstrateObjectConstant.forObject(value);
    }

    public final MethodHandleAccessProvider getMethodHandleAccess() {
        throw VMError.shouldNotReachHere();
    }

    public final Constant asObjectHub(ResolvedJavaType type) {
        return this.asJavaClass(type);
    }

    public int getImageHeapOffset(JavaConstant constant) {
        throw VMError.shouldNotReachHere("Can only be used during JIT compilation at run time: " + this.getClass().getName());
    }
}

