/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.substitute;

import com.oracle.graal.pointsto.infrastructure.OriginalFieldProvider;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.meta.ReadableJavaField;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.GraalAccess;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.substitute.ComputedValue;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.EnumSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;
import sun.misc.Unsafe;

public class ComputedValueField
implements ReadableJavaField,
OriginalFieldProvider,
ComputedValue {
    private static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();
    private final ResolvedJavaField original;
    private final ResolvedJavaField annotated;
    private final RecomputeFieldValue.Kind kind;
    private final Class<?> targetClass;
    private final Field targetField;
    private final boolean isFinal;
    private final boolean disableCaching;
    private JavaConstant constantValue;
    private final EconomicMap<JavaConstant, JavaConstant> valueCache;
    private JavaConstant valueCacheNullKey;
    private final ReentrantReadWriteLock valueCacheLock = new ReentrantReadWriteLock();

    public ComputedValueField(ResolvedJavaField original, ResolvedJavaField annotated, RecomputeFieldValue.Kind kind, Class<?> targetClass, String targetName, boolean isFinal, boolean disableCaching) {
        this.original = original;
        this.annotated = annotated;
        this.kind = kind;
        this.targetClass = targetClass;
        this.isFinal = isFinal;
        this.disableCaching = disableCaching;
        Field f = null;
        switch (kind) {
            case Reset: {
                this.constantValue = JavaConstant.defaultForKind((JavaKind)this.getJavaKind());
                break;
            }
            case FieldOffset: {
                try {
                    f = targetClass.getDeclaredField(targetName);
                    break;
                }
                catch (NoSuchFieldException e) {
                    throw VMError.shouldNotReachHere("could not find target field " + targetClass.getName() + "." + targetName + " for alias " + annotated.format("%H.%n"));
                }
            }
        }
        VMError.guarantee(!isFinal || ComputedValueField.isFinalValid(kind));
        this.targetField = f;
        this.valueCache = EconomicMap.create();
    }

    public ComputedValueField(ResolvedJavaField original, ResolvedJavaField annotated, RecomputeFieldValue.Kind kind, Class<?> targetClass, String targetName, boolean isFinal) {
        this(original, annotated, kind, targetClass, targetName, isFinal, false);
    }

    public static boolean isFinalValid(RecomputeFieldValue.Kind kind) {
        EnumSet<RecomputeFieldValue.Kind> finalIllegal = EnumSet.of(RecomputeFieldValue.Kind.FieldOffset, RecomputeFieldValue.Kind.TranslateFieldOffset, RecomputeFieldValue.Kind.AtomicFieldUpdaterOffset);
        return !finalIllegal.contains((Object)kind);
    }

    public ResolvedJavaField getAnnotated() {
        return this.annotated;
    }

    @Override
    public Field getTargetField() {
        return this.targetField;
    }

    @Override
    public RecomputeFieldValue.Kind getRecomputeValueKind() {
        return this.kind;
    }

    public String getName() {
        return this.original.getName();
    }

    public JavaType getType() {
        return this.original.getType();
    }

    public int getModifiers() {
        int result = this.original.getModifiers();
        result = this.isFinal ? (result |= 0x10) : (result &= 0xFFFFFFEF);
        return result;
    }

    public int getOffset() {
        return this.original.getOffset();
    }

    public boolean isInternal() {
        return this.original.isInternal();
    }

    public boolean isSynthetic() {
        return this.original.isSynthetic();
    }

    public void processAnalysis(AnalysisMetaAccess aMetaAccess) {
        switch (this.kind) {
            case FieldOffset: {
                AnalysisField target = aMetaAccess.lookupJavaField(this.targetField);
                target.registerAsAccessed();
            }
        }
    }

    private JavaConstant asConstant(int value) {
        switch (this.getJavaKind()) {
            case Int: {
                return JavaConstant.forInt((int)value);
            }
            case Long: {
                return JavaConstant.forLong((long)value);
            }
        }
        throw VMError.shouldNotReachHere();
    }

    public void processSubstrate(HostedMetaAccess metaAccess) {
        switch (this.kind) {
            case FieldOffset: {
                this.constantValue = this.asConstant(metaAccess.lookupJavaField(this.targetField).getLocation());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JavaConstant readValue(MetaAccessProvider metaAccess, JavaConstant receiver) {
        if (this.constantValue != null) {
            return this.constantValue;
        }
        switch (this.kind) {
            case None: 
            case Manual: {
                return ReadableJavaField.readFieldValue(metaAccess, GraalAccess.getOriginalProviders().getConstantReflection(), this.original, receiver);
            }
            case FromAlias: {
                assert (Modifier.isStatic(this.annotated.getModifiers())) : "Cannot use " + (Object)((Object)this.kind) + " on non-static alias " + this.annotated.format("%H.%n");
                this.annotated.getDeclaringClass().initialize();
                this.constantValue = ReadableJavaField.readFieldValue(metaAccess, GraalAccess.getOriginalProviders().getConstantReflection(), this.annotated, null);
                return this.constantValue;
            }
            case ArrayBaseOffset: {
                this.constantValue = this.asConstant(ConfigurationValues.getObjectLayout().getArrayBaseOffset(JavaKind.fromJavaClass(this.targetClass.getComponentType())));
                return this.constantValue;
            }
            case ArrayIndexScale: {
                this.constantValue = this.asConstant(ConfigurationValues.getObjectLayout().getArrayIndexScale(JavaKind.fromJavaClass(this.targetClass.getComponentType())));
                return this.constantValue;
            }
            case ArrayIndexShift: {
                this.constantValue = this.asConstant(ConfigurationValues.getObjectLayout().getArrayIndexShift(JavaKind.fromJavaClass(this.targetClass.getComponentType())));
                return this.constantValue;
            }
        }
        ReentrantReadWriteLock.ReadLock readLock = this.valueCacheLock.readLock();
        try {
            readLock.lock();
            JavaConstant result = this.getCached(receiver);
            if (result != null) {
                JavaConstant javaConstant = result;
                return javaConstant;
            }
        }
        finally {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.valueCacheLock.writeLock();
        try {
            writeLock.lock();
            JavaConstant result = this.getCached(receiver);
            if (result != null) {
                JavaConstant javaConstant = result;
                return javaConstant;
            }
            result = this.computeValue(metaAccess, receiver);
            this.putCached(receiver, result);
            JavaConstant javaConstant = result;
            return javaConstant;
        }
        finally {
            writeLock.unlock();
        }
    }

    private JavaConstant computeValue(MetaAccessProvider metaAccess, JavaConstant receiver) {
        JavaConstant result;
        SnippetReflectionProvider originalSnippetReflection = GraalAccess.getOriginalSnippetReflection();
        switch (this.kind) {
            case NewInstance: {
                try {
                    result = originalSnippetReflection.forObject(ReflectionUtil.newInstance(this.targetClass));
                    break;
                }
                catch (ReflectionUtil.ReflectionUtilError ex) {
                    throw VMError.shouldNotReachHere("Error performing field recomputation for alias " + this.annotated.format("%H.%n"), ex.getCause());
                }
            }
            case AtomicFieldUpdaterOffset: {
                result = this.computeAtomicFieldUpdaterOffset(metaAccess, receiver);
                break;
            }
            case TranslateFieldOffset: {
                result = this.translateFieldOffset(metaAccess, receiver, this.targetClass);
                break;
            }
            case Custom: {
                try {
                    Object newValue;
                    Object receiverValue;
                    Constructor<?>[] constructors = this.targetClass.getDeclaredConstructors();
                    if (constructors.length != 1) {
                        throw UserError.abort("The custom field value computer class %s has more than one constructor", this.targetClass.getName());
                    }
                    Constructor<?> constructor = constructors[0];
                    Object[] constructorArgs = new Object[constructor.getParameterCount()];
                    for (int i = 0; i < constructorArgs.length; ++i) {
                        constructorArgs[i] = ComputedValueField.configurationValue(constructor.getParameterTypes()[i]);
                    }
                    constructor.setAccessible(true);
                    Object instance = constructor.newInstance(constructorArgs);
                    Object object = receiverValue = receiver == null ? null : originalSnippetReflection.asObject(Object.class, receiver);
                    if (instance instanceof RecomputeFieldValue.CustomFieldValueComputer) {
                        newValue = ((RecomputeFieldValue.CustomFieldValueComputer)instance).compute(metaAccess, this.original, this.annotated, receiverValue);
                    } else if (instance instanceof RecomputeFieldValue.CustomFieldValueTransformer) {
                        JavaConstant originalValueConstant = ReadableJavaField.readFieldValue(metaAccess, GraalAccess.getOriginalProviders().getConstantReflection(), this.original, receiver);
                        Object originalValue = originalValueConstant.getJavaKind().isPrimitive() ? originalValueConstant.asBoxedPrimitive() : originalSnippetReflection.asObject(Object.class, originalValueConstant);
                        newValue = ((RecomputeFieldValue.CustomFieldValueTransformer)instance).transform(metaAccess, this.original, this.annotated, receiverValue, originalValue);
                    } else {
                        throw UserError.abort("The custom field value computer class %s does not implement %s or %s", this.targetClass.getName(), RecomputeFieldValue.CustomFieldValueComputer.class.getSimpleName(), RecomputeFieldValue.CustomFieldValueTransformer.class.getSimpleName());
                    }
                    result = originalSnippetReflection.forBoxed(this.annotated.getJavaKind(), newValue);
                    assert (result.getJavaKind() == this.annotated.getJavaKind());
                    break;
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                    throw VMError.shouldNotReachHere("Error performing field recomputation for alias " + this.annotated.format("%H.%n"), ex);
                }
            }
            default: {
                throw VMError.shouldNotReachHere("Field recomputation of kind " + (Object)((Object)this.kind) + " specified by alias " + this.annotated.format("%H.%n") + " not yet supported");
            }
        }
        return result;
    }

    private void putCached(JavaConstant receiver, JavaConstant result) {
        if (this.disableCaching) {
            return;
        }
        if (receiver == null) {
            this.valueCacheNullKey = result;
        } else {
            this.valueCache.put((Object)receiver, (Object)result);
        }
    }

    private JavaConstant getCached(JavaConstant receiver) {
        if (receiver == null) {
            return this.valueCacheNullKey;
        }
        return (JavaConstant)this.valueCache.get((Object)receiver);
    }

    @Override
    public boolean allowConstantFolding() {
        return this.getDeclaringClass().isInitialized() && this.isFinal;
    }

    @Override
    public boolean injectFinalForRuntimeCompilation() {
        if (this.original.isFinal()) {
            return true;
        }
        return ReadableJavaField.injectFinalForRuntimeCompilation(this.original);
    }

    private static Object configurationValue(Class<?> clazz) {
        throw VMError.shouldNotReachHere("Parameter type not supported yet: " + clazz.getName());
    }

    private JavaConstant translateFieldOffset(MetaAccessProvider metaAccess, JavaConstant receiver, Class<?> tclass) {
        long searchOffset = ReadableJavaField.readFieldValue(metaAccess, GraalAccess.getOriginalProviders().getConstantReflection(), this.original, receiver).asLong();
        for (Field f : tclass.getDeclaredFields()) {
            long fieldOffset;
            if (Modifier.isStatic(f.getModifiers()) || (fieldOffset = UNSAFE.objectFieldOffset(f)) != searchOffset) continue;
            HostedField sf = (HostedField)metaAccess.lookupJavaField(f);
            VMError.guarantee(sf.isAccessed() && sf.getLocation() > 0, "Field not marked as accessed: " + sf.format("%H.%n"));
            return JavaConstant.forLong((long)sf.getLocation());
        }
        throw VMError.shouldNotReachHere("unknown field offset class: " + tclass + ", offset = " + searchOffset);
    }

    private JavaConstant computeAtomicFieldUpdaterOffset(MetaAccessProvider metaAccess, JavaConstant receiver) {
        assert (!Modifier.isStatic(this.original.getModifiers()));
        assert (receiver.isNonNull());
        ResolvedJavaField tclassField = ComputedValueField.findField(this.original.getDeclaringClass(), "tclass");
        SnippetReflectionProvider originalSnippetReflection = GraalAccess.getOriginalSnippetReflection();
        Class tclass = (Class)originalSnippetReflection.asObject(Class.class, ReadableJavaField.readFieldValue(metaAccess, GraalAccess.getOriginalProviders().getConstantReflection(), tclassField, receiver));
        return this.translateFieldOffset(metaAccess, receiver, tclass);
    }

    private static ResolvedJavaField findField(ResolvedJavaType declaringClass, String name) {
        for (ResolvedJavaField field : declaringClass.getInstanceFields(false)) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        throw VMError.shouldNotReachHere("Field not found: " + declaringClass.toJavaName(true) + "." + name);
    }

    public ResolvedJavaType getDeclaringClass() {
        return this.original.getDeclaringClass();
    }

    public Annotation[] getAnnotations() {
        return this.original.getAnnotations();
    }

    public Annotation[] getDeclaredAnnotations() {
        return this.original.getDeclaredAnnotations();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)this.original.getAnnotation(annotationClass);
    }

    public String toString() {
        return "RecomputeValueField<original " + this.original.toString() + ", kind " + (Object)((Object)this.kind) + ">";
    }

    public Field getJavaField() {
        return OriginalFieldProvider.getJavaField((SnippetReflectionProvider)GraalAccess.getOriginalSnippetReflection(), (ResolvedJavaField)this.original);
    }
}

