/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import com.oracle.svm.core.jni.JNIRuntimeAccess;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.InternalPlatform;

@Platforms(value={InternalPlatform.PLATFORM_JNI.class})
@AutomaticFeature
class JNIRegistrationJavaNet
extends JNIRegistrationUtil
implements Feature {
    private boolean hasExtendedOptionsImpl;
    private boolean hasPlatformSocketOptions;

    JNIRegistrationJavaNet() {
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        this.hasExtendedOptionsImpl = a.findClassByName("sun.net.ExtendedOptionsImpl") != null;
        this.hasPlatformSocketOptions = a.findClassByName("jdk.net.ExtendedSocketOptions$PlatformSocketOptions") != null;
        JNIRegistrationJavaNet.rerunClassInit((Feature.FeatureAccess)a, "java.net.DatagramPacket", "java.net.InetAddress", "java.net.NetworkInterface", "java.net.SocketInputStream", "java.net.SocketOutputStream", "java.net.DefaultDatagramSocketImplFactory");
        if (JNIRegistrationJavaNet.isWindows()) {
            JNIRegistrationJavaNet.rerunClassInit((Feature.FeatureAccess)a, "java.net.DualStackPlainDatagramSocketImpl", "java.net.TwoStacksPlainDatagramSocketImpl");
            if (JavaVersionUtil.JAVA_SPEC < 11) {
                JNIRegistrationJavaNet.rerunClassInit((Feature.FeatureAccess)a, "java.net.DualStackPlainSocketImpl", "java.net.TwoStacksPlainSocketImpl", "java.net.PlainSocketImpl");
            } else {
                JNIRegistrationJavaNet.rerunClassInit((Feature.FeatureAccess)a, "java.net.PlainSocketImpl");
            }
        } else {
            assert (JNIRegistrationJavaNet.isPosix());
            JNIRegistrationJavaNet.rerunClassInit((Feature.FeatureAccess)a, "java.net.PlainDatagramSocketImpl", "java.net.PlainSocketImpl");
            if (this.hasExtendedOptionsImpl) {
                JNIRegistrationJavaNet.rerunClassInit((Feature.FeatureAccess)a, "sun.net.ExtendedOptionsImpl");
            }
            JNIRegistrationJavaNet.rerunClassInit((Feature.FeatureAccess)a, "java.net.AbstractPlainDatagramSocketImpl", "java.net.AbstractPlainSocketImpl");
            if (this.hasPlatformSocketOptions) {
                JNIRegistrationJavaNet.rerunClassInit((Feature.FeatureAccess)a, "jdk.net.ExtendedSocketOptions", "jdk.net.ExtendedSocketOptions$PlatformSocketOptions");
                if (a.findClassByName("sun.net.ext.ExtendedSocketOptions") != null) {
                    JNIRegistrationJavaNet.rerunClassInit((Feature.FeatureAccess)a, "sun.net.ext.ExtendedSocketOptions");
                } else {
                    JNIRegistrationJavaNet.rerunClassInit((Feature.FeatureAccess)a, "sun.net.ExtendedSocketOptions");
                }
            }
            if (JNIRegistrationJavaNet.isDarwin()) {
                JNIRegistrationJavaNet.rerunClassInit((Feature.FeatureAccess)a, "java.net.DefaultInterface");
            }
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        JNIRegistrationJavaNet.registerForThrowNew((Feature.FeatureAccess)a, "java.net.BindException", "java.net.ConnectException", "java.net.NoRouteToHostException", "java.net.PortUnreachableException", "java.net.ProtocolException", "java.net.SocketException", "java.net.SocketTimeoutException", "java.net.UnknownHostException", "sun.net.ConnectionResetException");
        a.registerReachabilityHandler(JNIRegistrationJavaNet::registerInitInetAddressIDs, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.InetAddress", "init", new Class[0]), JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.Inet4AddressImpl", "lookupAllHostAddr", String.class), JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.Inet6AddressImpl", "lookupAllHostAddr", String.class)});
        a.registerReachabilityHandler(JNIRegistrationJavaNet::registerInetAddressLoadImpl, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.InetAddress", "loadImpl", String.class)});
        a.registerReachabilityHandler(JNIRegistrationJavaNet::registerNetworkInterfaceInit, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.NetworkInterface", "init", new Class[0])});
        a.registerReachabilityHandler(JNIRegistrationJavaNet::registerDatagramPacketInit, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.DatagramPacket", "init", new Class[0])});
        if (JavaVersionUtil.JAVA_SPEC < 15) {
            a.registerReachabilityHandler(JNIRegistrationJavaNet::registerDatagramSocketCheckOldImpl, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.DatagramSocket", "checkOldImpl", new Class[0])});
        }
        String plainDatagramSocketImpl = JNIRegistrationJavaNet.isWindows() ? "TwoStacksPlainDatagramSocketImpl" : "PlainDatagramSocketImpl";
        a.registerReachabilityHandler(JNIRegistrationJavaNet::registerPlainDatagramSocketImplInit, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net." + plainDatagramSocketImpl, "init", new Class[0])});
        a.registerReachabilityHandler(JNIRegistrationJavaNet::registerPlainDatagramSocketImplSocketGetOption, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net." + plainDatagramSocketImpl, "socketGetOption", Integer.TYPE)});
        if (JavaVersionUtil.JAVA_SPEC < 11 || JNIRegistrationJavaNet.isPosix()) {
            String plainSocketImpl = JNIRegistrationJavaNet.isWindows() ? "TwoStacksPlainSocketImpl" : "PlainSocketImpl";
            a.registerReachabilityHandler(JNIRegistrationJavaNet::registerPlainSocketImplInitProto, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net." + plainSocketImpl, "initProto", new Class[0])});
            a.registerReachabilityHandler(JNIRegistrationJavaNet::registerPlainSocketImplSocketGetOption, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net." + plainSocketImpl, "socketGetOption", Integer.TYPE, Object.class)});
        }
        if (JNIRegistrationJavaNet.isWindows()) {
            a.registerReachabilityHandler(JNIRegistrationJavaNet::registerDualStackPlainDatagramSocketImplInitIDs, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.DualStackPlainDatagramSocketImpl", "initIDs", new Class[0])});
            String dualStackPlainSocketImpl = JavaVersionUtil.JAVA_SPEC < 11 ? "DualStackPlainSocketImpl" : "PlainSocketImpl";
            a.registerReachabilityHandler(JNIRegistrationJavaNet::registerDualStackPlainSocketImplInitIDs, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net." + dualStackPlainSocketImpl, "initIDs", new Class[0])});
            a.registerReachabilityHandler(JNIRegistrationJavaNet::registerDualStackPlainSocketImplLocalAddress, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net." + dualStackPlainSocketImpl, "localAddress", Integer.TYPE, JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.net.InetAddressContainer"))});
        } else {
            assert (JNIRegistrationJavaNet.isPosix());
            if (this.hasExtendedOptionsImpl) {
                a.registerReachabilityHandler(JNIRegistrationJavaNet::registerExtendedOptionsImplInit, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "sun.net.ExtendedOptionsImpl", "init", new Class[0])});
            }
            if (this.hasPlatformSocketOptions) {
                a.registerReachabilityHandler(JNIRegistrationJavaNet::registerPlatformSocketOptionsCreate, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "jdk.net.ExtendedSocketOptions$PlatformSocketOptions", "create", new Class[0])});
            }
        }
        a.registerReachabilityHandler(JNIRegistrationJavaNet::registerDefaultProxySelectorInit, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "sun.net.spi.DefaultProxySelector", "init", new Class[0])});
    }

    static void registerInitInetAddressIDs(Feature.DuringAnalysisAccess a) {
        Class<?> c;
        boolean optional;
        Field f;
        if (JNIRegistrationJavaNet.isRunOnce(JNIRegistrationJavaNet::registerInitInetAddressIDs)) {
            return;
        }
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.InetAddress", "holder", "preferIPv6Address"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.InetAddress$InetAddressHolder", "address", "family", "hostName", "originalHostName"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, "java.net.Inet4Address", new Class[0]));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, "java.net.Inet6Address", new Class[0]));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.Inet6Address", "holder6"));
        if (JavaVersionUtil.JAVA_SPEC < 13 && (f = ReflectionUtil.lookupField((boolean)(optional = JavaVersionUtil.JAVA_SPEC == 11), c = JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.net.Inet6Address"), (String)"cached_scope_id")) != null) {
            JNIRuntimeAccess.register(f);
        }
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.Inet6Address$Inet6AddressHolder", "ipaddress", "scope_id", "scope_id_set", "scope_ifname"));
    }

    private static void registerInetAddressLoadImpl(Feature.DuringAnalysisAccess a) {
        RuntimeReflection.register((Class[])new Class[]{JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.net.Inet4AddressImpl")});
        RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, "java.net.Inet4AddressImpl", new Class[0])});
        RuntimeReflection.register((Class[])new Class[]{JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.net.Inet6AddressImpl")});
        RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, "java.net.Inet6AddressImpl", new Class[0])});
    }

    private static void registerNetworkInterfaceInit(Feature.DuringAnalysisAccess a) {
        if (JNIRegistrationJavaNet.isRunOnce(JNIRegistrationJavaNet::registerNetworkInterfaceInit)) {
            return;
        }
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, "java.net.NetworkInterface", new Class[0]));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.NetworkInterface", "name", "displayName", "index", "addrs", "bindings", "childs"));
        if (JNIRegistrationJavaNet.isPosix()) {
            JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.NetworkInterface", "virtual", "parent", "defaultIndex"));
        }
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, "java.net.InterfaceAddress", new Class[0]));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.InterfaceAddress", "address", "broadcast", "maskLength"));
        JNIRegistrationJavaNet.registerInitInetAddressIDs(a);
    }

    private static void registerDatagramPacketInit(Feature.DuringAnalysisAccess a) {
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.DatagramPacket", "address", "port", "buf", "offset", "length", "bufLength"));
    }

    private static void registerDatagramSocketCheckOldImpl(Feature.DuringAnalysisAccess a) {
        a.registerSubtypeReachabilityHandler((access, clazz) -> {
            if (!Modifier.isAbstract(clazz.getModifiers())) {
                RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)access, clazz.getName(), "peekData", DatagramPacket.class)});
            }
        }, JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.net.DatagramSocketImpl"));
    }

    private static void registerPlainDatagramSocketImplInit(Feature.DuringAnalysisAccess a) {
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.DatagramSocketImpl", "fd", "localPort"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.AbstractPlainDatagramSocketImpl", "timeout", "trafficClass", "connected"));
        if (JNIRegistrationJavaNet.isWindows()) {
            JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.TwoStacksPlainDatagramSocketImpl", "fd1", "fduse", "lastfd"));
            JNIRegistrationJavaNet.registerInitInetAddressIDs(a);
        } else {
            JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.AbstractPlainDatagramSocketImpl", "connectedAddress", "connectedPort"));
            JNIRegistrationJavaNet.registerNetworkInterfaceInit(a);
        }
    }

    private static void registerPlainDatagramSocketImplSocketGetOption(Feature.DuringAnalysisAccess a) {
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.InetAddress", "anyLocalAddress", new Class[0]));
        RuntimeReflection.register((Class[])new Class[]{JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "[Ljava.net.Inet4Address;")});
    }

    private static void registerDualStackPlainDatagramSocketImplInitIDs(Feature.DuringAnalysisAccess a) {
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.DatagramSocketImpl", "fd"));
        JNIRegistrationJavaNet.registerInitInetAddressIDs(a);
    }

    private static void registerPlainSocketImplInitProto(Feature.DuringAnalysisAccess a) {
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.SocketImpl", "fd", "address", "port", "localport", "serverSocket"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.AbstractPlainSocketImpl", "timeout", "trafficClass"));
        if (JNIRegistrationJavaNet.isWindows()) {
            JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.TwoStacksPlainSocketImpl", "fd1", "lastfd"));
        } else {
            JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.AbstractPlainSocketImpl", "fdLock", "closePending"));
            JNIRegistrationJavaNet.registerInitInetAddressIDs(a);
        }
    }

    private static void registerPlainSocketImplSocketGetOption(Feature.DuringAnalysisAccess a) {
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.InetAddressContainer", "addr"));
    }

    private static void registerDualStackPlainSocketImplInitIDs(Feature.DuringAnalysisAccess a) {
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, "java.net.InetSocketAddress", InetAddress.class, Integer.TYPE));
        JNIRegistrationJavaNet.registerInitInetAddressIDs(a);
    }

    private static void registerDualStackPlainSocketImplLocalAddress(Feature.DuringAnalysisAccess a) {
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.InetAddressContainer", "addr"));
    }

    private static void registerExtendedOptionsImplInit(Feature.DuringAnalysisAccess a) {
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "jdk.net.SocketFlow"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "jdk.net.SocketFlow", "status", "priority", "bandwidth"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "jdk.net.SocketFlow$Status"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "jdk.net.SocketFlow$Status", "NO_STATUS", "OK", "NO_PERMISSION", "NOT_CONNECTED", "NOT_SUPPORTED", "ALREADY_CREATED", "IN_PROGRESS", "OTHER"));
    }

    private static void registerPlatformSocketOptionsCreate(Feature.DuringAnalysisAccess a) {
        String implClassName;
        if (JNIRegistrationJavaNet.isLinux()) {
            implClassName = "jdk.net.LinuxSocketOptions";
        } else if (JNIRegistrationJavaNet.isDarwin()) {
            implClassName = "jdk.net.MacOSXSocketOptions";
        } else {
            throw VMError.shouldNotReachHere("Unexpected platform");
        }
        RuntimeReflection.register((Class[])new Class[]{JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, implClassName)});
        RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, implClassName, new Class[0])});
    }

    private static void registerDefaultProxySelectorInit(Feature.DuringAnalysisAccess a) {
        if (JNIRegistrationJavaNet.isWindows() && JavaVersionUtil.JAVA_SPEC >= 11) {
            FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
            access.getNativeLibraries().addDynamicNonJniLibrary("winhttp");
        }
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, "java.net.Proxy", Proxy.Type.class, SocketAddress.class));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.Proxy", "NO_PROXY"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.Proxy$Type", "HTTP", "SOCKS"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.InetSocketAddress", "createUnresolved", String.class, Integer.TYPE));
    }
}

