/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.ParallelExecutionException;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.svm.core.FallbackExecutor;
import com.oracle.svm.core.JavaMainWrapper;
import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.AbstractNativeImageClassLoaderSupport;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.ImageSingletonsSupportImpl;
import com.oracle.svm.hosted.NativeImageClassLoaderSupport;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.NativeImageSystemClassLoader;
import com.oracle.svm.hosted.analysis.NativeImagePointsToAnalysis;
import com.oracle.svm.hosted.c.GraalAccess;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.image.AbstractImage;
import com.oracle.svm.hosted.option.HostedOptionParser;
import com.oracle.svm.util.ClassUtil;
import com.oracle.svm.util.ImageBuildStatistics;
import com.oracle.svm.util.ModuleSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.TimerTask;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.runtime.JVMCI;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;

public class NativeImageGeneratorRunner {
    private volatile NativeImageGenerator generator;
    public static final String IMAGE_BUILDER_ARG_FILE_OPTION = "--image-args-file=";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int exitStatus;
        List<String> arguments = new ArrayList<String>(Arrays.asList(args));
        arguments = NativeImageGeneratorRunner.extractDriverArguments(arguments);
        String[] classPath = NativeImageGeneratorRunner.extractImagePathEntries(arguments, "-imagecp");
        String[] modulePath = NativeImageGeneratorRunner.extractImagePathEntries(arguments, "-imagemp");
        final int watchPID = NativeImageGeneratorRunner.extractWatchPID(arguments);
        TimerTask timerTask = null;
        if (watchPID >= 0) {
            VMError.guarantee(OS.getCurrent().hasProcFS, "-watchpid <pid> requires system with /proc");
            timerTask = new TimerTask(){
                int cmdlineHashCode = 0;

                @Override
                public void run() {
                    try {
                        int currentCmdlineHashCode = Arrays.hashCode(Files.readAllBytes(Paths.get("/proc/" + watchPID + "/cmdline", new String[0])));
                        if (this.cmdlineHashCode == 0) {
                            this.cmdlineHashCode = currentCmdlineHashCode;
                        } else if (currentCmdlineHashCode != this.cmdlineHashCode) {
                            System.exit(1);
                        }
                    }
                    catch (IOException e) {
                        System.exit(1);
                    }
                }
            };
            java.util.Timer timer = new java.util.Timer("native-image pid watcher");
            timer.scheduleAtFixedRate(timerTask, 0L, 1000L);
        }
        ClassLoader applicationClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ImageClassLoader imageClassLoader = NativeImageGeneratorRunner.installNativeImageClassLoader(classPath, modulePath);
            exitStatus = new NativeImageGeneratorRunner().build(arguments.toArray(new String[0]), imageClassLoader);
        }
        finally {
            NativeImageGeneratorRunner.uninstallNativeImageClassLoader();
            Thread.currentThread().setContextClassLoader(applicationClassLoader);
            if (timerTask != null) {
                timerTask.cancel();
            }
        }
        System.exit(exitStatus);
    }

    public static void uninstallNativeImageClassLoader() {
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        if (loader instanceof NativeImageSystemClassLoader) {
            ((NativeImageSystemClassLoader)loader).setNativeImageClassLoader(null);
        }
    }

    public static ImageClassLoader installNativeImageClassLoader(String[] classpath, String[] modulepath) {
        NativeImageSystemClassLoader nativeImageSystemClassLoader = NativeImageSystemClassLoader.singleton();
        AbstractNativeImageClassLoaderSupport nativeImageClassLoaderSupport = NativeImageGeneratorRunner.createNativeImageClassLoaderSupport(nativeImageSystemClassLoader.defaultSystemClassLoader, classpath, modulepath);
        ClassLoader nativeImageClassLoader = nativeImageClassLoaderSupport.getClassLoader();
        Thread.currentThread().setContextClassLoader(nativeImageClassLoader);
        nativeImageSystemClassLoader.setNativeImageClassLoader(nativeImageClassLoader);
        if (JavaVersionUtil.JAVA_SPEC >= 11 && !nativeImageClassLoaderSupport.imagecp.isEmpty()) {
            ModuleSupport.openModuleByClass(JavaVersionUtil.class, null);
        }
        NativeImageGenerator.setSystemPropertiesForImageEarly();
        return new ImageClassLoader(NativeImageGenerator.getTargetPlatform(nativeImageClassLoader), nativeImageClassLoaderSupport);
    }

    private static AbstractNativeImageClassLoaderSupport createNativeImageClassLoaderSupport(ClassLoader defaultSystemClassLoader, String[] classpath, String[] modulePath) {
        if (JavaVersionUtil.JAVA_SPEC >= 11) {
            try {
                Class<?> nativeImageClassLoaderSupport = Class.forName("com.oracle.svm.hosted.jdk11.NativeImageClassLoaderSupportJDK11OrLater");
                Constructor<?> nativeImageClassLoaderSupportConstructor = nativeImageClassLoaderSupport.getConstructor(ClassLoader.class, String[].class, String[].class);
                return (AbstractNativeImageClassLoaderSupport)nativeImageClassLoaderSupportConstructor.newInstance(defaultSystemClassLoader, classpath, modulePath);
            }
            catch (ReflectiveOperationException e) {
                throw VMError.shouldNotReachHere("Unable to reflectively instantiate module-aware NativeImageClassLoaderSupport", e);
            }
        }
        return new NativeImageClassLoaderSupport(defaultSystemClassLoader, classpath, modulePath);
    }

    public static List<String> extractDriverArguments(List<String> args) {
        ArrayList result = args.stream().filter(arg -> !arg.startsWith(IMAGE_BUILDER_ARG_FILE_OPTION)).collect(Collectors.toCollection(ArrayList::new));
        Optional<String> argsFile = args.stream().filter(arg -> arg.startsWith(IMAGE_BUILDER_ARG_FILE_OPTION)).findFirst();
        if (argsFile.isPresent()) {
            String argFilePath = argsFile.get().substring(IMAGE_BUILDER_ARG_FILE_OPTION.length());
            try {
                String options = new String(Files.readAllBytes(Paths.get(argFilePath, new String[0])));
                result.addAll(Arrays.asList(options.split("\u0000")));
            }
            catch (IOException e) {
                throw VMError.shouldNotReachHere("Exception occurred during image builder argument file processing.", e);
            }
        }
        return result;
    }

    public static String[] extractImagePathEntries(List<String> arguments, String pathPrefix) {
        int cpArgIndex = arguments.indexOf(pathPrefix);
        String msgTail = " '" + pathPrefix + " <Path entries separated by File.pathSeparator>' argument.";
        if (cpArgIndex == -1) {
            return new String[0];
        }
        arguments.remove(cpArgIndex);
        try {
            String imageClasspath = arguments.remove(cpArgIndex);
            return imageClasspath.split(File.pathSeparator, Integer.MAX_VALUE);
        }
        catch (IndexOutOfBoundsException e) {
            throw UserError.abort("Missing path entries for %s", msgTail);
        }
    }

    public static int extractWatchPID(List<String> arguments) {
        int cpIndex = arguments.indexOf("-watchpid");
        if (cpIndex >= 0) {
            if (cpIndex + 1 >= arguments.size()) {
                throw UserError.abort("ProcessID must be provided after the '%s' argument.", "-watchpid");
            }
            arguments.remove(cpIndex);
            String pidStr = arguments.get(cpIndex);
            arguments.remove(cpIndex);
            return Integer.parseInt(pidStr);
        }
        return -1;
    }

    public static boolean isValidJavaVersion() {
        return Boolean.getBoolean("substratevm.IgnoreGraalVersionCheck") || JavaVersionUtil.JAVA_SPEC <= 8;
    }

    private static void reportToolUserError(String msg) {
        NativeImageGeneratorRunner.reportUserError("native-image " + msg);
    }

    private static boolean isValidArchitecture() {
        Architecture originalTargetArch = GraalAccess.getOriginalTarget().arch;
        return originalTargetArch instanceof AMD64 || originalTargetArch instanceof AArch64;
    }

    private static boolean isValidOperatingSystem() {
        OS currentOs = OS.getCurrent();
        return currentOs == OS.LINUX || currentOs == OS.DARWIN || currentOs == OS.WINDOWS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int buildImage(String[] arguments, ImageClassLoader classLoader) {
        block87: {
            if (!NativeImageGeneratorRunner.verifyValidJavaVersionAndPlatform()) {
                return 1;
            }
            String imageName = null;
            Timer totalTimer = new Timer("[total]", false);
            ForkJoinPool analysisExecutor = null;
            ForkJoinPool compilationExecutor = null;
            OptionValues parsedHostedOptions = null;
            try {
                try (Timer.StopTimer ignored = totalTimer.start();){
                    Timer classlistTimer = new Timer("classlist", false);
                    try (Timer.StopTimer ignored1 = classlistTimer.start();){
                        classLoader.initAllClasses();
                    }
                    HostedOptionParser optionParser = new HostedOptionParser(classLoader);
                    Object[] remainingArgs = optionParser.parse(arguments);
                    if (remainingArgs.length > 0) {
                        throw UserError.abort("Unknown options: %s", Arrays.toString(remainingArgs));
                    }
                    parsedHostedOptions = new OptionValues(optionParser.getHostedValues());
                    DebugContext debug = new DebugContext.Builder(parsedHostedOptions, (DebugHandlersFactory)new GraalDebugHandlersFactory(GraalAccess.getOriginalSnippetReflection())).build();
                    if (((Boolean)NativeImageOptions.ListCPUFeatures.getValue(parsedHostedOptions)).booleanValue()) {
                        NativeImageGeneratorRunner.printCPUFeatures(classLoader.platform);
                        int n = 0;
                        totalTimer.print();
                        if (imageName != null && this.generator != null) {
                            if (((Boolean)ImageBuildStatistics.Options.CollectImageBuildStatistics.getValue(parsedHostedOptions)).booleanValue()) {
                                this.generator.printImageBuildStatistics(imageName);
                            }
                            this.generator.reportBuildArtifacts(imageName);
                        }
                        NativeImageGenerator.clearSystemPropertiesForImage();
                        ImageSingletonsSupportImpl.HostedManagement.clear();
                        return n;
                    }
                    imageName = (String)SubstrateOptions.Name.getValue(parsedHostedOptions);
                    if (imageName.length() == 0) {
                        throw UserError.abort("No output file name specified. Use '%s'.", SubstrateOptionsParser.commandArgument(SubstrateOptions.Name, "<output-file>"));
                    }
                    totalTimer.setPrefix(imageName);
                    classlistTimer.setPrefix(imageName);
                    classlistTimer.print();
                    HashMap<Method, CEntryPointData> entryPoints = new HashMap<Method, CEntryPointData>();
                    Pair mainEntryPointData = Pair.empty();
                    JavaMainWrapper.JavaMainSupport javaMainSupport = null;
                    boolean isStaticExecutable = (Boolean)SubstrateOptions.StaticExecutable.getValue(parsedHostedOptions);
                    boolean isSharedLibrary = (Boolean)SubstrateOptions.SharedLibrary.getValue(parsedHostedOptions);
                    if (isStaticExecutable && isSharedLibrary) {
                        throw UserError.abort("Cannot pass both option: %s and %s", SubstrateOptionsParser.commandArgument(SubstrateOptions.SharedLibrary, "+"), SubstrateOptionsParser.commandArgument(SubstrateOptions.StaticExecutable, "+"));
                    }
                    AbstractImage.NativeImageKind imageKind = isSharedLibrary ? AbstractImage.NativeImageKind.SHARED_LIBRARY : (isStaticExecutable ? AbstractImage.NativeImageKind.STATIC_EXECUTABLE : AbstractImage.NativeImageKind.EXECUTABLE);
                    String className = (String)SubstrateOptions.Class.getValue(parsedHostedOptions);
                    String moduleName = (String)SubstrateOptions.Module.getValue(parsedHostedOptions);
                    if (imageKind.isExecutable && moduleName.isEmpty() && className.isEmpty()) {
                        throw UserError.abort("Must specify main entry point class when building %s native image. Use '%s'.", new Object[]{imageKind, SubstrateOptionsParser.commandArgument(SubstrateOptions.Class, "<fully-qualified-class-name>")});
                    }
                    classLoader.processAddExportsAndAddOpens(parsedHostedOptions);
                    if (!className.isEmpty() || !moduleName.isEmpty()) {
                        Method mainEntryPoint;
                        Class<?> mainClass;
                        try {
                            Object mainModule = null;
                            if (!moduleName.isEmpty()) {
                                mainModule = classLoader.findModule(moduleName).orElseThrow(() -> UserError.abort("Module " + moduleName + " for mainclass not found.", new Object[0]));
                            }
                            if (className.isEmpty()) {
                                className = classLoader.getMainClassFromModule(mainModule).orElseThrow(() -> UserError.abort("module %s does not have a ModuleMainClass attribute, use -m <module>/<main-class>", moduleName));
                            }
                            if ((mainClass = classLoader.forName(className, mainModule)) == null) {
                                throw UserError.abort("Main entry point class '%s' not found.", className);
                            }
                        }
                        catch (ClassNotFoundException ex) {
                            throw UserError.abort("Main entry point class '%s' not found.", className);
                        }
                        String mainEntryPointName = (String)SubstrateOptions.Method.getValue(parsedHostedOptions);
                        if (mainEntryPointName.isEmpty()) {
                            throw UserError.abort("Must specify main entry point method when building %s native image. Use '%s'.", new Object[]{imageKind, SubstrateOptionsParser.commandArgument(SubstrateOptions.Method, "<method-name>")});
                        }
                        try {
                            mainEntryPoint = mainClass.getDeclaredMethod(mainEntryPointName, Integer.TYPE, CCharPointerPointer.class);
                        }
                        catch (NoSuchMethodException ignored2) {
                            Method javaMainMethod;
                            try {
                                javaMainMethod = ReflectionUtil.lookupMethod(mainClass, (String)mainEntryPointName, (Class[])new Class[]{String[].class});
                            }
                            catch (ReflectionUtil.ReflectionUtilError ex) {
                                throw UserError.abort(ex.getCause(), "Method '%s.%s' is declared as the main entry point but it can not be found. Make sure that class '%s' is on the classpath and that method '%s(String[])' exists in that class.", mainClass.getName(), mainEntryPointName, mainClass.getName(), mainEntryPointName);
                            }
                            if (javaMainMethod.getReturnType() != Void.TYPE) {
                                throw UserError.abort("Java main method '%s.%s(String[])' does not have the return type 'void'.", mainClass.getName(), mainEntryPointName);
                            }
                            int mainMethodModifiers = javaMainMethod.getModifiers();
                            if (!Modifier.isStatic(mainMethodModifiers)) {
                                throw UserError.abort("Java main method '%s.%s(String[])' is not static.", mainClass.getName(), mainEntryPointName);
                            }
                            if (!Modifier.isPublic(mainMethodModifiers)) {
                                throw UserError.abort("Java main method '%s.%s(String[])' is not public.", mainClass.getName(), mainEntryPointName);
                            }
                            javaMainSupport = new JavaMainWrapper.JavaMainSupport(javaMainMethod);
                            mainEntryPoint = JavaMainWrapper.class.getDeclaredMethod("run", Integer.TYPE, CCharPointerPointer.class);
                        }
                        CEntryPoint annotation = mainEntryPoint.getAnnotation(CEntryPoint.class);
                        if (annotation == null) {
                            throw UserError.abort("Entry point must have the '@%s' annotation", CEntryPoint.class.getSimpleName());
                        }
                        Class<?>[] pt = mainEntryPoint.getParameterTypes();
                        if (pt.length != 2) throw UserError.abort("Main entry point must have signature 'int main(int argc, CCharPointerPointer argv)'.", new Object[0]);
                        if (pt[0] != Integer.TYPE) throw UserError.abort("Main entry point must have signature 'int main(int argc, CCharPointerPointer argv)'.", new Object[0]);
                        if (pt[1] != CCharPointerPointer.class) throw UserError.abort("Main entry point must have signature 'int main(int argc, CCharPointerPointer argv)'.", new Object[0]);
                        if (mainEntryPoint.getReturnType() != Integer.TYPE) {
                            throw UserError.abort("Main entry point must have signature 'int main(int argc, CCharPointerPointer argv)'.", new Object[0]);
                        }
                        mainEntryPointData = Pair.create((Object)mainEntryPoint, (Object)CEntryPointData.create(mainEntryPoint, imageKind.mainEntryPointName));
                    }
                    int maxConcurrentThreads = NativeImageOptions.getMaximumNumberOfConcurrentThreads(parsedHostedOptions);
                    analysisExecutor = NativeImagePointsToAnalysis.createExecutor((DebugContext)debug, (int)NativeImageOptions.getMaximumNumberOfAnalysisThreads(parsedHostedOptions));
                    compilationExecutor = NativeImagePointsToAnalysis.createExecutor((DebugContext)debug, (int)maxConcurrentThreads);
                    this.generator = new NativeImageGenerator(classLoader, optionParser, (Pair<Method, CEntryPointData>)mainEntryPointData);
                    this.generator.run(entryPoints, javaMainSupport, imageName, imageKind, SubstitutionProcessor.IDENTITY, compilationExecutor, analysisExecutor, optionParser.getRuntimeOptionNames());
                }
                totalTimer.print();
                if (imageName == null || this.generator == null) break block87;
            }
            catch (InterruptImageBuilding e) {
                if (analysisExecutor != null) {
                    analysisExecutor.shutdownNow();
                }
                if (compilationExecutor != null) {
                    compilationExecutor.shutdownNow();
                }
                if (!e.getReason().isPresent()) {
                    int n = 3;
                    return n;
                }
                if (!e.getReason().get().isEmpty()) {
                    NativeImageGeneratorRunner.info(e.getReason().get());
                }
                int n = 0;
                return n;
                catch (FallbackFeature.FallbackImageRequest e2) {
                    block88: {
                        if (!FallbackExecutor.class.getName().equals(SubstrateOptions.Class.getValue())) break block88;
                        NativeImageGeneratorRunner.reportFatalError(e2, "FallbackImageRequest while building fallback image.");
                        int n2 = 1;
                        return n2;
                    }
                    NativeImageGeneratorRunner.reportUserException(e2, parsedHostedOptions, NativeImageGeneratorRunner::warn);
                    int n3 = 2;
                    return n3;
                    catch (AnalysisError.ParsingError e3) {
                        NativeImageGeneratorRunner.reportFatalError(e3);
                        int n4 = 1;
                        return n4;
                        catch (AnalysisError | UserError.UserException e4) {
                            NativeImageGeneratorRunner.reportUserError(e4, parsedHostedOptions);
                            int n5 = 1;
                            return n5;
                            catch (ParallelExecutionException pee) {
                                boolean hasUserError = false;
                                for (Throwable exception : pee.getExceptions()) {
                                    if (exception instanceof UserError.UserException) {
                                        NativeImageGeneratorRunner.reportUserError(exception, parsedHostedOptions);
                                        hasUserError = true;
                                        continue;
                                    }
                                    if (!(exception instanceof AnalysisError) || exception instanceof AnalysisError.ParsingError) continue;
                                    NativeImageGeneratorRunner.reportUserError(exception, parsedHostedOptions);
                                    hasUserError = true;
                                }
                                if (hasUserError) {
                                    int n6 = 1;
                                    return n6;
                                }
                                if (pee.getExceptions().size() > 1) {
                                    System.err.println(pee.getExceptions().size() + " fatal errors detected:");
                                }
                                Iterator iterator = pee.getExceptions().iterator();
                                while (true) {
                                    Throwable exception;
                                    if (!iterator.hasNext()) {
                                        int n7 = 1;
                                        return n7;
                                    }
                                    exception = (Throwable)iterator.next();
                                    NativeImageGeneratorRunner.reportFatalError(exception);
                                }
                                catch (Throwable e5) {
                                    NativeImageGeneratorRunner.reportFatalError(e5);
                                    int n8 = 1;
                                    totalTimer.print();
                                    if (imageName != null && this.generator != null) {
                                        if (((Boolean)ImageBuildStatistics.Options.CollectImageBuildStatistics.getValue(parsedHostedOptions)).booleanValue()) {
                                            this.generator.printImageBuildStatistics(imageName);
                                        }
                                        this.generator.reportBuildArtifacts(imageName);
                                    }
                                    NativeImageGenerator.clearSystemPropertiesForImage();
                                    ImageSingletonsSupportImpl.HostedManagement.clear();
                                    return n8;
                                }
                            }
                        }
                    }
                }
            }
            finally {
                totalTimer.print();
                if (imageName != null && this.generator != null) {
                    if (((Boolean)ImageBuildStatistics.Options.CollectImageBuildStatistics.getValue(parsedHostedOptions)).booleanValue()) {
                        this.generator.printImageBuildStatistics(imageName);
                    }
                    this.generator.reportBuildArtifacts(imageName);
                }
                NativeImageGenerator.clearSystemPropertiesForImage();
                ImageSingletonsSupportImpl.HostedManagement.clear();
            }
            if (((Boolean)ImageBuildStatistics.Options.CollectImageBuildStatistics.getValue(parsedHostedOptions)).booleanValue()) {
                this.generator.printImageBuildStatistics(imageName);
            }
            this.generator.reportBuildArtifacts(imageName);
        }
        NativeImageGenerator.clearSystemPropertiesForImage();
        ImageSingletonsSupportImpl.HostedManagement.clear();
        return 0;
    }

    public static boolean verifyValidJavaVersionAndPlatform() {
        if (!NativeImageGeneratorRunner.isValidJavaVersion()) {
            NativeImageGeneratorRunner.reportToolUserError("supports only Java 1.8 with an update version 40+. Detected Java version is: " + NativeImageGeneratorRunner.getJavaVersion());
            return false;
        }
        if (!NativeImageGeneratorRunner.isValidArchitecture()) {
            NativeImageGeneratorRunner.reportToolUserError("runs only on architecture AMD64. Detected architecture: " + ClassUtil.getUnqualifiedName(GraalAccess.getOriginalTarget().arch.getClass()));
        }
        if (!NativeImageGeneratorRunner.isValidOperatingSystem()) {
            NativeImageGeneratorRunner.reportToolUserError("runs on Linux, Mac OS X and Windows only. Detected OS: " + System.getProperty("os.name"));
            return false;
        }
        return true;
    }

    public static void printCPUFeatures(Platform platform) {
        StringBuilder message = new StringBuilder();
        Architecture arch = JVMCI.getRuntime().getHostJVMCIBackend().getTarget().arch;
        if (NativeImageGenerator.includedIn(platform, Platform.AMD64.class)) {
            message.append("All AMD64 CPUFeatures: ").append(Arrays.toString(AMD64.CPUFeature.values()));
            if (arch instanceof AMD64) {
                message.append("\nHost machine AMD64 CPUFeatures: ").append(((AMD64)arch).getFeatures().toString());
            }
        } else {
            assert (NativeImageGenerator.includedIn(platform, Platform.AARCH64.class));
            message.append("All AArch64 CPUFeatures: ").append(Arrays.toString(AArch64.CPUFeature.values()));
            if (arch instanceof AArch64) {
                message.append("\nHost machine AArch64 CPUFeatures: ").append(((AArch64)arch).getFeatures().toString());
            }
        }
        System.out.println(message);
    }

    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    protected static void reportFatalError(Throwable e) {
        System.err.print("Fatal error:");
        e.printStackTrace();
    }

    protected static void reportFatalError(Throwable e, String msg) {
        System.err.print("Fatal error: " + msg);
        e.printStackTrace();
    }

    public static void reportUserError(String msg) {
        System.err.println("Error: " + msg);
    }

    public static void reportUserError(Throwable e, OptionValues parsedHostedOptions) {
        NativeImageGeneratorRunner.reportUserException(e, parsedHostedOptions, NativeImageGeneratorRunner::reportUserError);
    }

    private static void reportUserException(Throwable e, OptionValues parsedHostedOptions, Consumer<String> report) {
        if (e instanceof UserError.UserException) {
            UserError.UserException ue = (UserError.UserException)e;
            for (String message : ue.getMessages()) {
                report.accept(message);
            }
        } else {
            report.accept(e.getMessage());
        }
        if (parsedHostedOptions != null && ((Boolean)NativeImageOptions.ReportExceptionStackTraces.getValue(parsedHostedOptions)).booleanValue()) {
            e.printStackTrace();
        } else {
            report.accept("Use " + SubstrateOptionsParser.commandArgument(NativeImageOptions.ReportExceptionStackTraces, "+") + " to print stacktrace of underlying exception");
        }
    }

    private static void info(String msg) {
        System.out.println("Info: " + msg);
    }

    private static void warn(String msg) {
        System.err.println("Warning: " + msg);
    }

    public int build(String[] args, ImageClassLoader imageClassLoader) {
        return this.buildImage(args, imageClassLoader);
    }

    public static class JDK9Plus {
        public static void main(String[] args) {
            ModuleSupport.exportAndOpenAllPackagesToUnnamed((String)"org.graalvm.sdk", (boolean)false);
            ModuleSupport.exportAndOpenAllPackagesToUnnamed((String)"org.graalvm.truffle", (boolean)false);
            ModuleSupport.exportAndOpenAllPackagesToUnnamed((String)"jdk.internal.vm.ci", (boolean)false);
            ModuleSupport.exportAndOpenAllPackagesToUnnamed((String)"jdk.internal.vm.compiler", (boolean)false);
            ModuleSupport.exportAndOpenAllPackagesToUnnamed((String)"jdk.internal.vm.compiler.management", (boolean)true);
            ModuleSupport.exportAndOpenAllPackagesToUnnamed((String)"com.oracle.graal.graal_enterprise", (boolean)true);
            ModuleSupport.exportAndOpenPackageToUnnamed((String)"java.base", (String)"jdk.internal.loader", (boolean)false);
            if (JavaVersionUtil.JAVA_SPEC >= 15) {
                ModuleSupport.exportAndOpenPackageToUnnamed((String)"java.base", (String)"jdk.internal.misc", (boolean)false);
            }
            ModuleSupport.exportAndOpenPackageToUnnamed((String)"java.base", (String)"sun.text.spi", (boolean)false);
            ModuleSupport.exportAndOpenPackageToUnnamed((String)"java.base", (String)"jdk.internal.org.objectweb.asm", (boolean)false);
            if (JavaVersionUtil.JAVA_SPEC >= 16) {
                ModuleSupport.exportAndOpenPackageToUnnamed((String)"java.base", (String)"sun.reflect.annotation", (boolean)false);
                ModuleSupport.exportAndOpenPackageToUnnamed((String)"java.base", (String)"sun.security.jca", (boolean)false);
                ModuleSupport.exportAndOpenPackageToUnnamed((String)"jdk.jdeps", (String)"com.sun.tools.classfile", (boolean)false);
            }
            NativeImageGeneratorRunner.main(args);
        }
    }
}

