/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.meta;

import com.oracle.svm.core.meta.CompressibleConstant;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;

public final class CompressedNullConstant
implements JavaConstant,
CompressibleConstant {
    public static final JavaConstant COMPRESSED_NULL = new CompressedNullConstant();

    private CompressedNullConstant() {
    }

    public JavaKind getJavaKind() {
        return JavaKind.Object;
    }

    public boolean isNull() {
        return true;
    }

    @Override
    public boolean isCompressed() {
        return true;
    }

    @Override
    public Constant compress() {
        throw new IllegalArgumentException();
    }

    @Override
    public Constant uncompress() {
        return NULL_POINTER;
    }

    public boolean isDefaultForKind() {
        return true;
    }

    public Object asBoxedPrimitive() {
        throw new IllegalArgumentException();
    }

    public int asInt() {
        throw new IllegalArgumentException();
    }

    public boolean asBoolean() {
        throw new IllegalArgumentException();
    }

    public long asLong() {
        throw new IllegalArgumentException();
    }

    public float asFloat() {
        throw new IllegalArgumentException();
    }

    public double asDouble() {
        throw new IllegalArgumentException();
    }

    public String toString() {
        return JavaConstant.toString((JavaConstant)this);
    }

    public String toValueString() {
        return "null";
    }

    public int hashCode() {
        return System.identityHashCode(COMPRESSED_NULL);
    }

    public boolean equals(Object o) {
        return o instanceof CompressedNullConstant;
    }
}

