/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.stream.Stream;

public class MethodPredicate
implements BooleanSupplier {
    private final Class<?> declaringClass;
    private final String innerClassName;
    private final String methodName;
    private final Class<?>[] parameterTypes;

    public MethodPredicate(Class<?> declaringClass, String innerClassName, String methodName, Class<?> ... parameterTypes) {
        this.declaringClass = declaringClass;
        this.innerClassName = innerClassName;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
    }

    @Override
    public boolean getAsBoolean() {
        Optional<Class<?>> cls;
        Optional<Class<Object>> optional = cls = this.innerClassName != null ? Stream.of(this.declaringClass.getDeclaredClasses()).filter(c -> c.getSimpleName().equals(this.innerClassName)).findFirst() : Optional.of(this.declaringClass);
        if (cls.isPresent()) {
            return Stream.of(cls.get().getDeclaredMethods()).filter(m -> m.getName().equals(this.methodName) && Arrays.equals(m.getParameters(), this.parameterTypes)).findFirst().isPresent();
        }
        return false;
    }
}

