/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.jdk;

import com.oracle.svm.core.JavaMemoryUtil;
import com.oracle.svm.core.graal.jdk.SubstrateArraycopyNode;
import com.oracle.svm.core.graal.jdk.SubstrateArraycopyWithExceptionNode;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import java.util.Map;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.extended.ForeignCallWithExceptionNode;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;

public final class SubstrateArraycopySnippets
extends SubstrateTemplates
implements Snippets {
    private static final SnippetRuntime.SubstrateForeignCallDescriptor ARRAYCOPY = SnippetRuntime.findForeignCall(SubstrateArraycopySnippets.class, "doArraycopy", false, LocationIdentity.any());
    private static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{ARRAYCOPY};

    public static void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(FOREIGN_CALLS);
    }

    protected SubstrateArraycopySnippets(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, factories, providers, snippetReflection);
        lowerings.put(SubstrateArraycopyNode.class, new SubstrateArraycopyLowering());
        lowerings.put(SubstrateArraycopyWithExceptionNode.class, new SubstrateArraycopyWithExceptionLowering());
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static void doArraycopy(Object fromArray, int fromIndex, Object toArray, int toIndex, int length) {
        if (fromArray == null || toArray == null) {
            throw new NullPointerException();
        }
        DynamicHub fromHub = KnownIntrinsics.readHub(fromArray);
        DynamicHub toHub = KnownIntrinsics.readHub(toArray);
        int fromLayoutEncoding = fromHub.getLayoutEncoding();
        if (LayoutEncoding.isPrimitiveArray(fromLayoutEncoding)) {
            if (fromArray == toArray && fromIndex < toIndex) {
                SubstrateArraycopySnippets.boundsCheck(fromArray, fromIndex, toArray, toIndex, length);
                JavaMemoryUtil.copyPrimitiveArrayBackward(fromArray, fromIndex, fromArray, toIndex, length, fromLayoutEncoding);
                return;
            }
            if (fromHub == toHub) {
                SubstrateArraycopySnippets.boundsCheck(fromArray, fromIndex, toArray, toIndex, length);
                JavaMemoryUtil.copyPrimitiveArrayForward(fromArray, fromIndex, toArray, toIndex, length, fromLayoutEncoding);
                return;
            }
        } else if (LayoutEncoding.isObjectArray(fromLayoutEncoding)) {
            if (fromArray == toArray && fromIndex < toIndex) {
                SubstrateArraycopySnippets.boundsCheck(fromArray, fromIndex, toArray, toIndex, length);
                JavaMemoryUtil.copyObjectArrayBackward(fromArray, fromIndex, fromArray, toIndex, length, fromLayoutEncoding);
                return;
            }
            if (fromHub == toHub || DynamicHub.toClass(toHub).isAssignableFrom(DynamicHub.toClass(fromHub))) {
                SubstrateArraycopySnippets.boundsCheck(fromArray, fromIndex, toArray, toIndex, length);
                JavaMemoryUtil.copyObjectArrayForward(fromArray, fromIndex, toArray, toIndex, length, fromLayoutEncoding);
                return;
            }
            if (LayoutEncoding.isObjectArray(toHub.getLayoutEncoding())) {
                SubstrateArraycopySnippets.boundsCheck(fromArray, fromIndex, toArray, toIndex, length);
                JavaMemoryUtil.copyObjectArrayForwardWithStoreCheck(fromArray, fromIndex, toArray, toIndex, length);
                return;
            }
        }
        throw new ArrayStoreException();
    }

    private static void boundsCheck(Object fromArray, int fromIndex, Object toArray, int toIndex, int length) {
        if (fromIndex < 0 || toIndex < 0 || length < 0 || fromIndex > ArrayLengthNode.arrayLength((Object)fromArray) - length || toIndex > ArrayLengthNode.arrayLength((Object)toArray) - length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    static final class SubstrateArraycopyWithExceptionLowering
    implements NodeLoweringProvider<SubstrateArraycopyWithExceptionNode> {
        SubstrateArraycopyWithExceptionLowering() {
        }

        @Override
        public void lower(SubstrateArraycopyWithExceptionNode node, LoweringTool tool) {
            StructuredGraph graph = node.graph();
            ForeignCallWithExceptionNode call = (ForeignCallWithExceptionNode)graph.add((Node)new ForeignCallWithExceptionNode((ForeignCallDescriptor)ARRAYCOPY, new ValueNode[]{node.getSource(), node.getSourcePosition(), node.getDestination(), node.getDestinationPosition(), node.getLength()}));
            call.setStateAfter(node.stateAfter());
            call.setBci(node.getBci());
            graph.replaceWithExceptionSplit((WithExceptionNode)node, (WithExceptionNode)call);
        }
    }

    static final class SubstrateArraycopyLowering
    implements NodeLoweringProvider<SubstrateArraycopyNode> {
        SubstrateArraycopyLowering() {
        }

        @Override
        public void lower(SubstrateArraycopyNode node, LoweringTool tool) {
            StructuredGraph graph = node.graph();
            ForeignCallNode call = (ForeignCallNode)graph.add((Node)new ForeignCallNode((ForeignCallDescriptor)ARRAYCOPY, new ValueNode[]{node.getSource(), node.getSourcePosition(), node.getDestination(), node.getDestinationPosition(), node.getLength()}));
            call.setStateAfter(node.stateAfter());
            call.setBci(node.getBci());
            graph.replaceFixedWithFixed((FixedWithNextNode)node, (FixedWithNextNode)call);
        }
    }
}

