/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import java.util.Arrays;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.spi.ForeignCallSignature;
import org.graalvm.compiler.replacements.ArrayIndexOf;
import org.graalvm.compiler.replacements.ArrayIndexOfNode;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.LocationIdentity;

@Platforms(value={Platform.AMD64.class})
class AMD64ArrayIndexOfForeignCalls {
    private static final ForeignCallSignature[] ORIGINAL_FOREIGN_CALLS = new ForeignCallSignature[]{ArrayIndexOf.STUB_INDEX_OF_TWO_CONSECUTIVE_BYTES, ArrayIndexOf.STUB_INDEX_OF_TWO_CONSECUTIVE_CHARS, ArrayIndexOf.STUB_INDEX_OF_TWO_CONSECUTIVE_CHARS_COMPACT, ArrayIndexOf.STUB_INDEX_OF_1_BYTE, ArrayIndexOf.STUB_INDEX_OF_2_BYTES, ArrayIndexOf.STUB_INDEX_OF_3_BYTES, ArrayIndexOf.STUB_INDEX_OF_4_BYTES, ArrayIndexOf.STUB_INDEX_OF_1_CHAR, ArrayIndexOf.STUB_INDEX_OF_2_CHARS, ArrayIndexOf.STUB_INDEX_OF_3_CHARS, ArrayIndexOf.STUB_INDEX_OF_4_CHARS, ArrayIndexOf.STUB_INDEX_OF_1_CHAR_COMPACT, ArrayIndexOf.STUB_INDEX_OF_2_CHARS_COMPACT, ArrayIndexOf.STUB_INDEX_OF_3_CHARS_COMPACT, ArrayIndexOf.STUB_INDEX_OF_4_CHARS_COMPACT};
    static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = (SnippetRuntime.SubstrateForeignCallDescriptor[])Arrays.stream(ORIGINAL_FOREIGN_CALLS).map(call -> SnippetRuntime.findForeignCall(AMD64ArrayIndexOfForeignCalls.class, call.getName(), true, new LocationIdentity[0])).toArray(SnippetRuntime.SubstrateForeignCallDescriptor[]::new);

    AMD64ArrayIndexOfForeignCalls() {
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTwoConsecutiveBytes(byte[] array, int arrayLength, int fromIndex, int searchValue) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)JavaKind.Byte, (JavaKind)JavaKind.Byte, (boolean)true, (Object)array, (int)arrayLength, (int)fromIndex, (int)searchValue);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTwoConsecutiveChars(char[] array, int arrayLength, int fromIndex, int searchValue) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)JavaKind.Char, (JavaKind)JavaKind.Char, (boolean)true, (Object)array, (int)arrayLength, (int)fromIndex, (int)searchValue);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTwoConsecutiveCharsCompact(byte[] array, int arrayLength, int fromIndex, int searchValue) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)JavaKind.Byte, (JavaKind)JavaKind.Char, (boolean)true, (Object)array, (int)arrayLength, (int)fromIndex, (int)searchValue);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf1Byte(byte[] array, int arrayLength, int fromIndex, byte v1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)JavaKind.Byte, (JavaKind)JavaKind.Byte, (boolean)false, (Object)array, (int)arrayLength, (int)fromIndex, (byte)v1);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf2Bytes(byte[] array, int arrayLength, int fromIndex, byte v1, byte v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)JavaKind.Byte, (JavaKind)JavaKind.Byte, (boolean)false, (Object)array, (int)arrayLength, (int)fromIndex, (byte)v1, (byte)v2);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf3Bytes(byte[] array, int arrayLength, int fromIndex, byte v1, byte v2, byte v3) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)JavaKind.Byte, (JavaKind)JavaKind.Byte, (boolean)false, (Object)array, (int)arrayLength, (int)fromIndex, (byte)v1, (byte)v2, (byte)v3);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf4Bytes(byte[] array, int arrayLength, int fromIndex, byte v1, byte v2, byte v3, byte v4) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)JavaKind.Byte, (JavaKind)JavaKind.Byte, (boolean)false, (Object)array, (int)arrayLength, (int)fromIndex, (byte)v1, (byte)v2, (byte)v3, (byte)v4);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf1Char(char[] array, int arrayLength, int fromIndex, char v1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)JavaKind.Char, (JavaKind)JavaKind.Char, (boolean)false, (Object)array, (int)arrayLength, (int)fromIndex, (char)v1);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf2Chars(char[] array, int arrayLength, int fromIndex, char v1, char v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)JavaKind.Char, (JavaKind)JavaKind.Char, (boolean)false, (Object)array, (int)arrayLength, (int)fromIndex, (char)v1, (char)v2);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf3Chars(char[] array, int arrayLength, int fromIndex, char v1, char v2, char v3) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)JavaKind.Char, (JavaKind)JavaKind.Char, (boolean)false, (Object)array, (int)arrayLength, (int)fromIndex, (char)v1, (char)v2, (char)v3);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf4Chars(char[] array, int arrayLength, int fromIndex, char v1, char v2, char v3, char v4) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)JavaKind.Char, (JavaKind)JavaKind.Char, (boolean)false, (Object)array, (int)arrayLength, (int)fromIndex, (char)v1, (char)v2, (char)v3, (char)v4);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf1CharCompact(byte[] array, int arrayLength, int fromIndex, char v1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)JavaKind.Byte, (JavaKind)JavaKind.Char, (boolean)false, (Object)array, (int)arrayLength, (int)fromIndex, (char)v1);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf2CharsCompact(byte[] array, int arrayLength, int fromIndex, char v1, char v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)JavaKind.Byte, (JavaKind)JavaKind.Char, (boolean)false, (Object)array, (int)arrayLength, (int)fromIndex, (char)v1, (char)v2);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf3CharsCompact(byte[] array, int arrayLength, int fromIndex, char v1, char v2, char v3) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)JavaKind.Byte, (JavaKind)JavaKind.Char, (boolean)false, (Object)array, (int)arrayLength, (int)fromIndex, (char)v1, (char)v2, (char)v3);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf4CharsCompact(byte[] array, int arrayLength, int fromIndex, char v1, char v2, char v3, char v4) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)JavaKind.Byte, (JavaKind)JavaKind.Char, (boolean)false, (Object)array, (int)arrayLength, (int)fromIndex, (char)v1, (char)v2, (char)v3, (char)v4);
    }
}

