/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.jdk.Package_jdk_internal_loader;
import com.oracle.svm.core.jdk.ResourcesHelper;
import com.oracle.svm.core.jdk.Target_jdk_internal_loader_Resource_JDK11OrLater;
import com.oracle.svm.core.jdk.Target_sun_misc_Resource_JDK8OrEarlier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;

@TargetClass(classNameProvider=Package_jdk_internal_loader.class, className="URLClassPath")
final class Target_jdk_internal_loader_URLClassPath {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.NewInstance, declClass=ArrayList.class)
    private ArrayList<?> loaders;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.NewInstance, declClass=HashMap.class)
    private HashMap<String, ?> lmap;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.NewInstance, declClass=ArrayList.class)
    private ArrayList<URL> path;

    Target_jdk_internal_loader_URLClassPath() {
    }

    @Delete
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private static native URL[] getLookupCacheURLs(ClassLoader var0);

    @Delete
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private static native int[] getLookupCacheForClassLoader(ClassLoader var0, String var1);

    @Delete
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private static native boolean knownToNotExist0(ClassLoader var0, String var1);

    @Substitute
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    boolean knownToNotExist(String className) {
        return false;
    }

    @Substitute
    @TargetElement(name="getResource", onlyWith={JDK11OrLater.class})
    public Target_jdk_internal_loader_Resource_JDK11OrLater getResourceJDK11OrLater(String name, boolean check) {
        return (Target_jdk_internal_loader_Resource_JDK11OrLater)ResourcesHelper.nameToResource(name);
    }

    @Substitute
    @TargetElement(name="getResources", onlyWith={JDK11OrLater.class})
    public Enumeration<Target_jdk_internal_loader_Resource_JDK11OrLater> getResourcesJDK11OrLater(String name, boolean check) {
        return ResourcesHelper.nameToResources(name);
    }

    @Substitute
    @TargetElement(name="getResource", onlyWith={JDK8OrEarlier.class})
    public Target_sun_misc_Resource_JDK8OrEarlier getResourceJDK8OrEarlier(String name, boolean check) {
        return (Target_sun_misc_Resource_JDK8OrEarlier)ResourcesHelper.nameToResource(name);
    }

    @Substitute
    @TargetElement(name="getResources", onlyWith={JDK8OrEarlier.class})
    public Enumeration<Target_sun_misc_Resource_JDK8OrEarlier> getResourcesJDK8OrEarlier(String name, boolean check) {
        return ResourcesHelper.nameToResources(name);
    }
}

