/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.serialize.hosted;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.configure.ConfigurationFile;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.configure.SerializationConfigurationParser;
import com.oracle.svm.hosted.ConfigurationTypeResolver;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.config.ConfigurationParserUtils;
import com.oracle.svm.reflect.hosted.ReflectionFeature;
import com.oracle.svm.reflect.serialize.hosted.SerializationBuilder;
import com.oracle.svm.reflect.serialize.hosted.SerializationDenyRegistry;
import java.util.Collections;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.RuntimeSerializationSupport;

@AutomaticFeature
public class SerializationFeature
implements Feature {
    private SerializationBuilder serializationBuilder;
    private int loadedConfigurations;

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Collections.singletonList(ReflectionFeature.class);
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        ImageClassLoader imageClassLoader = access.getImageClassLoader();
        ConfigurationTypeResolver typeResolver = new ConfigurationTypeResolver("serialization configuration", imageClassLoader, NativeImageOptions.AllowIncompleteClasspath.getValue());
        SerializationDenyRegistry serializationDenyRegistry = new SerializationDenyRegistry(typeResolver);
        this.serializationBuilder = new SerializationBuilder(serializationDenyRegistry, access, typeResolver);
        ImageSingletons.add(RuntimeSerializationSupport.class, (Object)this.serializationBuilder);
        SerializationConfigurationParser denyCollectorParser = new SerializationConfigurationParser(serializationDenyRegistry, ConfigurationFiles.Options.StrictConfiguration.getValue());
        ConfigurationParserUtils.parseAndRegisterConfigurations(denyCollectorParser, imageClassLoader, "serialization", ConfigurationFiles.Options.SerializationDenyConfigurationFiles, ConfigurationFiles.Options.SerializationDenyConfigurationResources, ConfigurationFile.SERIALIZATION_DENY.getFileName());
        SerializationConfigurationParser parser = new SerializationConfigurationParser(this.serializationBuilder, ConfigurationFiles.Options.StrictConfiguration.getValue());
        this.loadedConfigurations = ConfigurationParserUtils.parseAndRegisterConfigurations(parser, imageClassLoader, "serialization", ConfigurationFiles.Options.SerializationConfigurationFiles, ConfigurationFiles.Options.SerializationConfigurationResources, ConfigurationFile.SERIALIZATION.getFileName());
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        this.serializationBuilder.flushConditionalConfiguration(access);
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        this.serializationBuilder.flushConditionalConfiguration(access);
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.serializationBuilder.afterAnalysis();
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        FallbackFeature.FallbackImageRequest serializationFallback;
        if (ImageSingletons.contains(FallbackFeature.class) && (serializationFallback = ((FallbackFeature)ImageSingletons.lookup(FallbackFeature.class)).serializationFallback) != null && this.loadedConfigurations == 0) {
            throw serializationFallback;
        }
    }

    static void println(String str) {
        System.out.println(str);
    }
}

