/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.core.option.APIOptionGroup;
import com.oracle.svm.core.util.VMError;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.function.Function;

@Repeatable(value=List.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD})
public @interface APIOption {
    public String[] name();

    public boolean extra() default false;

    public Class<? extends APIOptionGroup> group() default NullGroup.class;

    public String customHelp() default "";

    public APIOptionKind kind() default APIOptionKind.Default;

    public char valueSeparator() default 61;

    public String[] defaultValue() default {};

    public String[] fixedValue() default {};

    public Class<? extends Function<Object, Object>>[] valueTransformer() default {DefaultTransformer.class};

    public String deprecated() default "";

    public static final class NullGroup
    implements APIOptionGroup {
        @Override
        public String name() {
            return null;
        }
    }

    public static class DefaultTransformer
    implements Function<Object, Object> {
        @Override
        public Object apply(Object o) {
            return o;
        }
    }

    public static class Utils {
        public static String optionName(String name) {
            if (name.startsWith("-")) {
                return name;
            }
            return "--" + name;
        }

        public static String groupName(APIOptionGroup group) {
            if (group.name() == null || group.name().isEmpty()) {
                VMError.shouldNotReachHere("Invalid APIOptionGroup.name() for " + group.getClass().getName());
            }
            return Utils.optionName(group.name()) + group.valueSeparator();
        }
    }

    public static enum APIOptionKind {
        Default,
        Negated,
        Paths;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface List {
        public APIOption[] value();
    }
}

