/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.ChunksAccounting;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunkProvider;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class Space {
    private final String name;
    private final boolean isFromSpace;
    private final int age;
    private final ChunksAccounting accounting;
    private AlignedHeapChunk.AlignedHeader firstAlignedHeapChunk;
    private AlignedHeapChunk.AlignedHeader lastAlignedHeapChunk;
    private UnalignedHeapChunk.UnalignedHeader firstUnalignedHeapChunk;
    private UnalignedHeapChunk.UnalignedHeader lastUnalignedHeapChunk;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    Space(String name, boolean isFromSpace, int age) {
        this(name, isFromSpace, age, null);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    Space(String name, boolean isFromSpace, int age, ChunksAccounting accounting) {
        assert (name != null) : "Space name should not be null.";
        this.name = name;
        this.isFromSpace = isFromSpace;
        this.age = age;
        this.accounting = new ChunksAccounting(accounting);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public String getName() {
        return this.name;
    }

    public boolean isEmpty() {
        return this.getFirstAlignedHeapChunk().isNull() && this.getFirstUnalignedHeapChunk().isNull();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void tearDown() {
        HeapChunkProvider.freeAlignedChunkList(this.getFirstAlignedHeapChunk());
        HeapChunkProvider.freeUnalignedChunkList(this.getFirstUnalignedHeapChunk());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    boolean isEdenSpace() {
        return this.age == 0;
    }

    public boolean isYoungSpace() {
        return this.age <= HeapParameters.getMaxSurvivorSpaces();
    }

    boolean isSurvivorSpace() {
        return this.age > 0 && this.age <= HeapParameters.getMaxSurvivorSpaces();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isOldSpace() {
        return this.age == HeapParameters.getMaxSurvivorSpaces() + 1;
    }

    int getAge() {
        return this.age;
    }

    int getNextAgeForPromotion() {
        return this.age + 1;
    }

    boolean isFromSpace() {
        return this.isFromSpace;
    }

    public boolean walkObjects(ObjectVisitor visitor) {
        AlignedHeapChunk.AlignedHeader aChunk = this.getFirstAlignedHeapChunk();
        while (aChunk.isNonNull()) {
            if (!AlignedHeapChunk.walkObjects(aChunk, visitor)) {
                return false;
            }
            aChunk = HeapChunk.getNext(aChunk);
        }
        UnalignedHeapChunk.UnalignedHeader uChunk = this.getFirstUnalignedHeapChunk();
        while (uChunk.isNonNull()) {
            if (!UnalignedHeapChunk.walkObjects(uChunk, visitor)) {
                return false;
            }
            uChunk = HeapChunk.getNext(uChunk);
        }
        return true;
    }

    public Log report(Log log, boolean traceHeapChunks) {
        log.string(this.getName()).string(":").indent(true);
        this.accounting.report(log);
        if (traceHeapChunks) {
            if (this.getFirstAlignedHeapChunk().isNonNull()) {
                log.newline().string("aligned chunks:").redent(true);
                AlignedHeapChunk.AlignedHeader aChunk = this.getFirstAlignedHeapChunk();
                while (aChunk.isNonNull()) {
                    log.newline().zhex((WordBase)aChunk).string(" (").zhex((WordBase)AlignedHeapChunk.getObjectsStart(aChunk)).string("-").zhex((WordBase)HeapChunk.getTopPointer(aChunk)).string(")");
                    aChunk = HeapChunk.getNext(aChunk);
                }
                log.redent(false);
            }
            if (this.getFirstUnalignedHeapChunk().isNonNull()) {
                log.newline().string("unaligned chunks:").redent(true);
                UnalignedHeapChunk.UnalignedHeader uChunk = this.getFirstUnalignedHeapChunk();
                while (uChunk.isNonNull()) {
                    log.newline().zhex((WordBase)uChunk).string(" (").zhex((WordBase)UnalignedHeapChunk.getObjectStart(uChunk)).string("-").zhex((WordBase)HeapChunk.getTopPointer(uChunk)).string(")");
                    uChunk = HeapChunk.getNext(uChunk);
                }
                log.redent(false);
            }
        }
        log.redent(false);
        return log;
    }

    private Pointer allocateMemory(UnsignedWord objectSize) {
        AlignedHeapChunk.AlignedHeader newChunk;
        Pointer result = (Pointer)WordFactory.nullPointer();
        AlignedHeapChunk.AlignedHeader oldChunk = this.getLastAlignedHeapChunk();
        if (oldChunk.isNonNull()) {
            result = AlignedHeapChunk.allocateMemory(oldChunk, objectSize);
        }
        if (result.isNull() && (newChunk = this.requestAlignedHeapChunk()).isNonNull()) {
            result = AlignedHeapChunk.allocateMemory(newChunk, objectSize);
        }
        return result;
    }

    public void releaseChunks(GCImpl.ChunkReleaser chunkReleaser) {
        chunkReleaser.add(this.firstAlignedHeapChunk);
        chunkReleaser.add(this.firstUnalignedHeapChunk);
        this.firstAlignedHeapChunk = (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer();
        this.lastAlignedHeapChunk = (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer();
        this.firstUnalignedHeapChunk = (UnalignedHeapChunk.UnalignedHeader)WordFactory.nullPointer();
        this.lastUnalignedHeapChunk = (UnalignedHeapChunk.UnalignedHeader)WordFactory.nullPointer();
        this.accounting.reset();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void appendAlignedHeapChunk(AlignedHeapChunk.AlignedHeader aChunk) {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            VMThreads.guaranteeOwnsThreadMutex("Trying to append an aligned heap chunk but no mutual exclusion.");
        }
        this.appendAlignedHeapChunkUninterruptibly(aChunk);
        this.accounting.noteAlignedHeapChunk();
    }

    @Uninterruptible(reason="Must not interact with garbage collections.")
    private void appendAlignedHeapChunkUninterruptibly(AlignedHeapChunk.AlignedHeader aChunk) {
        AlignedHeapChunk.AlignedHeader oldLast = this.getLastAlignedHeapChunk();
        HeapChunk.setSpace(aChunk, this);
        HeapChunk.setPrevious(aChunk, oldLast);
        HeapChunk.setNext(aChunk, (HeapChunk.Header)WordFactory.nullPointer());
        if (oldLast.isNonNull()) {
            HeapChunk.setNext(oldLast, aChunk);
        }
        this.setLastAlignedHeapChunk(aChunk);
        if (this.getFirstAlignedHeapChunk().isNull()) {
            this.setFirstAlignedHeapChunk(aChunk);
        }
    }

    void extractAlignedHeapChunk(AlignedHeapChunk.AlignedHeader aChunk) {
        assert (VMOperation.isGCInProgress()) : "Should only be called by the collector.";
        this.extractAlignedHeapChunkUninterruptibly(aChunk);
        this.accounting.unnoteAlignedHeapChunk();
    }

    @Uninterruptible(reason="Must not interact with garbage collections.")
    private void extractAlignedHeapChunkUninterruptibly(AlignedHeapChunk.AlignedHeader aChunk) {
        AlignedHeapChunk.AlignedHeader chunkNext = HeapChunk.getNext(aChunk);
        AlignedHeapChunk.AlignedHeader chunkPrev = HeapChunk.getPrevious(aChunk);
        if (chunkPrev.isNonNull()) {
            HeapChunk.setNext(chunkPrev, chunkNext);
        } else {
            this.setFirstAlignedHeapChunk(chunkNext);
        }
        if (chunkNext.isNonNull()) {
            HeapChunk.setPrevious(chunkNext, chunkPrev);
        } else {
            this.setLastAlignedHeapChunk(chunkPrev);
        }
        HeapChunk.setNext(aChunk, (HeapChunk.Header)WordFactory.nullPointer());
        HeapChunk.setPrevious(aChunk, (HeapChunk.Header)WordFactory.nullPointer());
        HeapChunk.setSpace(aChunk, null);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void appendUnalignedHeapChunk(UnalignedHeapChunk.UnalignedHeader uChunk) {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            VMThreads.guaranteeOwnsThreadMutex("Trying to append an unaligned chunk but no mutual exclusion.");
        }
        this.appendUnalignedHeapChunkUninterruptibly(uChunk);
        this.accounting.noteUnalignedHeapChunk(uChunk);
    }

    @Uninterruptible(reason="Must not interact with garbage collections.")
    private void appendUnalignedHeapChunkUninterruptibly(UnalignedHeapChunk.UnalignedHeader uChunk) {
        UnalignedHeapChunk.UnalignedHeader oldLast = this.getLastUnalignedHeapChunk();
        HeapChunk.setSpace(uChunk, this);
        HeapChunk.setPrevious(uChunk, oldLast);
        HeapChunk.setNext(uChunk, (HeapChunk.Header)WordFactory.nullPointer());
        if (oldLast.isNonNull()) {
            HeapChunk.setNext(oldLast, uChunk);
        }
        this.setLastUnalignedHeapChunk(uChunk);
        if (this.getFirstUnalignedHeapChunk().isNull()) {
            this.setFirstUnalignedHeapChunk(uChunk);
        }
    }

    void extractUnalignedHeapChunk(UnalignedHeapChunk.UnalignedHeader uChunk) {
        assert (VMOperation.isGCInProgress()) : "Trying to extract an unaligned chunk but not in a VMOperation.";
        this.extractUnalignedHeapChunkUninterruptibly(uChunk);
        this.accounting.unnoteUnalignedHeapChunk(uChunk);
    }

    @Uninterruptible(reason="Must not interact with garbage collections.")
    private void extractUnalignedHeapChunkUninterruptibly(UnalignedHeapChunk.UnalignedHeader uChunk) {
        UnalignedHeapChunk.UnalignedHeader chunkNext = HeapChunk.getNext(uChunk);
        UnalignedHeapChunk.UnalignedHeader chunkPrev = HeapChunk.getPrevious(uChunk);
        if (chunkPrev.isNonNull()) {
            HeapChunk.setNext(chunkPrev, chunkNext);
        } else {
            this.setFirstUnalignedHeapChunk(chunkNext);
        }
        if (chunkNext.isNonNull()) {
            HeapChunk.setPrevious(chunkNext, chunkPrev);
        } else {
            this.setLastUnalignedHeapChunk(chunkPrev);
        }
        HeapChunk.setNext(uChunk, (HeapChunk.Header)WordFactory.nullPointer());
        HeapChunk.setPrevious(uChunk, (HeapChunk.Header)WordFactory.nullPointer());
        HeapChunk.setSpace(uChunk, null);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public AlignedHeapChunk.AlignedHeader getFirstAlignedHeapChunk() {
        return this.firstAlignedHeapChunk;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void setFirstAlignedHeapChunk(AlignedHeapChunk.AlignedHeader chunk) {
        this.firstAlignedHeapChunk = chunk;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    AlignedHeapChunk.AlignedHeader getLastAlignedHeapChunk() {
        return this.lastAlignedHeapChunk;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void setLastAlignedHeapChunk(AlignedHeapChunk.AlignedHeader chunk) {
        this.lastAlignedHeapChunk = chunk;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnalignedHeapChunk.UnalignedHeader getFirstUnalignedHeapChunk() {
        return this.firstUnalignedHeapChunk;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void setFirstUnalignedHeapChunk(UnalignedHeapChunk.UnalignedHeader chunk) {
        this.firstUnalignedHeapChunk = chunk;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    UnalignedHeapChunk.UnalignedHeader getLastUnalignedHeapChunk() {
        return this.lastUnalignedHeapChunk;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void setLastUnalignedHeapChunk(UnalignedHeapChunk.UnalignedHeader chunk) {
        this.lastUnalignedHeapChunk = chunk;
    }

    Object promoteAlignedObject(Object original, Space originalSpace) {
        assert (ObjectHeaderImpl.isAlignedObject(original));
        assert (this != originalSpace && originalSpace.isFromSpace());
        Object copy = this.copyAlignedObject(original);
        if (copy != null) {
            ObjectHeaderImpl.installForwardingPointer(original, copy);
        }
        return copy;
    }

    private Object copyAlignedObject(Object originalObj) {
        assert (VMOperation.isGCInProgress());
        assert (ObjectHeaderImpl.isAlignedObject(originalObj));
        UnsignedWord size = LayoutEncoding.getSizeFromObject(originalObj);
        Pointer copyMemory = this.allocateMemory(size);
        if (BranchProbabilityNode.probability((double)0.0010000000000000009, (boolean)copyMemory.isNull())) {
            return null;
        }
        Word originalMemory = Word.objectToUntrackedPointer((Object)originalObj);
        UnmanagedMemoryUtil.copyLongsForward((Pointer)originalMemory, copyMemory, size);
        Object copy = copyMemory.toObject();
        if (this.isOldSpace()) {
            AlignedHeapChunk.AlignedHeader copyChunk = AlignedHeapChunk.getEnclosingChunk(copy);
            RememberedSet.get().enableRememberedSetForObject(copyChunk, copy);
        }
        return copy;
    }

    void promoteAlignedHeapChunk(AlignedHeapChunk.AlignedHeader chunk, Space originalSpace) {
        assert (this != originalSpace && originalSpace.isFromSpace());
        originalSpace.extractAlignedHeapChunk(chunk);
        this.appendAlignedHeapChunk(chunk);
        if (this.isOldSpace()) {
            if (originalSpace.isYoungSpace()) {
                RememberedSet.get().enableRememberedSetForChunk(chunk);
            } else {
                assert (originalSpace.isOldSpace());
                RememberedSet.get().clearRememberedSet(chunk);
            }
        }
    }

    void promoteUnalignedHeapChunk(UnalignedHeapChunk.UnalignedHeader chunk, Space originalSpace) {
        assert (this != originalSpace && originalSpace.isFromSpace());
        originalSpace.extractUnalignedHeapChunk(chunk);
        this.appendUnalignedHeapChunk(chunk);
        if (this.isOldSpace()) {
            if (originalSpace.isYoungSpace()) {
                RememberedSet.get().enableRememberedSetForChunk(chunk);
            } else {
                assert (originalSpace.isOldSpace());
                RememberedSet.get().clearRememberedSet(chunk);
            }
        }
    }

    private AlignedHeapChunk.AlignedHeader requestAlignedHeapChunk() {
        AlignedHeapChunk.AlignedHeader chunk;
        if (this.isYoungSpace()) {
            assert (this.isSurvivorSpace());
            chunk = HeapImpl.getHeapImpl().getYoungGeneration().requestAlignedSurvivorChunk();
        } else {
            chunk = HeapImpl.getHeapImpl().getOldGeneration().requestAlignedChunk();
        }
        if (chunk.isNonNull()) {
            this.appendAlignedHeapChunk(chunk);
        }
        return chunk;
    }

    void absorb(Space src) {
        AlignedHeapChunk.AlignedHeader aChunk = src.getFirstAlignedHeapChunk();
        while (aChunk.isNonNull()) {
            AlignedHeapChunk.AlignedHeader next = HeapChunk.getNext(aChunk);
            src.extractAlignedHeapChunk(aChunk);
            this.appendAlignedHeapChunk(aChunk);
            aChunk = next;
        }
        UnalignedHeapChunk.UnalignedHeader uChunk = src.getFirstUnalignedHeapChunk();
        while (uChunk.isNonNull()) {
            UnalignedHeapChunk.UnalignedHeader next = HeapChunk.getNext(uChunk);
            src.extractUnalignedHeapChunk(uChunk);
            this.appendUnalignedHeapChunk(uChunk);
            uChunk = next;
        }
    }

    boolean walkHeapChunks(MemoryWalker.Visitor visitor) {
        boolean continueVisiting = true;
        AlignedHeapChunk.AlignedHeader aChunk = this.getFirstAlignedHeapChunk();
        while (continueVisiting && aChunk.isNonNull()) {
            continueVisiting = visitor.visitHeapChunk(aChunk, AlignedHeapChunk.getMemoryWalkerAccess());
            aChunk = HeapChunk.getNext(aChunk);
        }
        UnalignedHeapChunk.UnalignedHeader uChunk = this.getFirstUnalignedHeapChunk();
        while (continueVisiting && uChunk.isNonNull()) {
            continueVisiting = visitor.visitHeapChunk(uChunk, UnalignedHeapChunk.getMemoryWalkerAccess());
            uChunk = HeapChunk.getNext(uChunk);
        }
        return continueVisiting;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    UnsignedWord getChunkBytes() {
        assert (!this.isEdenSpace() || VMOperation.isGCInProgress()) : "eden data is only accurate during a GC";
        return this.getAlignedChunkBytes().add(this.accounting.getUnalignedChunkBytes());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    UnsignedWord getAlignedChunkBytes() {
        return this.accounting.getAlignedChunkBytes();
    }

    UnsignedWord computeObjectBytes() {
        assert (!this.isEdenSpace() || VMOperation.isGCInProgress()) : "eden data is only accurate during a GC";
        return this.computeAlignedObjectBytes().add(this.computeUnalignedObjectBytes());
    }

    private UnsignedWord computeAlignedObjectBytes() {
        UnsignedWord result = (UnsignedWord)WordFactory.zero();
        AlignedHeapChunk.AlignedHeader aChunk = this.getFirstAlignedHeapChunk();
        while (aChunk.isNonNull()) {
            UnsignedWord allocatedBytes = HeapChunk.getTopOffset(aChunk).subtract(AlignedHeapChunk.getObjectsStartOffset());
            result = result.add(allocatedBytes);
            aChunk = HeapChunk.getNext(aChunk);
        }
        return result;
    }

    private UnsignedWord computeUnalignedObjectBytes() {
        UnsignedWord result = (UnsignedWord)WordFactory.zero();
        UnalignedHeapChunk.UnalignedHeader uChunk = this.getFirstUnalignedHeapChunk();
        while (uChunk.isNonNull()) {
            UnsignedWord allocatedBytes = HeapChunk.getTopOffset(uChunk).subtract(UnalignedHeapChunk.getObjectStartOffset());
            result = result.add(allocatedBytes);
            uChunk = HeapChunk.getNext(uChunk);
        }
        return result;
    }
}

