/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.annotate;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD})
public @interface RecomputeFieldValue {
    public Kind kind();

    public Class<?> declClass() default RecomputeFieldValue.class;

    public String declClassName() default "";

    public String name() default "";

    public boolean isFinal() default false;

    public boolean disableCaching() default false;

    public static final class NewEmptyArrayTransformer
    implements CustomFieldValueTransformer {
        @Override
        public Object transform(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver, Object originalValue) {
            if (originalValue == null) {
                return null;
            }
            int originalLength = Array.getLength(originalValue);
            return Array.newInstance(originalValue.getClass().getComponentType(), originalLength);
        }
    }

    public static interface CustomFieldValueTransformer {
        public Object transform(MetaAccessProvider var1, ResolvedJavaField var2, ResolvedJavaField var3, Object var4, Object var5);
    }

    public static interface CustomFieldValueComputer {
        public Object compute(MetaAccessProvider var1, ResolvedJavaField var2, ResolvedJavaField var3, Object var4);
    }

    public static enum Kind {
        None,
        Reset,
        NewInstance,
        FromAlias,
        FieldOffset,
        ArrayBaseOffset,
        ArrayIndexScale,
        ArrayIndexShift,
        AtomicFieldUpdaterOffset,
        TranslateFieldOffset,
        Manual,
        Custom;

    }
}

