/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.SharedConstantFieldProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class HostedConstantFieldProvider
extends SharedConstantFieldProvider {
    public HostedConstantFieldProvider(MetaAccessProvider metaAccess, ClassInitializationSupport classInitializationSupport) {
        super(metaAccess, classInitializationSupport);
    }

    @Override
    public boolean isFinalField(ResolvedJavaField f, ConstantFieldProvider.ConstantFieldTool<?> tool) {
        HostedField field = (HostedField)f;
        if (field.location == -10) {
            return true;
        }
        if (!field.wrapped.isWritten()) {
            return true;
        }
        return super.isFinalField(field, tool);
    }
}

