/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.c;

import com.oracle.svm.core.c.CGlobalDataImpl;
import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.core.util.VMError;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class CGlobalDataNonConstantRegistry {
    private final EconomicMap<CGlobalDataImpl<?>, CGlobalDataInfo> cGlobalDataInfos = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final Lock lock = new ReentrantLock();

    public CGlobalDataInfo getCGlobalDataInfo(CGlobalDataImpl<?> cGlobalData) {
        CGlobalDataInfo res = (CGlobalDataInfo)this.cGlobalDataInfos.get(cGlobalData);
        if (res == null) {
            throw VMError.shouldNotReachHere("Non-constant C global data must be registered via a factory method with a parameter named \"nonConstant\" whose value must be true");
        }
        return res;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerNonConstantSymbol(CGlobalDataInfo cGlobalDataInfo) {
        this.lock.lock();
        try {
            this.cGlobalDataInfos.put(cGlobalDataInfo.getData(), (Object)cGlobalDataInfo);
        }
        finally {
            this.lock.unlock();
        }
    }
}

