/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c;

import java.util.Collection;
import java.util.HashSet;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.c.CContext;

public class NativeCodeContext {
    private final CContext.Directives directives;
    private final boolean inConfiguration;
    private final Collection<ResolvedJavaMethod> constantAccessors;
    private final Collection<ResolvedJavaType> structTypes;
    private final Collection<ResolvedJavaType> rawStructTypes;
    private final Collection<ResolvedJavaType> cPointerToTypes;
    private final Collection<ResolvedJavaType> rawPointerToTypes;
    private final Collection<ResolvedJavaType> enumTypes;

    NativeCodeContext(CContext.Directives directives) {
        this.inConfiguration = directives.isInConfiguration();
        if (this.inConfiguration) {
            this.constantAccessors = new HashSet<ResolvedJavaMethod>();
            this.structTypes = new HashSet<ResolvedJavaType>();
            this.rawStructTypes = new HashSet<ResolvedJavaType>();
            this.cPointerToTypes = new HashSet<ResolvedJavaType>();
            this.rawPointerToTypes = new HashSet<ResolvedJavaType>();
            this.enumTypes = new HashSet<ResolvedJavaType>();
            this.directives = directives;
        } else {
            this.constantAccessors = null;
            this.structTypes = null;
            this.rawStructTypes = null;
            this.cPointerToTypes = null;
            this.rawPointerToTypes = null;
            this.enumTypes = null;
            this.directives = null;
        }
    }

    public boolean isInConfiguration() {
        return this.inConfiguration;
    }

    public CContext.Directives getDirectives() {
        return this.directives;
    }

    public void appendConstantAccessor(ResolvedJavaMethod method) {
        this.constantAccessors.add(method);
    }

    public void appendStructType(ResolvedJavaType type) {
        this.structTypes.add(type);
    }

    public void appendRawStructType(ResolvedJavaType type) {
        this.rawStructTypes.add(type);
    }

    public void appendCPointerToType(ResolvedJavaType type) {
        this.cPointerToTypes.add(type);
    }

    public void appendRawPointerToType(ResolvedJavaType type) {
        this.rawPointerToTypes.add(type);
    }

    public void appendEnumType(ResolvedJavaType type) {
        this.enumTypes.add(type);
    }

    public Collection<ResolvedJavaMethod> getConstantAccessors() {
        return this.constantAccessors;
    }

    public Collection<ResolvedJavaType> getStructTypes() {
        return this.structTypes;
    }

    public Collection<ResolvedJavaType> getRawStructTypes() {
        return this.rawStructTypes;
    }

    public Collection<ResolvedJavaType> getCPointerToTypes() {
        return this.cPointerToTypes;
    }

    public Collection<ResolvedJavaType> getRawPointerToTypes() {
        return this.rawPointerToTypes;
    }

    public Collection<ResolvedJavaType> getEnumTypes() {
        return this.enumTypes;
    }
}

