/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.StackOverflowCheckImpl;
import com.oracle.svm.core.graal.snippets.StackOverflowCheckNode;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import java.util.Map;
import java.util.function.Predicate;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnreachableNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

final class StackOverflowCheckSnippets
extends SubstrateTemplates
implements Snippets {
    private final Predicate<ResolvedJavaMethod> mustNotAllocatePredicate;

    @Snippet
    private static void stackOverflowCheckSnippet(@Snippet.ConstantParameter boolean mustNotAllocate, @Snippet.ConstantParameter boolean hasDeoptFrameSize, long deoptFrameSize) {
        UnsignedWord stackBoundary = StackOverflowCheckImpl.stackBoundaryTL.get();
        if (hasDeoptFrameSize) {
            stackBoundary = stackBoundary.add(WordFactory.unsigned((long)deoptFrameSize));
        }
        if (BranchProbabilityNode.probability((double)1.0000000000287557E-6, (boolean)KnownIntrinsics.readStackPointer().belowOrEqual(stackBoundary))) {
            if (mustNotAllocate) {
                StackOverflowCheckSnippets.callSlowPath(StackOverflowCheckImpl.THROW_CACHED_STACK_OVERFLOW_ERROR);
            } else {
                StackOverflowCheckSnippets.callSlowPath(StackOverflowCheckImpl.THROW_NEW_STACK_OVERFLOW_ERROR);
            }
            throw UnreachableNode.unreachable();
        }
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void callSlowPath(@Node.ConstantNodeParameter ForeignCallDescriptor var0);

    StackOverflowCheckSnippets(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, Predicate<ResolvedJavaMethod> mustNotAllocatePredicate) {
        super(options, factories, providers, snippetReflection);
        this.mustNotAllocatePredicate = mustNotAllocatePredicate;
        lowerings.put(StackOverflowCheckNode.class, new StackOverflowCheckLowering());
    }

    static long computeDeoptFrameSize(FrameState state, NodeMap<Long> deoptFrameSizeCache) {
        Long existing = (Long)deoptFrameSizeCache.get((Node)state);
        if (existing != null) {
            return existing;
        }
        long outerFrameSize = state.outerFrameState() == null ? 0L : StackOverflowCheckSnippets.computeDeoptFrameSize(state.outerFrameState(), deoptFrameSizeCache);
        long myFrameSize = CodeInfoAccess.lookupTotalFrameSize(CodeInfoTable.getImageCodeInfo(), ((SharedMethod)state.getMethod()).getDeoptOffsetInImage());
        long result = outerFrameSize + myFrameSize;
        deoptFrameSizeCache.put((Node)state, (Object)result);
        return result;
    }

    final class StackOverflowCheckLowering
    implements NodeLoweringProvider<StackOverflowCheckNode> {
        private final SnippetTemplate.SnippetInfo stackOverflowCheck;

        StackOverflowCheckLowering() {
            this.stackOverflowCheck = StackOverflowCheckSnippets.this.snippet(StackOverflowCheckSnippets.class, "stackOverflowCheckSnippet", new LocationIdentity[]{StackOverflowCheckImpl.stackBoundaryTL.getLocationIdentity()});
        }

        @Override
        public void lower(StackOverflowCheckNode node, LoweringTool tool) {
            StructuredGraph graph = node.graph();
            long deoptFrameSize = 0L;
            if (ImageInfo.inImageRuntimeCode()) {
                NodeMap deoptFrameSizeCache = new NodeMap((Graph)graph);
                for (FrameState state : graph.getNodes(FrameState.TYPE)) {
                    deoptFrameSize = Math.max(deoptFrameSize, StackOverflowCheckSnippets.computeDeoptFrameSize(state, (NodeMap<Long>)deoptFrameSizeCache));
                }
            }
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.stackOverflowCheck, graph.getGuardsStage(), tool.getLoweringStage());
            args.addConst("mustNotAllocate", (Object)(StackOverflowCheckSnippets.this.mustNotAllocatePredicate != null && StackOverflowCheckSnippets.this.mustNotAllocatePredicate.test(graph.method()) ? 1 : 0));
            args.addConst("hasDeoptFrameSize", (Object)(deoptFrameSize > 0L ? 1 : 0));
            args.add("deoptFrameSize", (Object)deoptFrameSize);
            StackOverflowCheckSnippets.this.template((ValueNode)node, args).instantiate(StackOverflowCheckSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

