/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.info;

import com.oracle.svm.hosted.c.info.InfoTreeBuilder;
import com.oracle.svm.hosted.c.info.InfoTreeVisitor;
import com.oracle.svm.hosted.c.info.RawStructureInfo;
import com.oracle.svm.hosted.c.info.SizableInfo;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.struct.RawStructure;

public class StructInfo
extends SizableInfo {
    private final ResolvedJavaType annotatedType;
    private final boolean isIncomplete;
    private String typedefName;

    public static StructInfo create(String typeName, ResolvedJavaType annotatedType) {
        String typedefAnnotation = InfoTreeBuilder.getTypedefName(annotatedType);
        if (annotatedType.getAnnotation(RawStructure.class) != null) {
            return new RawStructureInfo(typeName, typedefAnnotation, annotatedType);
        }
        return new StructInfo(typeName, typedefAnnotation, annotatedType, ((CStruct)annotatedType.getAnnotation(CStruct.class)).isIncomplete());
    }

    public StructInfo(String typeName, String typedefName, ResolvedJavaType annotatedType, boolean isIncomplete) {
        super(typeName, SizableInfo.ElementKind.UNKNOWN);
        this.annotatedType = annotatedType;
        this.isIncomplete = isIncomplete;
        this.typedefName = typedefName;
    }

    public ResolvedJavaType getAnnotatedElement() {
        return this.annotatedType;
    }

    @Override
    public void accept(InfoTreeVisitor visitor) {
        visitor.visitStructInfo(this);
    }

    public boolean isIncomplete() {
        return this.isIncomplete;
    }

    public String getTypedefName() {
        return this.typedefName;
    }
}

