/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.heap.ReferenceInternals;
import com.oracle.svm.core.heap.Target_java_lang_ref_Cleaner;
import com.oracle.svm.core.heap.Target_java_lang_ref_Cleaner_Cleanable;
import com.oracle.svm.core.heap.Target_jdk_internal_ref_CleanerFactory;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.util.VMError;
import java.lang.ref.Reference;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;

public final class ReferenceHandler {
    @Fold
    public static boolean useDedicatedThread() {
        return SubstrateOptions.AutomaticReferenceHandling.getValue() != false && SubstrateOptions.UseReferenceHandlerThread.getValue() != false && SubstrateOptions.MultiThreaded.getValue() != false;
    }

    @Fold
    public static boolean useRegularJavaThreads() {
        return SubstrateOptions.AutomaticReferenceHandling.getValue() != false && (SubstrateOptions.UseReferenceHandlerThread.getValue() == false || SubstrateOptions.MultiThreaded.getValue() == false);
    }

    @Fold
    public static boolean isExecutedManually() {
        return SubstrateOptions.AutomaticReferenceHandling.getValue() == false;
    }

    public static void doReferenceHandling() {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            ReferenceInternals.processPendingReferences();
            ReferenceHandler.processCleaners();
        }
        catch (Throwable t) {
            VMError.shouldNotReachHere("Reference processing and cleaners must handle all potential exceptions", t);
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    static void processCleaners() {
        if (JavaVersionUtil.JAVA_SPEC > 8) {
            Target_java_lang_ref_Cleaner commonCleaner = Target_jdk_internal_ref_CleanerFactory.cleaner();
            Reference<Object> ref = commonCleaner.impl.queue.poll();
            while (ref != null) {
                try {
                    Target_java_lang_ref_Cleaner_Cleanable cl = SubstrateUtil.cast(ref, Target_java_lang_ref_Cleaner_Cleanable.class);
                    cl.clean();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ref = commonCleaner.impl.queue.poll();
            }
        }
    }

    private ReferenceHandler() {
    }
}

