/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.c.libc;

import com.oracle.svm.core.c.libc.LibC;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.util.GuardedAnnotationAccess;

public interface LibCBase {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static boolean containsLibCAnnotation(AnnotatedElement element) {
        return GuardedAnnotationAccess.getAnnotation((AnnotatedElement)element, LibC.class) != null;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static boolean isProvidedInCurrentLibc(AnnotatedElement element) {
        LibCBase currentLibC = (LibCBase)ImageSingletons.lookup(LibCBase.class);
        LibC targetLibC = (LibC)GuardedAnnotationAccess.getAnnotation((AnnotatedElement)element, LibC.class);
        return targetLibC != null && Arrays.asList(targetLibC.value()).contains(currentLibC.getClass());
    }

    @Fold
    public static boolean targetLibCIs(Class<? extends LibCBase> libCBase) {
        LibCBase currentLibC = (LibCBase)ImageSingletons.lookup(LibCBase.class);
        return currentLibC.getClass() == libCBase;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static boolean isTypeProvidedInCurrentLibc(Class<?> clazz) {
        for (Class<?> currentClazz = clazz; currentClazz != null; currentClazz = currentClazz.getEnclosingClass()) {
            if (!LibCBase.containsLibCAnnotation(currentClazz)) continue;
            return LibCBase.isProvidedInCurrentLibc(currentClazz);
        }
        Package clazzPackage = clazz.getPackage();
        if (clazzPackage != null) {
            return !LibCBase.containsLibCAnnotation(clazz) || LibCBase.isProvidedInCurrentLibc(clazzPackage);
        }
        return true;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static boolean isMethodProvidedInCurrentLibc(Method method) {
        if (LibCBase.containsLibCAnnotation(method) && !LibCBase.isProvidedInCurrentLibc(method)) {
            return false;
        }
        Class<?> declaringClass = method.getDeclaringClass();
        return LibCBase.isTypeProvidedInCurrentLibc(declaringClass);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public String getName();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public String getTargetCompiler();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public List<String> getAdditionalQueryCodeCompilerOptions();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public boolean requiresLibCSpecificStaticJDKLibraries();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    default public void checkIfLibCSupported() {
    }

    public static LibCBase singleton() {
        return (LibCBase)ImageSingletons.lookup(LibCBase.class);
    }

    public boolean hasIsolatedNamespaces();
}

