/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.LinkerInvocation;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.SharedField;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.hosted.FeatureHandler;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.ReachabilityHandlerFeature;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.analysis.Inflation;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.code.CompilationInfoSupport;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.code.SharedRuntimeConfigurationBuilder;
import com.oracle.svm.hosted.image.AbstractImage;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.option.HostedOptionProvider;
import com.oracle.svm.util.UnsafePartitionKind;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

public class FeatureImpl {

    public static class AfterImageWriteAccessImpl
    extends FeatureAccessImpl
    implements Feature.AfterImageWriteAccess {
        private final HostedUniverse hUniverse;
        protected final LinkerInvocation linkerInvocation;
        protected final Path tempDirectory;
        protected final AbstractImage.NativeImageKind imageKind;

        AfterImageWriteAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, HostedUniverse hUniverse, LinkerInvocation linkerInvocation, Path tempDirectory, AbstractImage.NativeImageKind imageKind, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, debugContext);
            this.hUniverse = hUniverse;
            this.linkerInvocation = linkerInvocation;
            this.tempDirectory = tempDirectory;
            this.imageKind = imageKind;
        }

        public HostedUniverse getUniverse() {
            return this.hUniverse;
        }

        public Path getImagePath() {
            return this.linkerInvocation.getOutputFile();
        }

        public Path getTempDirectory() {
            return this.tempDirectory;
        }

        public AbstractImage.NativeImageKind getImageKind() {
            return this.imageKind;
        }

        public List<String> getImageSymbols(boolean onlyGlobal) {
            return this.linkerInvocation.getImageSymbols(onlyGlobal);
        }
    }

    public static class BeforeImageWriteAccessImpl
    extends FeatureAccessImpl
    implements Feature.BeforeImageWriteAccess {
        private List<Function<LinkerInvocation, LinkerInvocation>> linkerInvocationTransformers = null;
        protected final String imageName;
        protected final AbstractImage image;
        protected final RuntimeConfiguration runtimeConfig;
        protected final AnalysisUniverse aUniverse;
        protected final HostedUniverse hUniverse;
        protected final HostedOptionProvider optionProvider;
        protected final HostedMetaAccess hMetaAccess;

        BeforeImageWriteAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, String imageName, AbstractImage image, RuntimeConfiguration runtimeConfig, AnalysisUniverse aUniverse, HostedUniverse hUniverse, HostedOptionProvider optionProvider, HostedMetaAccess hMetaAccess, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, debugContext);
            this.imageName = imageName;
            this.image = image;
            this.runtimeConfig = runtimeConfig;
            this.aUniverse = aUniverse;
            this.hUniverse = hUniverse;
            this.optionProvider = optionProvider;
            this.hMetaAccess = hMetaAccess;
        }

        public String getImageName() {
            return this.imageName;
        }

        public AbstractImage getImage() {
            return this.image;
        }

        public RuntimeConfiguration getRuntimeConfiguration() {
            return this.runtimeConfig;
        }

        public HostedUniverse getHostedUniverse() {
            return this.hUniverse;
        }

        public HostedOptionProvider getHostedOptionProvider() {
            return this.optionProvider;
        }

        public HostedMetaAccess getHostedMetaAccess() {
            return this.hMetaAccess;
        }

        public Iterable<Function<LinkerInvocation, LinkerInvocation>> getLinkerInvocationTransformers() {
            if (this.linkerInvocationTransformers == null) {
                return Collections.emptyList();
            }
            return this.linkerInvocationTransformers;
        }

        public void registerLinkerInvocationTransformer(Function<LinkerInvocation, LinkerInvocation> transformer) {
            if (this.linkerInvocationTransformers == null) {
                this.linkerInvocationTransformers = new ArrayList<Function<LinkerInvocation, LinkerInvocation>>();
            }
            this.linkerInvocationTransformers.add(transformer);
        }
    }

    public static class AfterHeapLayoutAccessImpl
    extends FeatureAccessImpl
    implements Feature.AfterHeapLayoutAccess {
        protected final HostedMetaAccess hMetaAccess;
        protected final NativeImageHeap heap;

        public AfterHeapLayoutAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, NativeImageHeap heap, HostedMetaAccess hMetaAccess, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, debugContext);
            this.heap = heap;
            this.hMetaAccess = hMetaAccess;
        }

        public HostedMetaAccess getMetaAccess() {
            return this.hMetaAccess;
        }

        public NativeImageHeap getHeap() {
            return this.heap;
        }
    }

    public static class AfterCompilationAccessImpl
    extends CompilationAccessImpl
    implements Feature.AfterCompilationAccess {
        private Collection<CompileQueue.CompileTask> compilationTasks;

        public AfterCompilationAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, AnalysisUniverse aUniverse, HostedUniverse hUniverse, Collection<CompileQueue.CompileTask> compilationTasks, NativeImageHeap heap, DebugContext debugContext, SharedRuntimeConfigurationBuilder runtimeBuilder) {
            super(featureHandler, imageClassLoader, aUniverse, hUniverse, heap, debugContext, runtimeBuilder);
            this.compilationTasks = compilationTasks;
        }

        public Collection<CompileQueue.CompileTask> getCompilationTasks() {
            return this.compilationTasks;
        }
    }

    public static class BeforeCompilationAccessImpl
    extends CompilationAccessImpl
    implements Feature.BeforeCompilationAccess {
        public BeforeCompilationAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, AnalysisUniverse aUniverse, HostedUniverse hUniverse, NativeImageHeap heap, DebugContext debugContext, SharedRuntimeConfigurationBuilder runtimeBuilder) {
            super(featureHandler, imageClassLoader, aUniverse, hUniverse, heap, debugContext, runtimeBuilder);
        }

        public SharedRuntimeConfigurationBuilder getRuntimeBuilder() {
            return this.runtimeBuilder;
        }
    }

    public static class CompilationAccessImpl
    extends FeatureAccessImpl
    implements Feature.CompilationAccess {
        protected final AnalysisUniverse aUniverse;
        protected final HostedUniverse hUniverse;
        protected final NativeImageHeap heap;
        protected final SharedRuntimeConfigurationBuilder runtimeBuilder;

        CompilationAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, AnalysisUniverse aUniverse, HostedUniverse hUniverse, NativeImageHeap heap, DebugContext debugContext, SharedRuntimeConfigurationBuilder runtimeBuilder) {
            super(featureHandler, imageClassLoader, debugContext);
            this.aUniverse = aUniverse;
            this.hUniverse = hUniverse;
            this.runtimeBuilder = runtimeBuilder;
            this.heap = heap;
        }

        public long objectFieldOffset(Field field) {
            return this.objectFieldOffset(this.getMetaAccess().lookupJavaField(field));
        }

        public long objectFieldOffset(HostedField hField) {
            int result = hField.getLocation();
            assert (result > 0);
            return result;
        }

        public void registerAsImmutable(Object object) {
            this.heap.registerAsImmutable(object);
        }

        public void registerAsImmutable(Object root, Predicate<Object> includeObject) {
            ArrayDeque<Object> worklist = new ArrayDeque<Object>();
            IdentityHashMap<Object, Boolean> registeredObjects = new IdentityHashMap<Object, Boolean>();
            worklist.push(root);
            while (!worklist.isEmpty()) {
                Object cur = worklist.pop();
                this.registerAsImmutable(cur);
                if (!this.getMetaAccess().optionalLookupJavaType(cur.getClass()).isPresent()) continue;
                if (cur instanceof Object[]) {
                    for (Object element : (Object[])cur) {
                        CompilationAccessImpl.addToWorklist(this.aUniverse.replaceObject(element), includeObject, worklist, registeredObjects);
                    }
                    continue;
                }
                JavaConstant constant = SubstrateObjectConstant.forObject(cur);
                for (HostedField field : ((HostedType)this.getMetaAccess().lookupJavaType(constant)).getInstanceFields(true)) {
                    if (!field.isAccessed() || field.getStorageKind() != JavaKind.Object) continue;
                    Object fieldValue = SubstrateObjectConstant.asObject((Constant)field.readValue(constant));
                    CompilationAccessImpl.addToWorklist(fieldValue, includeObject, worklist, registeredObjects);
                }
            }
        }

        private static void addToWorklist(Object object, Predicate<Object> includeObject, Deque<Object> worklist, IdentityHashMap<Object, Boolean> registeredObjects) {
            if (object == null || registeredObjects.containsKey(object)) {
                return;
            }
            if (object instanceof DynamicHub || object instanceof Class) {
                return;
            }
            if (!includeObject.test(object)) {
                return;
            }
            registeredObjects.put(object, Boolean.TRUE);
            worklist.push(object);
        }

        public HostedMetaAccess getMetaAccess() {
            return (HostedMetaAccess)this.getProviders().getMetaAccess();
        }

        public Providers getProviders() {
            return this.runtimeBuilder.getRuntimeConfig().getProviders();
        }

        public HostedUniverse getUniverse() {
            return this.hUniverse;
        }

        public Collection<? extends SharedType> getTypes() {
            return this.hUniverse.getTypes();
        }

        public Collection<? extends SharedField> getFields() {
            return this.hUniverse.getFields();
        }

        public Collection<? extends SharedMethod> getMethods() {
            return this.hUniverse.getMethods();
        }
    }

    public static class BeforeUniverseBuildingAccessImpl
    extends FeatureAccessImpl
    implements Feature.BeforeUniverseBuildingAccess {
        protected final HostedMetaAccess hMetaAccess;

        BeforeUniverseBuildingAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, DebugContext debugContext, HostedMetaAccess hMetaAccess) {
            super(featureHandler, imageClassLoader, debugContext);
            this.hMetaAccess = hMetaAccess;
        }

        public HostedMetaAccess getMetaAccess() {
            return this.hMetaAccess;
        }
    }

    public static class OnAnalysisExitAccessImpl
    extends AnalysisAccessBase
    implements Feature.OnAnalysisExitAccess {
        public OnAnalysisExitAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, Inflation bb, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, bb, debugContext);
        }
    }

    public static class AfterAnalysisAccessImpl
    extends AnalysisAccessBase
    implements Feature.AfterAnalysisAccess {
        public AfterAnalysisAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, Inflation bb, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, bb, debugContext);
        }
    }

    public static class DuringAnalysisAccessImpl
    extends BeforeAnalysisAccessImpl
    implements Feature.DuringAnalysisAccess {
        private boolean requireAnalysisIteration;

        public DuringAnalysisAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, Inflation bb, NativeLibraries nativeLibraries, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, bb, nativeLibraries, debugContext);
        }

        public void requireAnalysisIteration() {
            this.requireAnalysisIteration = true;
        }

        public boolean getAndResetRequireAnalysisIteration() {
            boolean result = this.requireAnalysisIteration;
            this.requireAnalysisIteration = false;
            return result;
        }
    }

    public static class BeforeAnalysisAccessImpl
    extends AnalysisAccessBase
    implements Feature.BeforeAnalysisAccess {
        private final NativeLibraries nativeLibraries;

        public BeforeAnalysisAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, Inflation bb, NativeLibraries nativeLibraries, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, bb, debugContext);
            this.nativeLibraries = nativeLibraries;
        }

        public NativeLibraries getNativeLibraries() {
            return this.nativeLibraries;
        }

        public void registerAsUsed(Class<?> clazz) {
            this.registerAsUsed(this.getMetaAccess().lookupJavaType(clazz));
        }

        public void registerAsUsed(AnalysisType aType) {
            aType.registerAsReachable();
        }

        public void registerAsInHeap(Class<?> clazz) {
            this.registerAsInHeap(this.getMetaAccess().lookupJavaType(clazz));
        }

        public void registerAsInHeap(AnalysisType aType) {
            aType.registerAsInHeap();
        }

        public void registerAsAccessed(Field field) {
            this.getMetaAccess().lookupJavaType(field.getDeclaringClass()).registerAsReachable();
            this.registerAsAccessed(this.getMetaAccess().lookupJavaField(field));
        }

        public void registerAsAccessed(AnalysisField aField) {
            aField.registerAsAccessed();
        }

        public void registerAsRead(Field field) {
            this.getMetaAccess().lookupJavaType(field.getDeclaringClass()).registerAsReachable();
            this.registerAsRead(this.getMetaAccess().lookupJavaField(field));
        }

        public void registerAsRead(AnalysisField aField) {
            aField.registerAsRead(null);
        }

        public void registerAsUnsafeAccessed(Field field) {
            this.getMetaAccess().lookupJavaType(field.getDeclaringClass()).registerAsReachable();
            this.registerAsUnsafeAccessed(this.getMetaAccess().lookupJavaField(field));
        }

        public boolean registerAsUnsafeAccessed(AnalysisField aField) {
            if (!aField.isUnsafeAccessed()) {
                aField.registerAsAccessed();
                aField.registerAsUnsafeAccessed(this.bb.getUniverse());
                this.bb.forceUnsafeUpdate(aField);
                return true;
            }
            return false;
        }

        public void registerAsFrozenUnsafeAccessed(Field field) {
            this.getMetaAccess().lookupJavaType(field.getDeclaringClass()).registerAsReachable();
            this.registerAsFrozenUnsafeAccessed(this.getMetaAccess().lookupJavaField(field));
        }

        public void registerAsFrozenUnsafeAccessed(AnalysisField aField) {
            aField.setUnsafeFrozenTypeState(true);
            this.registerAsUnsafeAccessed(aField);
        }

        public void registerAsUnsafeAccessed(Field field, UnsafePartitionKind partitionKind) {
            this.registerAsUnsafeAccessed(this.getMetaAccess().lookupJavaField(field), partitionKind);
        }

        public void registerAsUnsafeAccessed(AnalysisField aField, UnsafePartitionKind partitionKind) {
            if (!aField.isUnsafeAccessed()) {
                aField.registerAsAccessed();
                aField.registerAsUnsafeAccessed(this.bb.getUniverse(), partitionKind);
                this.bb.forceUnsafeUpdate(aField);
            }
        }

        public void registerAsInvoked(Executable method) {
            this.registerAsInvoked(this.getMetaAccess().lookupJavaMethod(method));
        }

        public void registerAsInvoked(AnalysisMethod aMethod) {
            this.bb.addRootMethod(aMethod).registerAsImplementationInvoked(null);
        }

        public void registerAsCompiled(Executable method) {
            this.registerAsCompiled(this.getMetaAccess().lookupJavaMethod(method));
        }

        public void registerAsCompiled(AnalysisMethod aMethod) {
            this.registerAsInvoked(aMethod);
            CompilationInfoSupport.singleton().registerForcedCompilation((ResolvedJavaMethod)aMethod);
        }

        public void registerUnsafeFieldsRecomputed(Class<?> clazz) {
            this.getMetaAccess().lookupJavaType(clazz).registerUnsafeFieldsRecomputed();
        }

        public SVMHost getHostVM() {
            return this.bb.getHostVM();
        }

        public void registerHierarchyForReflectiveInstantiation(Class<?> c) {
            this.findSubclasses(c).stream().filter(clazz -> !Modifier.isAbstract(clazz.getModifiers())).forEach(clazz -> RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{clazz}));
        }

        public void registerReachabilityHandler(Consumer<Feature.DuringAnalysisAccess> callback, Object ... elements) {
            ReachabilityHandlerFeature.singleton().registerReachabilityHandler(this, callback, elements);
        }

        public void registerMethodOverrideReachabilityHandler(BiConsumer<Feature.DuringAnalysisAccess, Executable> callback, Executable baseMethod) {
            ReachabilityHandlerFeature.singleton().registerMethodOverrideReachabilityHandler(this, callback, baseMethod);
        }

        public void registerSubtypeReachabilityHandler(BiConsumer<Feature.DuringAnalysisAccess, Class<?>> callback, Class<?> baseClass) {
            ReachabilityHandlerFeature.singleton().registerSubtypeReachabilityHandler(this, callback, baseClass);
        }

        public void registerClassInitializerReachabilityHandler(Consumer<Feature.DuringAnalysisAccess> callback, Class<?> clazz) {
            ReachabilityHandlerFeature.singleton().registerClassInitializerReachabilityHandler(this, callback, clazz);
        }
    }

    public static class DuringSetupAccessImpl
    extends AnalysisAccessBase
    implements Feature.DuringSetupAccess {
        public DuringSetupAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, Inflation bb, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, bb, debugContext);
        }

        public void registerObjectReplacer(Function<Object, Object> replacer) {
            this.getUniverse().registerObjectReplacer(replacer);
        }

        public void registerSubstitutionProcessor(SubstitutionProcessor substitution) {
            this.getUniverse().registerFeatureSubstitution(substitution);
        }

        public void registerNativeSubstitutionProcessor(SubstitutionProcessor substitution) {
            this.getUniverse().registerFeatureNativeSubstitution(substitution);
        }

        public void registerClassReachabilityListener(BiConsumer<Feature.DuringAnalysisAccess, Class<?>> listener) {
            this.getHostVM().registerClassReachabilityListener(listener);
        }

        public SVMHost getHostVM() {
            return this.bb.getHostVM();
        }
    }

    static abstract class AnalysisAccessBase
    extends FeatureAccessImpl {
        protected final Inflation bb;

        AnalysisAccessBase(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, Inflation bb, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, debugContext);
            this.bb = bb;
        }

        public BigBang getBigBang() {
            return this.bb;
        }

        public AnalysisUniverse getUniverse() {
            return this.bb.getUniverse();
        }

        public AnalysisMetaAccess getMetaAccess() {
            return this.bb.getMetaAccess();
        }

        public boolean isReachable(Class<?> clazz) {
            return this.isReachable(this.getMetaAccess().lookupJavaType(clazz));
        }

        public boolean isReachable(AnalysisType type) {
            return type.isReachable();
        }

        public boolean isReachable(Field field) {
            return this.isReachable(this.getMetaAccess().lookupJavaField(field));
        }

        public boolean isReachable(AnalysisField field) {
            return field.isAccessed();
        }

        public boolean isReachable(Executable method) {
            return this.isReachable(this.getMetaAccess().lookupJavaMethod(method));
        }

        public boolean isReachable(AnalysisMethod method) {
            return method.isReachable();
        }

        public Set<Class<?>> reachableSubtypes(Class<?> baseClass) {
            return this.reachableSubtypes(this.getMetaAccess().lookupJavaType(baseClass)).stream().map(AnalysisType::getJavaClass).collect(Collectors.toCollection(HashSet::new));
        }

        Set<AnalysisType> reachableSubtypes(AnalysisType baseType) {
            Set result = AnalysisUniverse.getAllSubtypes((AnalysisType)baseType);
            result.removeIf(t -> !this.isReachable((AnalysisType)t));
            return result;
        }

        public Set<Executable> reachableMethodOverrides(Executable baseMethod) {
            return this.reachableMethodOverrides(this.getMetaAccess().lookupJavaMethod(baseMethod)).stream().map(AnalysisMethod::getJavaMethod).collect(Collectors.toCollection(LinkedHashSet::new));
        }

        Set<AnalysisMethod> reachableMethodOverrides(AnalysisMethod baseMethod) {
            return AnalysisUniverse.getMethodImplementations((BigBang)this.getBigBang(), (AnalysisMethod)baseMethod, (boolean)true);
        }
    }

    public static class AfterRegistrationAccessImpl
    extends FeatureAccessImpl
    implements Feature.AfterRegistrationAccess {
        private final MetaAccessProvider metaAccess;
        private Pair<Method, CEntryPointData> mainEntryPoint;

        public AfterRegistrationAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, MetaAccessProvider metaAccess, Pair<Method, CEntryPointData> mainEntryPoint, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, debugContext);
            this.metaAccess = metaAccess;
            this.mainEntryPoint = mainEntryPoint;
        }

        public MetaAccessProvider getMetaAccess() {
            return this.metaAccess;
        }

        public void setMainEntryPoint(Pair<Method, CEntryPointData> mainEntryPoint) {
            this.mainEntryPoint = mainEntryPoint;
        }

        public Pair<Method, CEntryPointData> getMainEntryPoint() {
            return this.mainEntryPoint;
        }
    }

    public static class IsInConfigurationAccessImpl
    extends FeatureAccessImpl
    implements Feature.IsInConfigurationAccess {
        IsInConfigurationAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, debugContext);
        }
    }

    public static abstract class FeatureAccessImpl
    implements Feature.FeatureAccess {
        protected final FeatureHandler featureHandler;
        protected final ImageClassLoader imageClassLoader;
        protected final DebugContext debugContext;

        FeatureAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, DebugContext debugContext) {
            this.featureHandler = featureHandler;
            this.imageClassLoader = imageClassLoader;
            this.debugContext = debugContext;
        }

        public ImageClassLoader getImageClassLoader() {
            return this.imageClassLoader;
        }

        public Class<?> findClassByName(String className) {
            return this.imageClassLoader.findClass(className).get();
        }

        public <T> List<Class<? extends T>> findSubclasses(Class<T> baseClass) {
            return this.imageClassLoader.findSubclasses(baseClass, false);
        }

        public List<Class<?>> findAnnotatedClasses(Class<? extends Annotation> annotationClass) {
            return this.imageClassLoader.findAnnotatedClasses(annotationClass, false);
        }

        public List<Method> findAnnotatedMethods(Class<? extends Annotation> annotationClass) {
            return this.imageClassLoader.findAnnotatedMethods(annotationClass);
        }

        public List<Field> findAnnotatedFields(Class<? extends Annotation> annotationClass) {
            return this.imageClassLoader.findAnnotatedFields(annotationClass);
        }

        public FeatureHandler getFeatureHandler() {
            return this.featureHandler;
        }

        public DebugContext getDebugContext() {
            return this.debugContext;
        }

        public List<Path> getApplicationClassPath() {
            return this.imageClassLoader.applicationClassPath();
        }

        public List<Path> getApplicationModulePath() {
            return this.imageClassLoader.applicationModulePath();
        }

        public ClassLoader getApplicationClassLoader() {
            return this.imageClassLoader.getClassLoader();
        }
    }
}

