/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.target;

import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.jdk.Package_jdk_internal_reflect;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.reflect.target.Target_jdk_internal_reflect_ConstantPool_Tag;
import java.lang.reflect.Field;
import java.lang.reflect.Member;

@TargetClass(classNameProvider=Package_jdk_internal_reflect.class, className="ConstantPool")
public final class Target_jdk_internal_reflect_ConstantPool {
    @Delete
    private Object constantPoolOop;

    @Substitute
    public int getSize() {
        return Integer.MAX_VALUE;
    }

    @Substitute
    public Class<?> getClassAt(int index) {
        return NonmovableArrays.getObject(CodeInfoAccess.getFrameInfoSourceClasses(CodeInfoTable.getImageCodeInfo()), index);
    }

    @Substitute
    public Class<?> getClassAtIfLoaded(int index) {
        throw VMError.unimplemented();
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    public int getClassRefIndexAt(int index) {
        throw VMError.unimplemented();
    }

    @Substitute
    public Member getMethodAt(int index) {
        throw VMError.unimplemented();
    }

    @Substitute
    public Member getMethodAtIfLoaded(int index) {
        throw VMError.unimplemented();
    }

    @Substitute
    public Field getFieldAt(int index) {
        throw VMError.unimplemented();
    }

    @Substitute
    public Field getFieldAtIfLoaded(int index) {
        throw VMError.unimplemented();
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    public String[] getMemberRefInfoAt(int index) {
        throw VMError.unimplemented();
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    public int getNameAndTypeRefIndexAt(int index) {
        throw VMError.unimplemented();
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    public String[] getNameAndTypeRefInfoAt(int index) {
        throw VMError.unimplemented();
    }

    @Substitute
    public int getIntAt(int index) {
        throw VMError.unimplemented();
    }

    @Substitute
    public long getLongAt(int index) {
        throw VMError.unimplemented();
    }

    @Substitute
    public float getFloatAt(int index) {
        throw VMError.unimplemented();
    }

    @Substitute
    public double getDoubleAt(int index) {
        throw VMError.unimplemented();
    }

    @Substitute
    public String getStringAt(int index) {
        return NonmovableArrays.getObject(CodeInfoAccess.getFrameInfoSourceMethodNames(CodeInfoTable.getImageCodeInfo()), index);
    }

    @Substitute
    public String getUTF8At(int index) {
        return this.getStringAt(index);
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    public Target_jdk_internal_reflect_ConstantPool_Tag getTagAt(int index) {
        throw VMError.unimplemented();
    }

    @Delete
    private native int getSize0(Object var1);

    @Delete
    private native Class<?> getClassAt0(Object var1, int var2);

    @Delete
    private native Class<?> getClassAtIfLoaded0(Object var1, int var2);

    @Delete
    @TargetElement(onlyWith={JDK11OrLater.class})
    private native int getClassRefIndexAt0(Object var1, int var2);

    @Delete
    private native Member getMethodAt0(Object var1, int var2);

    @Delete
    private native Member getMethodAtIfLoaded0(Object var1, int var2);

    @Delete
    private native Field getFieldAt0(Object var1, int var2);

    @Delete
    private native Field getFieldAtIfLoaded0(Object var1, int var2);

    @Delete
    @TargetElement(onlyWith={JDK11OrLater.class})
    private native String[] getMemberRefInfoAt0(Object var1, int var2);

    @Delete
    @TargetElement(onlyWith={JDK11OrLater.class})
    private native int getNameAndTypeRefIndexAt0(Object var1, int var2);

    @Delete
    @TargetElement(onlyWith={JDK11OrLater.class})
    private native String[] getNameAndTypeRefInfoAt0(Object var1, int var2);

    @Delete
    private native int getIntAt0(Object var1, int var2);

    @Delete
    private native long getLongAt0(Object var1, int var2);

    @Delete
    private native float getFloatAt0(Object var1, int var2);

    @Delete
    private native double getDoubleAt0(Object var1, int var2);

    @Delete
    private native String getStringAt0(Object var1, int var2);

    @Delete
    private native String getUTF8At0(Object var1, int var2);

    @Delete
    @TargetElement(onlyWith={JDK11OrLater.class})
    private native byte getTagAt0(Object var1, int var2);
}

