/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.core.jni.JNIRuntimeAccess;
import com.oracle.svm.hosted.FeatureImpl;
import java.io.File;
import java.io.FileDescriptor;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.InternalPlatform;

@Platforms(value={InternalPlatform.PLATFORM_JNI.class})
@AutomaticFeature
class JNIRegistrationJava
extends JNIRegistrationUtil
implements Feature {
    private static final Consumer<Feature.DuringAnalysisAccess> CORESERVICES_LINKER = duringAnalysisAccess -> {
        FeatureImpl.DuringAnalysisAccessImpl accessImpl = (FeatureImpl.DuringAnalysisAccessImpl)duringAnalysisAccess;
        accessImpl.getNativeLibraries().addDynamicNonJniLibrary("-framework CoreServices");
    };

    JNIRegistrationJava() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        JNIRegistrationJava.registerForThrowNew((Feature.FeatureAccess)a, "java.lang.Exception", "java.lang.Error", "java.lang.OutOfMemoryError", "java.lang.RuntimeException", "java.lang.NullPointerException", "java.lang.ArrayIndexOutOfBoundsException", "java.lang.IllegalArgumentException", "java.lang.IllegalAccessException", "java.lang.IllegalAccessError", "java.lang.InternalError", "java.lang.NoSuchFieldException", "java.lang.NoSuchMethodException", "java.lang.ClassNotFoundException", "java.lang.NumberFormatException", "java.lang.NoSuchFieldError", "java.lang.NoSuchMethodError", "java.lang.UnsatisfiedLinkError", "java.lang.StringIndexOutOfBoundsException", "java.lang.InstantiationException", "java.lang.UnsupportedOperationException", "java.io.IOException", "java.io.FileNotFoundException", "java.io.SyncFailedException", "java.io.InterruptedIOException", "java.util.zip.DataFormatException");
        JNIRuntimeAccess.register(JNIRegistrationJava.constructor((Feature.FeatureAccess)a, "java.io.FileNotFoundException", String.class, String.class));
        JNIRuntimeAccess.register(JNIRegistrationJava.clazz((Feature.FeatureAccess)a, "java.lang.Integer"));
        JNIRuntimeAccess.register(JNIRegistrationJava.constructor((Feature.FeatureAccess)a, "java.lang.Integer", Integer.TYPE));
        JNIRuntimeAccess.register(JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.lang.Integer", "value"));
        JNIRuntimeAccess.register(JNIRegistrationJava.clazz((Feature.FeatureAccess)a, "java.lang.Boolean"));
        JNIRuntimeAccess.register(JNIRegistrationJava.constructor((Feature.FeatureAccess)a, "java.lang.Boolean", Boolean.TYPE));
        JNIRuntimeAccess.register(JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.lang.Boolean", "value"));
        JNIRuntimeAccess.register(JNIRegistrationJava.method((Feature.FeatureAccess)a, "java.lang.Boolean", "getBoolean", String.class));
        JNIRuntimeAccess.register(FileDescriptor.class);
        JNIRuntimeAccess.register(JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.io.FileDescriptor", "fd"));
        if (JNIRegistrationJava.isWindows()) {
            JNIRuntimeAccess.register(JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.io.FileDescriptor", "handle"));
        }
        if (JavaVersionUtil.JAVA_SPEC >= 11) {
            JNIRuntimeAccess.register(JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.io.FileDescriptor", "append"));
        }
        JNIRuntimeAccess.register(JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.io.FileOutputStream", "fd"));
        JNIRuntimeAccess.register(JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.io.FileInputStream", "fd"));
        JNIRuntimeAccess.register(File.class);
        JNIRuntimeAccess.register(JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.io.File", "path"));
        JNIRuntimeAccess.register(byte[].class);
        JNIRuntimeAccess.register(String.class);
        JNIRuntimeAccess.register(System.class);
        JNIRuntimeAccess.register(JNIRegistrationJava.method((Feature.FeatureAccess)a, "java.lang.System", "getProperty", String.class));
        JNIRuntimeAccess.register(Charset.class);
        JNIRuntimeAccess.register(JNIRegistrationJava.method((Feature.FeatureAccess)a, "java.nio.charset.Charset", "isSupported", String.class));
        JNIRuntimeAccess.register(JNIRegistrationJava.constructor((Feature.FeatureAccess)a, "java.lang.String", byte[].class, String.class));
        JNIRuntimeAccess.register(JNIRegistrationJava.method((Feature.FeatureAccess)a, "java.lang.String", "getBytes", String.class));
        JNIRuntimeAccess.register(JNIRegistrationJava.method((Feature.FeatureAccess)a, "java.lang.String", "getBytes", new Class[0]));
        JNIRuntimeAccess.register(JNIRegistrationJava.method((Feature.FeatureAccess)a, "java.lang.String", "concat", String.class));
        if (JavaVersionUtil.JAVA_SPEC >= 11) {
            JNIRuntimeAccess.register(JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.lang.String", "coder", "value"));
        }
        a.registerReachabilityHandler(JNIRegistrationJava::registerRandomAccessFileInitIDs, new Object[]{JNIRegistrationJava.method((Feature.FeatureAccess)a, "java.io.RandomAccessFile", "initIDs", new Class[0])});
        if (JNIRegistrationJava.isWindows()) {
            PlatformNativeLibrarySupport.singleton().addBuiltinPkgNativePrefix("sun_security_provider_NativeSeedGenerator");
        }
        if (JNIRegistrationJava.isDarwin()) {
            List<Method> darwinMethods = Arrays.asList(JNIRegistrationJava.method((Feature.FeatureAccess)a, "apple.security.KeychainStore", "_scanKeychain", new Class[0]), JNIRegistrationJava.method((Feature.FeatureAccess)a, "apple.security.KeychainStore", "_releaseKeychainItemRef", Long.TYPE), JNIRegistrationJava.method((Feature.FeatureAccess)a, "apple.security.KeychainStore", "_addItemToKeychain", String.class, Boolean.TYPE, byte[].class, char[].class), JNIRegistrationJava.method((Feature.FeatureAccess)a, "apple.security.KeychainStore", "_removeItemFromKeychain", Long.TYPE), JNIRegistrationJava.method((Feature.FeatureAccess)a, "apple.security.KeychainStore", "_getEncodedKeyData", Long.TYPE, char[].class));
            if (JavaVersionUtil.JAVA_SPEC >= 11) {
                ArrayList<Method> methods = new ArrayList<Method>(darwinMethods);
                methods.addAll(Arrays.asList(JNIRegistrationJava.method((Feature.FeatureAccess)a, "sun.nio.fs.MacOSXFileSystemProvider", "getFileTypeDetector", new Class[0]), JNIRegistrationJava.method((Feature.FeatureAccess)a, "sun.net.spi.DefaultProxySelector", "getSystemProxies", String.class, String.class), JNIRegistrationJava.method((Feature.FeatureAccess)a, "sun.net.spi.DefaultProxySelector", "init", new Class[0])));
                a.registerReachabilityHandler(CORESERVICES_LINKER, methods.toArray(new Object[0]));
            } else {
                a.registerReachabilityHandler(CORESERVICES_LINKER, darwinMethods.toArray(new Object[0]));
            }
        }
        if (JavaVersionUtil.JAVA_SPEC >= 11) {
            a.registerReachabilityHandler(JNIRegistrationJava::registerProcessHandleImplInfoInitIDs, new Object[]{JNIRegistrationJava.method((Feature.FeatureAccess)a, "java.lang.ProcessHandleImpl$Info", "initIDs", new Class[0])});
        }
    }

    private static void registerProcessHandleImplInfoInitIDs(Feature.DuringAnalysisAccess a) {
        JNIRuntimeAccess.register(JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.lang.ProcessHandleImpl$Info", "command", "commandLine", "arguments", "startTime", "totalTime", "user"));
    }

    private static void registerRandomAccessFileInitIDs(Feature.DuringAnalysisAccess a) {
        JNIRuntimeAccess.register(JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.io.RandomAccessFile", "fd"));
    }
}

