/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.heap.PhysicalMemory;
import com.oracle.svm.core.windows.headers.SysinfoAPI;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

class WindowsPhysicalMemory
extends PhysicalMemory {
    WindowsPhysicalMemory() {
    }

    @AutomaticFeature
    static class PhysicalMemoryFeature
    implements Feature {
        PhysicalMemoryFeature() {
        }

        public void afterRegistration(Feature.AfterRegistrationAccess access) {
            ImageSingletons.add(PhysicalMemory.PhysicalMemorySupport.class, (Object)new WindowsPhysicalMemorySupportImpl());
        }
    }

    static class WindowsPhysicalMemorySupportImpl
    implements PhysicalMemory.PhysicalMemorySupport {
        WindowsPhysicalMemorySupportImpl() {
        }

        @Override
        public UnsignedWord size() {
            SysinfoAPI.MEMORYSTATUSEX memStatusEx = (SysinfoAPI.MEMORYSTATUSEX)StackValue.get(SysinfoAPI.MEMORYSTATUSEX.class);
            memStatusEx.set_dwLength(SizeOf.get(SysinfoAPI.MEMORYSTATUSEX.class));
            SysinfoAPI.GlobalMemoryStatusEx(memStatusEx);
            return WordFactory.unsigned((long)memStatusEx.ullTotalPhys());
        }
    }
}

