/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.jdk.Jvm;
import com.oracle.svm.core.windows.WindowsUtils;
import java.io.Console;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.VoidPointer;
import org.graalvm.word.WordFactory;

@TargetClass(value=System.class)
@Platforms(value={Platform.WINDOWS.class})
final class Target_java_lang_System {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    static volatile Console cons;

    Target_java_lang_System() {
    }

    @Substitute
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected static long nanoTime() {
        return WindowsUtils.getNanoCounter();
    }

    @Substitute
    public static String mapLibraryName(String libname) {
        return libname + ".dll";
    }

    @Substitute
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long currentTimeMillis() {
        return Jvm.JVM_CurrentTimeMillis((VoidPointer)WordFactory.nullPointer(), (VoidPointer)WordFactory.nullPointer());
    }
}

