/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.pthread;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.posix.pthread.PthreadVMLockSupport;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;

final class PthreadVMMutex
extends VMMutex {
    protected UnsignedWord structOffset;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected PthreadVMMutex(String name) {
        super(name);
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    protected Pthread.pthread_mutex_t getStructPointer() {
        return (Pthread.pthread_mutex_t)Word.objectToUntrackedPointer((Object)PthreadVMLockSupport.singleton().pthreadStructs).add(this.structOffset);
    }

    @Override
    public VMMutex lock() {
        this.assertNotOwner("Recursive locking is not supported");
        PthreadVMLockSupport.checkResult(Pthread.pthread_mutex_lock(this.getStructPointer()), "pthread_mutex_lock");
        this.setOwnerToCurrentThread();
        return this;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", callerMustBe=true)
    public void lockNoTransition() {
        this.assertNotOwner("Recursive locking is not supported");
        PthreadVMLockSupport.checkResult(Pthread.pthread_mutex_lock_no_transition(this.getStructPointer()), "pthread_mutex_lock");
        this.setOwnerToCurrentThread();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", callerMustBe=true)
    public void lockNoTransitionUnspecifiedOwner() {
        PthreadVMLockSupport.checkResult(Pthread.pthread_mutex_lock_no_transition(this.getStructPointer()), "pthread_mutex_lock");
        this.setOwnerToUnspecified();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.")
    public void unlock() {
        this.clearCurrentThreadOwner();
        PthreadVMLockSupport.checkResult(Pthread.pthread_mutex_unlock(this.getStructPointer()), "pthread_mutex_unlock");
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.")
    public void unlockNoTransitionUnspecifiedOwner() {
        this.clearUnspecifiedOwner();
        PthreadVMLockSupport.checkResult(Pthread.pthread_mutex_unlock(this.getStructPointer()), "pthread_mutex_unlock");
    }

    @Override
    public void unlockWithoutChecks() {
        this.clearCurrentThreadOwner();
        Pthread.pthread_mutex_unlock(this.getStructPointer());
    }
}

