/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.resources;

import com.oracle.svm.core.jdk.resources.NativeImageResourceFileSystem;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Formatter;

public class NativeImageResourceFileAttributes
implements BasicFileAttributes {
    private final NativeImageResourceFileSystem fileSystem;
    private final NativeImageResourceFileSystem.Entry entry;

    public NativeImageResourceFileAttributes(NativeImageResourceFileSystem fileSystem, NativeImageResourceFileSystem.Entry entry) {
        this.fileSystem = fileSystem;
        this.entry = entry;
    }

    public String getName() {
        return this.fileSystem.getString(this.entry.name);
    }

    @Override
    public FileTime lastModifiedTime() {
        return FileTime.fromMillis(this.entry.lastModifiedTime);
    }

    @Override
    public FileTime lastAccessTime() {
        return FileTime.fromMillis(this.entry.lastAccessTime);
    }

    @Override
    public FileTime creationTime() {
        return FileTime.fromMillis(this.entry.createTime);
    }

    @Override
    public boolean isRegularFile() {
        return !this.entry.isDirectory();
    }

    @Override
    public boolean isDirectory() {
        return this.entry.isDirectory();
    }

    @Override
    public boolean isSymbolicLink() {
        return false;
    }

    @Override
    public boolean isOther() {
        return false;
    }

    @Override
    public long size() {
        return this.entry.size();
    }

    @Override
    public Object fileKey() {
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        Formatter fm = new Formatter(sb);
        fm.format("    name            : %s%n", this.getName());
        fm.format("    creationTime    : %tc%n", this.creationTime().toMillis());
        fm.format("    lastAccessTime  : %tc%n", this.lastAccessTime().toMillis());
        fm.format("    lastModifiedTime: %tc%n", this.lastModifiedTime().toMillis());
        fm.format("    isRegularFile   : %b%n", this.isRegularFile());
        fm.format("    isDirectory     : %b%n", this.isDirectory());
        fm.format("    isSymbolicLink  : %b%n", this.isSymbolicLink());
        fm.format("    isOther         : %b%n", this.isOther());
        fm.format("    fileKey         : %s%n", this.fileKey());
        fm.format("    size            : %d%n", this.size());
        fm.close();
        return sb.toString();
    }
}

