/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.graal.nodes.NewStoredContinuationNode;
import com.oracle.svm.core.heap.CodeReferenceMapDecoder;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.thread.JavaContinuations;
import com.oracle.svm.core.thread.Safepoint;
import com.oracle.svm.core.thread.Target_java_lang_Continuation;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.util.TypeConversion;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class StoredContinuationImpl {
    private static final int FRAME_COUNT_OFFSET_TO_PAYLOAD = -12;
    private static final int SIZE_OFFSET_TO_PAYLOAD = -8;
    private static final int VALID_OFFSET_START = -12;
    private static final int PAYLOAD_OFFSET = 16;
    private static final int SHARED_REFERENCE_MAP_ENCODING_OFFSET = 0;
    private static final int SHARED_REFERENCE_MAP_ENCODING_SIZE = 8;
    private static final int FRAME_META_START_OFFSET = 8;
    private static final int FRAME_META_SIZE = 8;
    private static final int SIZE_OFFSET_IN_FRAME_META = 0;
    private static final int REFERENCE_MAP_INDEX_OFFSET_IN_FRAME_META = 4;
    private static final int HEADER_SIZE = 16;

    private static StoredContinuation allocate(long size) {
        return NewStoredContinuationNode.allocate(size);
    }

    @Uninterruptible(reason="allocates StoredContinuation instance", calleeMustBe=false)
    private static StoredContinuation allocateWriteFrameCount(long payloadSize, int frameCount) {
        assert (payloadSize % 8L == 0L);
        StoredContinuation f = StoredContinuationImpl.allocate(payloadSize + 16L);
        Pointer payload = StoredContinuationImpl.payloadLocation(f);
        payload.writeLong(-8, payloadSize);
        payload.writeInt(-12, frameCount);
        return f;
    }

    @Uninterruptible(reason="read StoredContinuation")
    private static boolean checkOffset(StoredContinuation f, int offset) {
        boolean result = true;
        assert (result &= offset % 4 == 0);
        if (offset >= 0 ? !$assertionsDisabled && !(result &= (long)offset < StoredContinuationImpl.readSize(f)) : !$assertionsDisabled && !(result &= offset >= -12)) {
            throw new AssertionError();
        }
        return result;
    }

    @Uninterruptible(reason="read StoredContinuation")
    private static boolean checkPayloadOffset(StoredContinuation f, int offset) {
        boolean valid = true;
        assert (valid &= offset % 4 == 0);
        assert (valid &= offset >= 0);
        assert (valid &= (long)offset < StoredContinuationImpl.readSize(f));
        return valid;
    }

    @Uninterruptible(reason="read StoredContinuation")
    private static int readPayloadInt(StoredContinuation f, int offset) {
        StoredContinuationImpl.checkOffset(f, offset);
        return StoredContinuationImpl.payloadLocation(f).readInt(offset);
    }

    @Uninterruptible(reason="read StoredContinuation")
    private static long readPayloadLong(StoredContinuation f, int offset) {
        StoredContinuationImpl.checkOffset(f, offset);
        return StoredContinuationImpl.payloadLocation(f).readLong(offset);
    }

    @Uninterruptible(reason="write StoredContinuation")
    private static void writePayloadLong(StoredContinuation f, int offset, long value) {
        StoredContinuationImpl.checkPayloadOffset(f, offset);
        StoredContinuationImpl.payloadLocation(f).writeLong(offset, value);
    }

    @Uninterruptible(reason="write StoredContinuation")
    private static void writePayloadInt(StoredContinuation f, int offset, int value) {
        StoredContinuationImpl.checkPayloadOffset(f, offset);
        StoredContinuationImpl.payloadLocation(f).writeInt(offset, value);
    }

    @Uninterruptible(reason="read StoredContinuation")
    private static long readPayloadSize(StoredContinuation f) {
        return StoredContinuationImpl.readPayloadLong(f, -8);
    }

    @Uninterruptible(reason="read StoredContinuation")
    public static long readAllFrameSize(StoredContinuation f) {
        return StoredContinuationImpl.readPayloadSize(f) - (long)StoredContinuationImpl.readFrameMetaSize(f);
    }

    @Uninterruptible(reason="read StoredContinuation")
    public static long readSize(StoredContinuation f) {
        return StoredContinuationImpl.readPayloadSize(f) + 16L;
    }

    @Uninterruptible(reason="read StoredContinuation")
    public static int readFrameCount(StoredContinuation f) {
        return StoredContinuationImpl.readPayloadInt(f, -12);
    }

    @Uninterruptible(reason="read StoredContinuation")
    private static NonmovableArray<Byte> readReferenceMapEncoding(StoredContinuation f) {
        return (NonmovableArray)WordFactory.pointer((long)StoredContinuationImpl.payloadLocation(f).readLong(0));
    }

    @Uninterruptible(reason="read StoredContinuation")
    private static int readFrameMetaSize(StoredContinuation f) {
        return 8 + StoredContinuationImpl.readFrameCount(f) * 8;
    }

    @Uninterruptible(reason="read StoredContinuation")
    public static int readFrameSize(StoredContinuation f, int frameIndex) {
        return StoredContinuationImpl.payloadLocation(f).readInt(8 + frameIndex * 8 + 0);
    }

    @Uninterruptible(reason="read StoredContinuation")
    private static int readReferenceMapIndex(StoredContinuation f, int frameIndex) {
        return StoredContinuationImpl.payloadLocation(f).readInt(8 + frameIndex * 8 + 4);
    }

    @Uninterruptible(reason="read/write StoredContinuation")
    private static Pointer payloadLocation(StoredContinuation f) {
        return Word.objectToUntrackedPointer((Object)f).add(16);
    }

    @Uninterruptible(reason="read/write StoredContinuation")
    public static Pointer payloadFrameStart(StoredContinuation f) {
        return StoredContinuationImpl.payloadLocation(f).add(StoredContinuationImpl.readFrameMetaSize(f));
    }

    public static byte[] allocateBuf(StoredContinuation f) {
        return new byte[TypeConversion.asU4((long)StoredContinuationImpl.readAllFrameSize(f))];
    }

    @Uninterruptible(reason="access stack")
    public static void writeBuf(StoredContinuation f, byte[] buf) {
        Pointer frameStart = StoredContinuationImpl.payloadFrameStart(f);
        UnmanagedMemoryUtil.copy(frameStart, (Pointer)Word.objectToUntrackedPointer((Object)buf).add(StoredContinuationImpl.getByteArrayBaseOffset()), WordFactory.unsigned((int)buf.length));
    }

    public static int allocateFromCurrentStack(Target_java_lang_Continuation contRef, Pointer rootSp, Pointer leafSp, CodePointer leafIp) {
        return StoredContinuationImpl.allocateFromStack(contRef, rootSp, leafSp, leafIp, (IsolateThread)WordFactory.nullPointer());
    }

    public static int allocateFromForeignStack(Target_java_lang_Continuation contRef, Pointer rootSp, IsolateThread thread) {
        return StoredContinuationImpl.allocateFromStack(contRef, rootSp, (Pointer)WordFactory.nullPointer(), (CodePointer)WordFactory.nullPointer(), thread);
    }

    private static int allocateFromStack(Target_java_lang_Continuation contRef, Pointer rootSp, Pointer leafSP, CodePointer leafIp, IsolateThread otherThread) {
        boolean isCurrentThread = leafSP.isNonNull();
        YieldVisitor visitor = new YieldVisitor(rootSp, leafSP, leafIp);
        Pointer resultLeafSP = leafSP;
        if (isCurrentThread) {
            VMError.guarantee(otherThread.isNull());
            JavaStackWalker.walkCurrentThread(leafSP, visitor);
        } else {
            JavaStackWalker.walkThread(otherThread, visitor);
            resultLeafSP = visitor.leafSP;
        }
        if (visitor.preemptStatus != 0) {
            return visitor.preemptStatus;
        }
        if (!isCurrentThread) {
            JavaContinuations.setIP(contRef, visitor.leafIP);
        }
        VMError.guarantee(resultLeafSP.isNonNull());
        int frameCount = visitor.frameSizeReferenceMapIndex.size();
        long payloadSize = (long)(8 + 8 * frameCount) + rootSp.subtract((UnsignedWord)resultLeafSP).rawValue();
        contRef.internalContinuation = StoredContinuationImpl.allocateWriteFrameCount(payloadSize, frameCount);
        StoredContinuationImpl.writePayloadLong(contRef.internalContinuation, 0, visitor.referenceMapEncoding.rawValue());
        long allFrameSize = 0L;
        for (int i = 0; i < frameCount; ++i) {
            Pair<Integer, Integer> frameSizeRefMapInxPair = visitor.frameSizeReferenceMapIndex.get(i);
            StoredContinuationImpl.writePayloadInt(contRef.internalContinuation, 8 + i * 8 + 0, (Integer)frameSizeRefMapInxPair.getLeft());
            StoredContinuationImpl.writePayloadInt(contRef.internalContinuation, 8 + i * 8 + 4, (Integer)frameSizeRefMapInxPair.getRight());
            allFrameSize += (long)((Integer)frameSizeRefMapInxPair.getLeft()).intValue();
        }
        Pointer frameStart = StoredContinuationImpl.payloadFrameStart(contRef.internalContinuation);
        long frameSize = StoredContinuationImpl.readAllFrameSize(contRef.internalContinuation);
        VMError.guarantee(frameSize == allFrameSize);
        UnmanagedMemoryUtil.copy(resultLeafSP, frameStart, WordFactory.unsigned((long)frameSize));
        return 0;
    }

    @AlwaysInline(value="de-virtualize calls to ObjectReferenceVisitor")
    public static boolean walkStoredContinuationFromPointer(Pointer baseAddress, ObjectReferenceVisitor visitor, Object holderObject) {
        int frameIndex;
        StoredContinuation f = (StoredContinuation)holderObject;
        Pointer payloadStart = StoredContinuationImpl.payloadLocation(f);
        assert (payloadStart.subtract((UnsignedWord)baseAddress).equal(16)) : "base address not pointing to frame instance";
        int frameCount = StoredContinuationImpl.readFrameCount(f);
        long size = StoredContinuationImpl.readPayloadSize(f);
        Pointer curFrame = StoredContinuationImpl.payloadFrameStart(f);
        NonmovableArray<Byte> referenceMapEncoding = StoredContinuationImpl.readReferenceMapEncoding(f);
        for (frameIndex = 0; frameIndex < frameCount; ++frameIndex) {
            int frameSize = StoredContinuationImpl.readFrameSize(f, frameIndex);
            int referenceMapIndex = StoredContinuationImpl.readReferenceMapIndex(f, frameIndex);
            boolean r = CodeReferenceMapDecoder.walkOffsetsFromPointer((PointerBase)curFrame, referenceMapEncoding, referenceMapIndex, visitor);
            if (!r) {
                return false;
            }
            curFrame = curFrame.add(frameSize);
        }
        assert (frameIndex == frameCount);
        assert (curFrame.subtract((UnsignedWord)payloadStart).rawValue() == size);
        return true;
    }

    @Fold
    protected static int getByteArrayBaseOffset() {
        return ConfigurationValues.getObjectLayout().getArrayBaseOffset(JavaKind.Byte);
    }

    private static class YieldVisitor
    extends StackFrameVisitor {
        int preemptStatus = 0;
        Pointer rootSP;
        Pointer leafSP;
        CodePointer leafIP;
        List<Pair<Integer, Integer>> frameSizeReferenceMapIndex = new ArrayList<Pair<Integer, Integer>>();
        NonmovableArray<Byte> referenceMapEncoding = (NonmovableArray)WordFactory.nullPointer();
        private static boolean startFromNextFrame = false;

        YieldVisitor(Pointer rootSp, Pointer verifyLeafSp, CodePointer leafIp) {
            if (verifyLeafSp.isNonNull()) {
                VMError.guarantee(verifyLeafSp.belowThan((UnsignedWord)rootSp));
            }
            this.rootSP = rootSp;
            this.leafSP = verifyLeafSp;
            this.leafIP = leafIp;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected boolean visitFrame(Pointer sp, CodePointer ip, CodeInfo codeInfo, DeoptimizedFrame deoptimizedFrame) {
            block8: {
                FrameInfoQueryResult frameInfo = CodeInfoTable.lookupCodeInfoQueryResult(codeInfo, ip).getFrameInfo();
                if (frameInfo.getSourceClass().equals(StoredContinuationImpl.class) && frameInfo.getSourceMethodName().equals("allocateFromStack")) {
                    this.preemptStatus = -2;
                    return false;
                }
                if (this.leafSP.isNull()) {
                    if (startFromNextFrame) {
                        this.leafSP = sp;
                        this.leafIP = ip;
                        break block8;
                    } else {
                        if (frameInfo.getSourceClass().equals(Safepoint.class) && frameInfo.getSourceMethodName().equals("enterSlowPathSafepointCheck")) {
                            startFromNextFrame = true;
                        }
                        return true;
                    }
                }
                if (this.frameSizeReferenceMapIndex.isEmpty()) {
                    VMError.guarantee(this.leafSP.equal((UnsignedWord)sp));
                    VMError.guarantee(this.leafIP.equal((ComparableWord)ip));
                }
            }
            NonmovableArray<Byte> referenceMapEncoding = CodeInfoAccess.getStackReferenceMapEncoding(codeInfo);
            if (this.referenceMapEncoding.isNull()) {
                this.referenceMapEncoding = referenceMapEncoding;
            } else {
                VMError.guarantee(this.referenceMapEncoding.equal((ComparableWord)referenceMapEncoding));
            }
            long relIp = CodeInfoAccess.relativeIP(codeInfo, ip);
            int frameSize = TypeConversion.asU4((long)CodeInfoAccess.lookupTotalFrameSize(codeInfo, relIp));
            int referenceMapIndex = TypeConversion.asS4((long)CodeInfoAccess.lookupStackReferenceMapIndex(codeInfo, relIp));
            this.frameSizeReferenceMapIndex.add((Pair<Integer, Integer>)Pair.create((Object)frameSize, (Object)referenceMapIndex));
            Pointer currentFrameEnd = sp.add(frameSize);
            VMError.guarantee(currentFrameEnd.belowOrEqual((UnsignedWord)this.rootSP));
            return currentFrameEnd.notEqual((UnsignedWord)this.rootSP);
        }
    }
}

