/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.genscavenge.AbstractCollectionPolicy;
import com.oracle.svm.core.genscavenge.AdaptiveCollectionPolicy;
import com.oracle.svm.core.genscavenge.BasicCollectionPolicies;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.ProportionateSpacesPolicy;
import com.oracle.svm.core.heap.GCCause;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.UserError;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;

public interface CollectionPolicy {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static String getInitialPolicyName() {
        String legacyPrefix;
        if (SubstrateOptions.UseEpsilonGC.getValue().booleanValue()) {
            return "NeverCollect";
        }
        if (!SubstrateOptions.useRememberedSet()) {
            return "OnlyCompletely";
        }
        String name = Options.InitialCollectionPolicy.getValue();
        if (name.startsWith(legacyPrefix = "com.oracle.svm.core.genscavenge.CollectionPolicy$")) {
            return name.substring(legacyPrefix.length());
        }
        return name;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static CollectionPolicy getInitialPolicy() {
        String name;
        switch (name = CollectionPolicy.getInitialPolicyName()) {
            case "Adaptive": {
                return new AdaptiveCollectionPolicy();
            }
            case "Proportionate": {
                return new ProportionateSpacesPolicy();
            }
            case "BySpaceAndTime": {
                return new BasicCollectionPolicies.BySpaceAndTime();
            }
            case "OnlyCompletely": {
                return new BasicCollectionPolicies.OnlyCompletely();
            }
            case "OnlyIncrementally": {
                return new BasicCollectionPolicies.OnlyIncrementally();
            }
            case "NeverCollect": {
                return new BasicCollectionPolicies.NeverCollect();
            }
        }
        throw UserError.abort("Policy %s does not exist.", name);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static int getMaxSurvivorSpaces(Integer userValue) {
        String name = CollectionPolicy.getInitialPolicyName();
        if ("Adaptive".equals(name) || "Proportionate".equals(name)) {
            return AbstractCollectionPolicy.getMaxSurvivorSpaces(userValue);
        }
        return BasicCollectionPolicies.getMaxSurvivorSpaces(userValue);
    }

    public static boolean shouldCollectYoungGenSeparately(boolean defaultValue) {
        Boolean optionValue = HeapParameters.Options.CollectYoungGenerationSeparately.getValue();
        return optionValue != null ? optionValue : defaultValue;
    }

    public String getName();

    public void ensureSizeParametersInitialized();

    public void updateSizeParameters();

    public boolean shouldCollectOnAllocation();

    public boolean shouldCollectCompletely(boolean var1);

    public UnsignedWord getCurrentHeapCapacity();

    public UnsignedWord getMaximumHeapSize();

    public UnsignedWord getMaximumYoungGenerationSize();

    public UnsignedWord getMinimumHeapSize();

    public UnsignedWord getSurvivorSpacesCapacity();

    public UnsignedWord getMaximumFreeAlignedChunksSize();

    public int getTenuringAge();

    public void onCollectionBegin(boolean var1, long var2);

    public void onCollectionEnd(boolean var1, GCCause var2);

    public static final class Options {
        @Option(help={"The garbage collection policy, either Adaptive or BySpaceAndTime (default)."})
        public static final HostedOptionKey<String> InitialCollectionPolicy = new HostedOptionKey<String>("BySpaceAndTime");
    }
}

