/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.target;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.reflect.RuntimeReflectionConstructors;
import com.oracle.svm.reflect.target.Target_java_lang_reflect_Constructor;
import com.oracle.svm.reflect.target.Target_java_lang_reflect_Executable;
import com.oracle.svm.reflect.target.Target_java_lang_reflect_Method;
import com.oracle.svm.reflect.target.Target_java_lang_reflect_Parameter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class RuntimeReflectionConstructorsImpl
implements RuntimeReflectionConstructors {
    @Override
    public Method newMethod(Class<?> declaringClass, String name, Class<?>[] parameterTypes, Class<?> returnType, Class<?>[] checkedExceptions, int modifiers, String signature, byte[] annotations, byte[] parameterAnnotations, byte[] annotationDefault, byte[] typeAnnotations, String[] reflectParameterNames, int[] reflectParameterModifiers) {
        Target_java_lang_reflect_Method method = new Target_java_lang_reflect_Method();
        method.constructor(declaringClass, name, parameterTypes, returnType, checkedExceptions, modifiers, -1, signature, annotations, parameterAnnotations, annotationDefault);
        if (RuntimeReflectionConstructors.hasQueriedMethods()) {
            RuntimeReflectionConstructorsImpl.fillReflectParameters(SubstrateUtil.cast(method, Target_java_lang_reflect_Executable.class), reflectParameterNames, reflectParameterModifiers);
            SubstrateUtil.cast((Object)method, Target_java_lang_reflect_Executable.class).typeAnnotations = typeAnnotations;
        }
        return SubstrateUtil.cast(method, Method.class);
    }

    @Override
    public Constructor<?> newConstructor(Class<?> declaringClass, Class<?>[] parameterTypes, Class<?>[] checkedExceptions, int modifiers, String signature, byte[] annotations, byte[] parameterAnnotations, byte[] typeAnnotations, String[] reflectParameterNames, int[] reflectParameterModifiers) {
        Target_java_lang_reflect_Constructor cons = new Target_java_lang_reflect_Constructor();
        cons.constructor(declaringClass, parameterTypes, checkedExceptions, modifiers, -1, signature, annotations, parameterAnnotations);
        if (RuntimeReflectionConstructors.hasQueriedMethods()) {
            RuntimeReflectionConstructorsImpl.fillReflectParameters(SubstrateUtil.cast(cons, Target_java_lang_reflect_Executable.class), reflectParameterNames, reflectParameterModifiers);
            SubstrateUtil.cast((Object)cons, Target_java_lang_reflect_Executable.class).typeAnnotations = typeAnnotations;
        }
        return SubstrateUtil.cast(cons, Constructor.class);
    }

    private static void fillReflectParameters(Target_java_lang_reflect_Executable executable, String[] reflectParameterNames, int[] reflectParameterModifiers) {
        if (reflectParameterNames != null && reflectParameterModifiers != null) {
            executable.hasRealParameterData = true;
            assert (reflectParameterNames.length == reflectParameterModifiers.length);
            executable.parameters = new Target_java_lang_reflect_Parameter[reflectParameterNames.length];
            for (int i = 0; i < reflectParameterNames.length; ++i) {
                executable.parameters[i] = new Target_java_lang_reflect_Parameter();
                executable.parameters[i].constructor(reflectParameterNames[i], reflectParameterModifiers[i], executable, i);
            }
        } else {
            executable.hasRealParameterData = false;
        }
    }
}

