/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.util.VMError;
import java.security.ProtectionDomain;

public final class DynamicHubCompanion {
    private final DynamicHub hub;
    private String packageName;
    private Object classLoader = DynamicHub.NO_CLASS_LOADER;
    private ProtectionDomain protectionDomain;
    private DynamicHub.ReflectionData completeReflectionData;

    public DynamicHubCompanion(DynamicHub hub) {
        this.hub = hub;
    }

    public String getPackageName() {
        if (this.packageName == null) {
            this.packageName = this.hub.computePackageName();
        }
        return this.packageName;
    }

    boolean hasClassLoader() {
        return this.classLoader != DynamicHub.NO_CLASS_LOADER;
    }

    public ClassLoader getClassLoader() {
        Object loader = this.classLoader;
        VMError.guarantee(loader != DynamicHub.NO_CLASS_LOADER);
        return (ClassLoader)loader;
    }

    public void setClassLoader(ClassLoader loader) {
        VMError.guarantee(this.classLoader == DynamicHub.NO_CLASS_LOADER && loader != DynamicHub.NO_CLASS_LOADER);
        this.classLoader = loader;
    }

    public ProtectionDomain getProtectionDomain() {
        if (this.protectionDomain == null) {
            this.protectionDomain = DynamicHub.allPermDomainReference.get();
        }
        return this.protectionDomain;
    }

    public void setProtectionDomain(ProtectionDomain domain) {
        VMError.guarantee(this.protectionDomain == null && domain != null);
        this.protectionDomain = domain;
    }

    public DynamicHub.ReflectionData getCompleteReflectionData() {
        if (this.completeReflectionData == null) {
            this.completeReflectionData = this.hub.loadReflectionMetadata();
        }
        return this.completeReflectionData;
    }
}

