/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapOptions;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.Timer;
import com.oracle.svm.core.genscavenge.YoungGeneration;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.log.Log;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class GCAccounting {
    private long incrementalCollectionCount = 0L;
    private long incrementalCollectionTotalNanos = 0L;
    private long completeCollectionCount = 0L;
    private long completeCollectionTotalNanos = 0L;
    private UnsignedWord collectedTotalChunkBytes = (UnsignedWord)WordFactory.zero();
    private UnsignedWord allocatedChunkBytes = (UnsignedWord)WordFactory.zero();
    private UnsignedWord tenuredObjectBytes = (UnsignedWord)WordFactory.zero();
    private UnsignedWord survivorOverflowObjectBytes = (UnsignedWord)WordFactory.zero();
    private UnsignedWord youngChunkBytesBefore = (UnsignedWord)WordFactory.zero();
    private UnsignedWord youngChunkBytesAfter = (UnsignedWord)WordFactory.zero();
    private UnsignedWord oldChunkBytesBefore = (UnsignedWord)WordFactory.zero();
    private UnsignedWord oldChunkBytesAfter = (UnsignedWord)WordFactory.zero();
    private UnsignedWord collectedTotalObjectBytes = (UnsignedWord)WordFactory.zero();
    private UnsignedWord youngObjectBytesBefore = (UnsignedWord)WordFactory.zero();
    private UnsignedWord oldObjectBytesBefore = (UnsignedWord)WordFactory.zero();
    private UnsignedWord allocatedObjectBytes = (UnsignedWord)WordFactory.zero();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    GCAccounting() {
    }

    public long getIncrementalCollectionCount() {
        return this.incrementalCollectionCount;
    }

    public long getIncrementalCollectionTotalNanos() {
        return this.incrementalCollectionTotalNanos;
    }

    UnsignedWord getAllocatedChunkBytes() {
        return this.allocatedChunkBytes;
    }

    public long getCompleteCollectionCount() {
        return this.completeCollectionCount;
    }

    public long getCompleteCollectionTotalNanos() {
        return this.completeCollectionTotalNanos;
    }

    UnsignedWord getCollectedTotalChunkBytes() {
        return this.collectedTotalChunkBytes;
    }

    UnsignedWord getCollectedTotalObjectBytes() {
        return this.collectedTotalObjectBytes;
    }

    UnsignedWord getAllocatedObjectBytes() {
        return this.allocatedObjectBytes;
    }

    public UnsignedWord getOldGenerationAfterChunkBytes() {
        return this.oldChunkBytesAfter;
    }

    UnsignedWord getYoungChunkBytesBefore() {
        return this.youngChunkBytesBefore;
    }

    UnsignedWord getYoungChunkBytesAfter() {
        return this.youngChunkBytesAfter;
    }

    UnsignedWord getTenuredObjectBytes() {
        return this.tenuredObjectBytes;
    }

    UnsignedWord getSurvivorOverflowObjectBytes() {
        return this.survivorOverflowObjectBytes;
    }

    void beforeCollection() {
        Log trace = Log.noopLog().string("[GCImpl.Accounting.beforeCollection:").newline();
        HeapImpl heap = HeapImpl.getHeapImpl();
        YoungGeneration youngGen = heap.getYoungGeneration();
        this.youngChunkBytesBefore = youngGen.getChunkBytes();
        Space oldSpace = heap.getOldGeneration().getFromSpace();
        this.oldChunkBytesBefore = oldSpace.getChunkBytes();
        this.allocatedChunkBytes = this.allocatedChunkBytes.add(youngGen.getEden().getChunkBytes());
        if (HeapOptions.PrintGCSummary.getValue().booleanValue()) {
            UnsignedWord edenObjectBytesBefore = youngGen.getEden().computeObjectBytes();
            this.youngObjectBytesBefore = edenObjectBytesBefore.add(youngGen.computeSurvivorObjectBytes());
            this.oldObjectBytesBefore = oldSpace.computeObjectBytes();
            this.allocatedObjectBytes = this.allocatedObjectBytes.add(edenObjectBytesBefore);
        }
        this.tenuredObjectBytes = (UnsignedWord)WordFactory.zero();
        this.survivorOverflowObjectBytes = (UnsignedWord)WordFactory.zero();
        trace.string("  youngChunkBytesBefore: ").unsigned((WordBase)this.youngChunkBytesBefore).string("  oldChunkBytesBefore: ").unsigned((WordBase)this.oldChunkBytesBefore);
        trace.string("]").newline();
    }

    @AlwaysInline(value="GC performance")
    void onObjectTenured(Object result, boolean survivorOverflow) {
        UnsignedWord size = LayoutEncoding.getSizeFromObject(result);
        this.tenuredObjectBytes = this.tenuredObjectBytes.add(size);
        if (survivorOverflow) {
            this.survivorOverflowObjectBytes = this.survivorOverflowObjectBytes.add(size);
        }
    }

    void afterCollection(boolean completeCollection, Timer collectionTimer) {
        if (completeCollection) {
            this.afterCompleteCollection(collectionTimer);
        } else {
            this.afterIncrementalCollection(collectionTimer);
        }
    }

    private void afterIncrementalCollection(Timer collectionTimer) {
        Log trace = Log.noopLog().string("[GCImpl.Accounting.afterIncrementalCollection:");
        ++this.incrementalCollectionCount;
        this.afterCollectionCommon();
        this.incrementalCollectionTotalNanos += collectionTimer.getMeasuredNanos();
        trace.string("  incrementalCollectionCount: ").signed(this.incrementalCollectionCount).string("  oldChunkBytesAfter: ").unsigned((WordBase)this.oldChunkBytesAfter).string("  oldChunkBytesBefore: ").unsigned((WordBase)this.oldChunkBytesBefore);
        trace.string("]").newline();
    }

    private void afterCompleteCollection(Timer collectionTimer) {
        Log trace = Log.noopLog().string("[GCImpl.Accounting.afterCompleteCollection:");
        ++this.completeCollectionCount;
        this.afterCollectionCommon();
        this.completeCollectionTotalNanos += collectionTimer.getMeasuredNanos();
        trace.string("  completeCollectionCount: ").signed(this.completeCollectionCount).string("  oldChunkBytesAfter: ").unsigned((WordBase)this.oldChunkBytesAfter);
        trace.string("]").newline();
    }

    private void afterCollectionCommon() {
        HeapImpl heap = HeapImpl.getHeapImpl();
        YoungGeneration youngGen = heap.getYoungGeneration();
        this.youngChunkBytesAfter = youngGen.getChunkBytes();
        Space oldSpace = heap.getOldGeneration().getFromSpace();
        this.oldChunkBytesAfter = oldSpace.getChunkBytes();
        UnsignedWord beforeChunkBytes = this.youngChunkBytesBefore.add(this.oldChunkBytesBefore);
        UnsignedWord afterChunkBytes = this.oldChunkBytesAfter.add(this.youngChunkBytesAfter);
        UnsignedWord collectedChunkBytes = beforeChunkBytes.subtract(afterChunkBytes);
        this.collectedTotalChunkBytes = this.collectedTotalChunkBytes.add(collectedChunkBytes);
        if (HeapOptions.PrintGCSummary.getValue().booleanValue()) {
            UnsignedWord youngObjectBytesAfter = youngGen.computeObjectBytes();
            UnsignedWord oldObjectBytesAfter = oldSpace.computeObjectBytes();
            UnsignedWord beforeObjectBytes = this.youngObjectBytesBefore.add(this.oldObjectBytesBefore);
            UnsignedWord collectedObjectBytes = beforeObjectBytes.subtract(oldObjectBytesAfter).subtract(youngObjectBytesAfter);
            this.collectedTotalObjectBytes = this.collectedTotalObjectBytes.add(collectedObjectBytes);
        }
    }
}

