/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.util.json.JSONParser;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeSerializationSupport;

public class SerializationConfigurationParser
extends ConfigurationParser {
    public static final String NAME_KEY = "name";
    public static final String CUSTOM_TARGET_CONSTRUCTOR_CLASS_KEY = "customTargetConstructorClass";
    private final RuntimeSerializationSupport serializationSupport;

    public SerializationConfigurationParser(RuntimeSerializationSupport serializationSupport, boolean strictConfiguration) {
        super(strictConfiguration);
        this.serializationSupport = serializationSupport;
    }

    @Override
    public void parseAndRegister(Reader reader) throws IOException {
        JSONParser parser = new JSONParser(reader);
        Object json = parser.parse();
        for (Object serializationKey : SerializationConfigurationParser.asList(json, "first level of document must be an array of serialization lists")) {
            this.parseSerializationDescriptorObject(SerializationConfigurationParser.asMap(serializationKey, "second level of document must be serialization descriptor objects"));
        }
    }

    private void parseSerializationDescriptorObject(Map<String, Object> data) {
        this.checkAttributes(data, "serialization descriptor object", Collections.singleton(NAME_KEY), Arrays.asList(CUSTOM_TARGET_CONSTRUCTOR_CLASS_KEY, "condition"));
        ConfigurationCondition unresolvedCondition = this.parseCondition(data);
        String targetSerializationClass = SerializationConfigurationParser.asString(data.get(NAME_KEY));
        Object optionalCustomCtorValue = data.get(CUSTOM_TARGET_CONSTRUCTOR_CLASS_KEY);
        String customTargetConstructorClass = optionalCustomCtorValue != null ? SerializationConfigurationParser.asString(optionalCustomCtorValue) : null;
        this.serializationSupport.registerWithTargetConstructorClass(unresolvedCondition, targetSerializationClass, customTargetConstructorClass);
    }
}

