/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.configure.PredefinedClassesRegistry;
import com.oracle.svm.core.util.json.JSONParser;
import com.oracle.svm.core.util.json.JSONParserException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.graalvm.compiler.core.common.SuppressFBWarnings;

public class PredefinedClassesConfigurationParser
extends ConfigurationParser {
    private final PredefinedClassesRegistry registry;

    public PredefinedClassesConfigurationParser(PredefinedClassesRegistry registry, boolean strictConfiguration) {
        super(strictConfiguration);
        this.registry = registry;
    }

    @Override
    public void parseAndRegister(Reader reader) throws IOException {
        this.parseAndRegister(reader, null);
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="getParent() returning null for a valid file path is almost impossible and a NullPointerException would be acceptable")
    public void parseAndRegister(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            Path basePath = path.getParent().resolve("agent-extracted-predefined-classes");
            this.parseAndRegister(reader, basePath);
        }
    }

    private void parseAndRegister(Reader reader, Path basePath) throws IOException {
        JSONParser parser = new JSONParser(reader);
        Object json = parser.parse();
        for (Object origin : PredefinedClassesConfigurationParser.asList(json, "first level of document must be an array of predefined class origin objects")) {
            this.parseOrigin(basePath, PredefinedClassesConfigurationParser.asMap(origin, "second level of document must be a predefined class origin object"));
        }
    }

    private void parseOrigin(Path basePath, Map<String, Object> data) {
        this.checkAttributes(data, "class origin descriptor object", Arrays.asList("type", "classes"));
        String type = PredefinedClassesConfigurationParser.asString(data.get("type"), "type");
        if (!type.equals("agent-extracted")) {
            throw new JSONParserException("Attribute 'type' must have value 'agent-extracted'");
        }
        for (Object clazz : PredefinedClassesConfigurationParser.asList(data.get("classes"), "Attribute 'classes' must be an array of predefined class descriptor objects")) {
            this.parseClass(basePath, PredefinedClassesConfigurationParser.asMap(clazz, "second level of document must be a predefined class descriptor object"));
        }
    }

    private void parseClass(Path basePath, Map<String, Object> data) {
        this.checkAttributes(data, "class descriptor object", Collections.singleton("hash"), Collections.singleton("nameInfo"));
        String hash = PredefinedClassesConfigurationParser.asString(data.get("hash"), "hash");
        String nameInfo = PredefinedClassesConfigurationParser.asNullableString(data.get("nameInfo"), "nameInfo");
        this.registry.add(nameInfo, hash, basePath);
    }
}

