/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.hosted;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.reflect.hosted.ReflectionSubstitutionType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.util.GuardedAnnotationAccess;
import sun.reflect.generics.repository.AbstractRepository;
import sun.reflect.generics.repository.ClassRepository;
import sun.reflect.generics.repository.ConstructorRepository;
import sun.reflect.generics.repository.FieldRepository;
import sun.reflect.generics.repository.GenericDeclRepository;
import sun.reflect.generics.repository.MethodRepository;

public class ReflectionObjectReplacer
implements Function<Object, Object> {
    private final AnalysisMetaAccess metaAccess;
    private final Set<Identity> scanned = ConcurrentHashMap.newKeySet();

    public ReflectionObjectReplacer(AnalysisMetaAccess metaAccess) {
        this.metaAccess = metaAccess;
    }

    @Override
    public Object apply(Object original) {
        if ((original instanceof AccessibleObject || original instanceof Parameter || original instanceof AbstractRepository) && this.scanned.add(new Identity(original))) {
            this.scan(original);
        }
        return original;
    }

    private void scan(Object original) {
        GenericDeclRepository methodRepository;
        AnalysisType declaring;
        if (original instanceof Field && !GuardedAnnotationAccess.isAnnotationPresent((AnnotatedElement)(declaring = this.metaAccess.lookupJavaType(((Field)original).getDeclaringClass())), Delete.class)) {
            declaring.registerAsReachable();
            AnalysisField analysisField = this.metaAccess.lookupJavaField((Field)original);
            if (!GuardedAnnotationAccess.isAnnotationPresent((AnnotatedElement)analysisField, Delete.class)) {
                ((ReflectionSubstitutionType.Factory)ImageSingletons.lookup(ReflectionSubstitutionType.Factory.class)).inspectAccessibleField((Field)original);
                if (!analysisField.isUnsafeAccessed()) {
                    analysisField.registerAsAccessed();
                    analysisField.registerAsUnsafeAccessed((AnalysisUniverse)this.metaAccess.getUniverse());
                }
            }
        }
        if (original instanceof Method) {
            Method method = (Method)original;
            method.getGenericReturnType();
        }
        if (original instanceof Executable) {
            Executable executable = (Executable)original;
            executable.getGenericParameterTypes();
            executable.getGenericExceptionTypes();
            executable.getParameters();
            executable.getTypeParameters();
        }
        if (original instanceof Field) {
            Field field = (Field)original;
            field.getGenericType();
        }
        if (original instanceof AccessibleObject) {
            AccessibleObject accessibleObject = (AccessibleObject)original;
            GuardedAnnotationAccess.getDeclaredAnnotations((AnnotatedElement)accessibleObject);
        }
        if (original instanceof Parameter) {
            Parameter parameter = (Parameter)original;
            parameter.getType();
        }
        if (original instanceof FieldRepository) {
            FieldRepository fieldRepository = (FieldRepository)original;
            fieldRepository.getGenericType();
        }
        if (original instanceof MethodRepository) {
            methodRepository = (MethodRepository)original;
            ((MethodRepository)methodRepository).getReturnType();
        }
        if (original instanceof ConstructorRepository) {
            ConstructorRepository constructorRepository = (ConstructorRepository)original;
            constructorRepository.getExceptionTypes();
            constructorRepository.getParameterTypes();
        }
        if (original instanceof GenericDeclRepository) {
            methodRepository = (GenericDeclRepository)original;
            methodRepository.getTypeParameters();
        }
        if (original instanceof ClassRepository) {
            ClassRepository classRepository = (ClassRepository)original;
            classRepository.getSuperclass();
            classRepository.getSuperInterfaces();
        }
    }

    static class Identity {
        private final Object wrapped;

        Identity(Object wrapped) {
            this.wrapped = wrapped;
        }

        public int hashCode() {
            return System.identityHashCode(this.wrapped);
        }

        public boolean equals(Object obj) {
            return ((Identity)obj).wrapped == this.wrapped;
        }
    }
}

