/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoEncoder;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoDecoder;
import com.oracle.svm.core.code.FrameInfoEncoder;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.ImageCodeInfo;
import com.oracle.svm.core.code.InstantReferenceAdjuster;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.DeoptEntryInfopoint;
import com.oracle.svm.core.graal.code.SubstrateDataBuilder;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.Counter;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.code.CompilationInfo;
import com.oracle.svm.hosted.code.CompilationInfoSupport;
import com.oracle.svm.hosted.code.HostedImageHeapConstantPatch;
import com.oracle.svm.hosted.image.NativeImage;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.image.NativeImageHeapWriter;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.DataPatch;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.code.DataSection;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public abstract class NativeImageCodeCache {
    protected final NativeImageHeap imageHeap;
    protected final Map<HostedMethod, CompilationResult> compilations;
    protected final NavigableMap<Integer, CompilationResult> compilationsByStart = new TreeMap<Integer, CompilationResult>();
    protected final Platform targetPlatform;
    private final DataSection dataSection;
    private final Map<Constant, String> constantReasons = new HashMap<Constant, String>();

    public NativeImageCodeCache(Map<HostedMethod, CompilationResult> compilations, NativeImageHeap imageHeap) {
        this(compilations, imageHeap, (Platform)ImageSingletons.lookup(Platform.class));
    }

    public NativeImageCodeCache(Map<HostedMethod, CompilationResult> compilations, NativeImageHeap imageHeap, Platform targetPlatform) {
        this.compilations = compilations;
        this.imageHeap = imageHeap;
        this.dataSection = new DataSection();
        this.targetPlatform = targetPlatform;
    }

    public abstract int getCodeCacheSize();

    public CompilationResult getCompilationAtOffset(int offset) {
        Map.Entry<Integer, CompilationResult> floor = this.compilationsByStart.floorEntry(offset);
        if (floor != null) {
            return floor.getValue();
        }
        return null;
    }

    public CompilationResult getFirstCompilation() {
        Map.Entry<Integer, CompilationResult> floor = this.compilationsByStart.ceilingEntry(0);
        if (floor != null) {
            return floor.getValue();
        }
        return null;
    }

    public abstract void layoutMethods(DebugContext var1, String var2, BigBang var3, ForkJoinPool var4);

    public void layoutConstants() {
        for (CompilationResult compilation : this.compilations.values()) {
            SubstrateObjectConstant constant;
            for (DataSection.Data data : compilation.getDataSection()) {
                if (!(data instanceof SubstrateDataBuilder.ObjectData)) continue;
                constant = ((SubstrateDataBuilder.ObjectData)data).getConstant();
                this.constantReasons.put(constant, compilation.getName());
            }
            this.dataSection.addAll(compilation.getDataSection());
            for (DataPatch patch : compilation.getDataPatches()) {
                if (!(patch.reference instanceof ConstantReference)) continue;
                constant = ((ConstantReference)patch.reference).getConstant();
                this.constantReasons.put(constant, compilation.getName());
            }
        }
        this.dataSection.close();
    }

    public void addConstantsToHeap() {
        for (DataSection.Data data : this.dataSection) {
            if (!(data instanceof SubstrateDataBuilder.ObjectData)) continue;
            SubstrateObjectConstant constant = ((SubstrateDataBuilder.ObjectData)data).getConstant();
            this.addConstantToHeap(constant);
        }
        for (CompilationResult compilationResult : this.compilations.values()) {
            for (DataPatch patch : compilationResult.getDataPatches()) {
                if (!(patch.reference instanceof ConstantReference)) continue;
                this.addConstantToHeap((Constant)((ConstantReference)patch.reference).getConstant(), compilationResult.getName());
            }
            for (CompilationResult.CodeAnnotation codeAnnotation : compilationResult.getCodeAnnotations()) {
                if (!(codeAnnotation instanceof HostedImageHeapConstantPatch)) continue;
                this.addConstantToHeap(((HostedImageHeapConstantPatch)codeAnnotation).constant, compilationResult.getName());
            }
        }
    }

    private void addConstantToHeap(Constant constant) {
        this.addConstantToHeap(constant, null);
    }

    private void addConstantToHeap(Constant constant, Object reason) {
        Object obj = SubstrateObjectConstant.asObject(constant);
        if (!this.imageHeap.getMetaAccess().lookupJavaType((Class)obj.getClass()).getWrapped().isInstantiated()) {
            throw VMError.shouldNotReachHere("Non-instantiated type referenced by a compiled method: " + obj.getClass().getName() + "." + (reason != null ? " Method: " + reason : ""));
        }
        this.imageHeap.addObject(obj, false, this.constantReasons.get(constant));
    }

    protected int getConstantsSize() {
        return this.dataSection.getSectionSize();
    }

    public int getAlignedConstantsSize() {
        return ConfigurationValues.getObjectLayout().alignUp(this.getConstantsSize());
    }

    public void buildRuntimeMetadata(CFunctionPointer firstMethod, UnsignedWord codeSize) {
        FrameInfoCustomization frameInfoCustomization = new FrameInfoCustomization();
        CodeInfoEncoder codeInfoEncoder = new CodeInfoEncoder(frameInfoCustomization);
        for (Map.Entry<HostedMethod, CompilationResult> entry : this.compilations.entrySet()) {
            HostedMethod method = entry.getKey();
            CompilationResult compilation = entry.getValue();
            codeInfoEncoder.addMethod(method, compilation, method.getCodeAddressOffset());
        }
        if (NativeImageOptions.PrintMethodHistogram.getValue().booleanValue()) {
            System.out.println("encoded deopt entry points                 ; " + frameInfoCustomization.numDeoptEntryPoints);
            System.out.println("encoded during call entry points           ; " + frameInfoCustomization.numDuringCallEntryPoints);
        }
        ImageCodeInfo.HostedImageCodeInfo imageCodeInfo = CodeInfoTable.getImageCodeCache().getHostedImageCodeInfo();
        codeInfoEncoder.encodeAllAndInstall(imageCodeInfo, new InstantReferenceAdjuster());
        imageCodeInfo.setCodeStart((CodePointer)firstMethod);
        imageCodeInfo.setCodeSize(codeSize);
        imageCodeInfo.setDataOffset(codeSize);
        imageCodeInfo.setDataSize((UnsignedWord)WordFactory.zero());
        imageCodeInfo.setCodeAndDataMemorySize(codeSize);
        if (CodeInfoEncoder.Options.CodeInfoEncoderCounters.getValue().booleanValue()) {
            for (Counter counter : ((CodeInfoEncoder.Counters)ImageSingletons.lookup(CodeInfoEncoder.Counters.class)).group.getCounters()) {
                System.out.println(counter.getName() + " ; " + counter.getValue());
            }
        }
        if (Options.VerifyDeoptimizationEntryPoints.getValue().booleanValue()) {
            this.verifyDeoptEntries(imageCodeInfo);
        }
        assert (this.verifyMethods(codeInfoEncoder, imageCodeInfo));
    }

    private void verifyDeoptEntries(CodeInfo codeInfo) {
        boolean hasError = false;
        ArrayList<Map.Entry<AnalysisMethod, Map<Long, CompilationInfoSupport.DeoptSourceFrameInfo>>> deoptEntries = new ArrayList<Map.Entry<AnalysisMethod, Map<Long, CompilationInfoSupport.DeoptSourceFrameInfo>>>(CompilationInfoSupport.singleton().getDeoptEntries().entrySet());
        deoptEntries.sort((e1, e2) -> ((AnalysisMethod)e1.getKey()).format("%H.%n(%p)").compareTo(((AnalysisMethod)e2.getKey()).format("%H.%n(%p)")));
        for (Map.Entry entry : deoptEntries) {
            HostedMethod method = this.imageHeap.getUniverse().lookup((JavaMethod)entry.getKey());
            ArrayList sourceFrameInfos = new ArrayList(((Map)entry.getValue()).entrySet());
            sourceFrameInfos.sort(Comparator.comparingLong(Map.Entry::getKey));
            for (Map.Entry entry2 : sourceFrameInfos) {
                hasError |= NativeImageCodeCache.verifyDeoptEntry(codeInfo, method, entry2);
            }
        }
        if (hasError) {
            VMError.shouldNotReachHere("Verification of deoptimization entry points failed");
        }
    }

    private static boolean verifyDeoptEntry(CodeInfo codeInfo, HostedMethod method, Map.Entry<Long, CompilationInfoSupport.DeoptSourceFrameInfo> sourceFrameInfo) {
        int deoptOffsetInImage = method.getDeoptOffsetInImage();
        long encodedBci = sourceFrameInfo.getKey();
        if (deoptOffsetInImage <= 0) {
            return NativeImageCodeCache.error(method, encodedBci, "entry point method not compiled");
        }
        CodeInfoQueryResult result = new CodeInfoQueryResult();
        long relativeIP = CodeInfoAccess.lookupDeoptimizationEntrypoint(codeInfo, deoptOffsetInImage, encodedBci, result);
        if (relativeIP < 0L) {
            return NativeImageCodeCache.error(method, encodedBci, "entry point not found");
        }
        FrameInfoQueryResult targetFrame = result.getFrameInfo();
        if (targetFrame == null || !targetFrame.isDeoptEntry() || targetFrame.getEncodedBci() != encodedBci) {
            return NativeImageCodeCache.error(method, encodedBci, "entry point found, but wrong property");
        }
        if (!targetFrame.duringCall()) {
            boolean hasExceptionHandler;
            boolean bl = hasExceptionHandler = result.getExceptionOffset() != 0L;
            if (!targetFrame.rethrowException() && !hasExceptionHandler) {
                return NativeImageCodeCache.error(method, encodedBci, "no exception handler registered for deopt entry");
            }
            if (targetFrame.rethrowException() && hasExceptionHandler) {
                return NativeImageCodeCache.error(method, encodedBci, "exception handler registered for rethrowException");
            }
        }
        CompilationInfoSupport.DeoptSourceFrameInfo sourceFrame = sourceFrameInfo.getValue();
        FrameInfoQueryResult.ValueInfo[] targetValues = targetFrame.getValueInfos();
        List<JavaKind> sourceKinds = sourceFrame.expectedKinds;
        if (targetFrame.getNumLocals() != sourceFrame.numLocals || targetFrame.getNumStack() != sourceFrame.numStack || targetFrame.getNumLocks() != sourceFrame.numLocks) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("Mismatch between number of expected values in target and source.\n");
            errorMessage.append(String.format("Target: locals-%d, stack-%d, locks-%d.\n", targetFrame.getNumLocals(), targetFrame.getNumStack(), targetFrame.getNumLocks()));
            NativeImageCodeCache.appendFrameInfo(errorMessage, true, Arrays.stream(targetValues).map(FrameInfoQueryResult.ValueInfo::getKind).collect(Collectors.toList()));
            errorMessage.append(String.format("Source: locals-%d, stack-%d, locks-%d.\n", sourceFrame.numLocals, sourceFrame.numStack, sourceFrame.numLocks));
            NativeImageCodeCache.appendFrameInfo(errorMessage, false, sourceKinds);
            return NativeImageCodeCache.error(method, encodedBci, errorMessage.toString());
        }
        boolean validTarget = true;
        for (int i = 0; i < targetValues.length; ++i) {
            JavaKind targetKind = targetValues[i].getKind();
            if (targetKind == JavaKind.Illegal || targetKind == sourceKinds.get(i)) continue;
            validTarget = false;
            break;
        }
        if (!validTarget) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("Deoptimization source frame is not a superset of the target frame.\n");
            NativeImageCodeCache.appendFrameInfo(errorMessage, true, Arrays.stream(targetValues).map(FrameInfoQueryResult.ValueInfo::getKind).collect(Collectors.toList()));
            NativeImageCodeCache.appendFrameInfo(errorMessage, false, sourceKinds);
            return NativeImageCodeCache.error(method, encodedBci, errorMessage.toString());
        }
        return false;
    }

    private static void appendFrameInfo(StringBuilder builder, boolean isTarget, List<JavaKind> javaKinds) {
        builder.append(String.format("***%s Frame***\n", isTarget ? "Target" : "Source"));
        for (int i = 0; i < javaKinds.size(); ++i) {
            builder.append(String.format("index %d: %s\n", i, javaKinds.get(i)));
        }
    }

    private static boolean error(HostedMethod method, long encodedBci, String msg) {
        System.out.println(method.format("%H.%n(%p)") + ", encodedBci " + encodedBci + " (bci " + FrameInfoDecoder.readableBci(encodedBci) + "): " + msg);
        return true;
    }

    private boolean verifyMethods(CodeInfoEncoder codeInfoEncoder, CodeInfo codeInfo) {
        for (Map.Entry<HostedMethod, CompilationResult> entry : this.compilations.entrySet()) {
            CodeInfoEncoder.verifyMethod(entry.getKey(), entry.getValue(), entry.getKey().getCodeAddressOffset(), codeInfo);
        }
        codeInfoEncoder.verifyFrameInfo(codeInfo);
        return true;
    }

    public abstract void patchMethods(DebugContext var1, RelocatableBuffer var2, ObjectFile var3);

    public abstract void writeCode(RelocatableBuffer var1);

    public void writeConstants(NativeImageHeapWriter writer, RelocatableBuffer buffer) {
        ByteBuffer bb = buffer.getByteBuffer();
        this.dataSection.buildDataSection(bb, (position, constant) -> writer.writeReference(buffer, position, SubstrateObjectConstant.asObject((Constant)constant), "VMConstant: " + constant));
    }

    public abstract NativeImage.NativeTextSectionImpl getTextSectionImpl(RelocatableBuffer var1, ObjectFile var2, NativeImageCodeCache var3);

    public Path[] getCCInputFiles(Path tempDirectory, String imageName) {
        return new Path[]{tempDirectory.resolve(imageName + ObjectFile.getFilenameSuffix())};
    }

    public abstract List<ObjectFile.Symbol> getSymbols(ObjectFile var1, boolean var2);

    public Map<HostedMethod, CompilationResult> getCompilations() {
        return this.compilations;
    }

    public void printCompilationResults() {
        System.out.println("--- compiled methods");
        for (Map.Entry<HostedMethod, CompilationResult> entry : this.compilations.entrySet()) {
            HostedMethod method = entry.getKey();
            CompilationResult result = entry.getValue();
            System.out.format("%8d %5d %s: frame %d\n", method.getCodeAddressOffset(), result.getTargetCodeSize(), method.format("%H.%n(%p)"), result.getTotalFrameSize());
        }
        System.out.println("--- vtables:");
        for (HostedType type : this.imageHeap.getUniverse().getTypes()) {
            for (int i = 0; i < type.getVTable().length; ++i) {
                CompilationResult comp;
                HostedMethod method = type.getVTable()[i];
                if (method == null || (comp = this.compilations.get(type.getVTable()[i])) == null) continue;
                System.out.format("%d %s @ %d: %s = 0x%x\n", type.getTypeID(), type.toJavaName(false), i, method.format("%r %n(%p)"), method.getCodeAddressOffset());
            }
        }
    }

    private static class FrameInfoCustomization
    extends FrameInfoEncoder.NamesFromMethod {
        int numDeoptEntryPoints;
        int numDuringCallEntryPoints;

        private FrameInfoCustomization() {
        }

        @Override
        protected Class<?> getDeclaringJavaClass(ResolvedJavaMethod method) {
            HostedType type = (HostedType)method.getDeclaringClass();
            assert (type.getWrapped().isReachable()) : "Declaring class not marked as used, therefore the DynamicHub is not initialized properly: " + method.format("%H.%n(%p)");
            return type.getJavaClass();
        }

        @Override
        protected boolean shouldStoreMethod() {
            return false;
        }

        @Override
        protected boolean shouldInclude(ResolvedJavaMethod method, Infopoint infopoint) {
            CompilationInfo compilationInfo = ((HostedMethod)method).compilationInfo;
            BytecodeFrame topFrame = infopoint.debugInfo.frame();
            if (this.isDeoptEntry(method, infopoint)) {
                if (infopoint instanceof DeoptEntryInfopoint) {
                    ++this.numDeoptEntryPoints;
                } else if (infopoint instanceof Call) {
                    ++this.numDuringCallEntryPoints;
                } else {
                    throw VMError.shouldNotReachHere();
                }
                return true;
            }
            BytecodeFrame rootFrame = topFrame;
            while (rootFrame.caller() != null) {
                rootFrame = rootFrame.caller();
            }
            assert (rootFrame.getMethod().equals(method));
            boolean isDeoptEntry = compilationInfo.isDeoptEntry(rootFrame.getBCI(), rootFrame.duringCall, rootFrame.rethrowException);
            if (infopoint instanceof DeoptEntryInfopoint) {
                assert (isDeoptEntry);
                assert (topFrame == rootFrame) : "Deoptimization target has inlined frame: " + topFrame;
                ++this.numDeoptEntryPoints;
                return true;
            }
            if (isDeoptEntry && topFrame.duringCall) {
                assert (infopoint instanceof Call);
                assert (topFrame == rootFrame) : "Deoptimization target has inlined frame: " + topFrame;
                ++this.numDuringCallEntryPoints;
                return true;
            }
            for (BytecodeFrame frame = topFrame; frame != null; frame = frame.caller()) {
                if (!CompilationInfoSupport.singleton().isFrameInformationRequired(frame.getMethod())) continue;
                return true;
            }
            return compilationInfo.canDeoptForTesting();
        }

        @Override
        protected boolean isDeoptEntry(ResolvedJavaMethod method, Infopoint infopoint) {
            BytecodeFrame topFrame;
            CompilationInfo compilationInfo = ((HostedMethod)method).compilationInfo;
            BytecodeFrame rootFrame = topFrame = infopoint.debugInfo.frame();
            while (rootFrame.caller() != null) {
                rootFrame = rootFrame.caller();
            }
            assert (rootFrame.getMethod().equals(method));
            boolean isDeoptEntry = compilationInfo.isDeoptEntry(rootFrame.getBCI(), rootFrame.duringCall, rootFrame.rethrowException);
            if (infopoint instanceof DeoptEntryInfopoint) {
                assert (isDeoptEntry);
                assert (topFrame == rootFrame) : "Deoptimization target has inlined frame: " + topFrame;
                return true;
            }
            if (isDeoptEntry && topFrame.duringCall) {
                assert (infopoint instanceof Call);
                assert (topFrame == rootFrame) : "Deoptimization target has inlined frame: " + topFrame;
                return true;
            }
            return false;
        }
    }

    public static class Options {
        @Option(help={"Verify that all possible deoptimization entry points have been properly compiled and registered in the metadata"})
        public static final HostedOptionKey<Boolean> VerifyDeoptimizationEntryPoints = new HostedOptionKey<Boolean>(false);
    }
}

