/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.SubstrateSegfaultHandler;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.os.MemoryProtectionKeyProvider;
import com.oracle.svm.core.posix.headers.LibC;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.WordFactory;

class PosixSubstrateSegfaultHandler
extends SubstrateSegfaultHandler {
    private static final CEntryPointLiteral<Signal.AdvancedSignalDispatcher> advancedSignalDispatcher = CEntryPointLiteral.create(PosixSubstrateSegfaultHandler.class, (String)"dispatch", (Class[])new Class[]{Integer.TYPE, Signal.siginfo_t.class, Signal.ucontext_t.class});

    PosixSubstrateSegfaultHandler() {
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, publishAs=CEntryPointOptions.Publish.NotPublished, include=CEntryPointOptions.NotIncludedAutomatically.class)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in segfault signal handler.")
    @Uninterruptible(reason="Must be uninterruptible until it gets immune to safepoints")
    private static void dispatch(int signalNumber, Signal.siginfo_t sigInfo, Signal.ucontext_t uContext) {
        if (MemoryProtectionKeyProvider.isAvailable()) {
            MemoryProtectionKeyProvider.singleton().handleSegfault(sigInfo);
        }
        if (PosixSubstrateSegfaultHandler.tryEnterIsolate(uContext)) {
            if (MemoryProtectionKeyProvider.isAvailable()) {
                MemoryProtectionKeyProvider.singleton().printSignalInfo(sigInfo);
            }
            PosixSubstrateSegfaultHandler.dump(uContext);
            throw VMError.shouldNotReachHere();
        }
    }

    @Override
    protected void install() {
        int structSigActionSize = SizeOf.get(Signal.sigaction.class);
        Signal.sigaction structSigAction = (Signal.sigaction)StackValue.get((int)structSigActionSize);
        LibC.memset(structSigAction, WordFactory.signed((int)0), WordFactory.unsigned((int)structSigActionSize));
        structSigAction.sa_flags(Signal.SA_SIGINFO());
        structSigAction.sa_sigaction((Signal.AdvancedSignalDispatcher)advancedSignalDispatcher.getFunctionPointer());
        Signal.sigaction(Signal.SignalEnum.SIGSEGV, structSigAction, (Signal.sigaction)WordFactory.nullPointer());
        Signal.sigaction(Signal.SignalEnum.SIGBUS, structSigAction, (Signal.sigaction)WordFactory.nullPointer());
    }
}

