/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.resources;

import com.oracle.svm.core.jdk.resources.NativeImageResourceFileAttributes;
import com.oracle.svm.core.jdk.resources.NativeImageResourceFileAttributesView;
import com.oracle.svm.core.jdk.resources.NativeImageResourceFileSystem;
import com.oracle.svm.core.jdk.resources.NativeImageResourcePath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class NativeImageResourceFileSystemProvider
extends FileSystemProvider {
    private final String resourcePath = "file:/resources";
    private NativeImageResourceFileSystem fileSystem;
    private final Lock writeLock;
    private final Lock readLock;

    private Path uriToPath(URI uri) {
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase(this.getScheme())) {
            throw new IllegalArgumentException("URI scheme is not '" + this.getScheme() + "'");
        }
        try {
            return Paths.get(new URI("file:/resources"));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public NativeImageResourceFileSystemProvider() {
        ReentrantReadWriteLock rwlock = new ReentrantReadWriteLock();
        this.writeLock = rwlock.writeLock();
        this.readLock = rwlock.readLock();
    }

    private static NativeImageResourcePath toResourcePath(Path path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (!(path instanceof NativeImageResourcePath)) {
            throw new ProviderMismatchException();
        }
        return (NativeImageResourcePath)path;
    }

    @Override
    public String getScheme() {
        return "resource";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) {
        try {
            this.writeLock.lock();
            Path path = this.uriToPath(uri);
            if (this.fileSystem != null) {
                throw new FileSystemAlreadyExistsException();
            }
            NativeImageResourceFileSystem nativeImageResourceFileSystem = this.fileSystem = new NativeImageResourceFileSystem(this, path, env);
            return nativeImageResourceFileSystem;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileSystem newFileSystem(Path path, Map<String, ?> env) {
        try {
            this.writeLock.lock();
            if (this.fileSystem != null) {
                throw new FileSystemAlreadyExistsException();
            }
            NativeImageResourceFileSystem nativeImageResourceFileSystem = this.fileSystem = new NativeImageResourceFileSystem(this, path, env);
            return nativeImageResourceFileSystem;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        try {
            this.readLock.lock();
            if (this.fileSystem == null) {
                throw new FileSystemNotFoundException();
            }
            NativeImageResourceFileSystem nativeImageResourceFileSystem = this.fileSystem;
            return nativeImageResourceFileSystem;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Path getPath(URI uri) {
        return this.getFileSystem(uri).getPath(uri.getSchemeSpecificPart(), new String[0]);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return NativeImageResourceFileSystemProvider.toResourcePath(path).newByteChannel(options);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return NativeImageResourceFileSystemProvider.toResourcePath(dir).newDirectoryStream(filter);
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        NativeImageResourceFileSystemProvider.toResourcePath(dir).createDirectory();
    }

    @Override
    public void delete(Path path) throws IOException {
        NativeImageResourceFileSystemProvider.toResourcePath(path).delete();
    }

    @Override
    public boolean deleteIfExists(Path path) throws IOException {
        return NativeImageResourceFileSystemProvider.toResourcePath(path).deleteIfExists();
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        NativeImageResourceFileSystemProvider.toResourcePath(source).copy(NativeImageResourceFileSystemProvider.toResourcePath(target), options);
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        NativeImageResourceFileSystemProvider.toResourcePath(source).move(NativeImageResourceFileSystemProvider.toResourcePath(target), options);
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        return NativeImageResourceFileSystemProvider.toResourcePath(path).isSameFile(path2);
    }

    @Override
    public boolean isHidden(Path path) {
        return NativeImageResourceFileSystemProvider.toResourcePath(path).isHidden();
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        return NativeImageResourceFileSystemProvider.toResourcePath(path).getFileStore();
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        NativeImageResourceFileSystemProvider.toResourcePath(path).checkAccess(modes);
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        return NativeImageResourceFileSystemProvider.toResourcePath(path).newInputStream(options);
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        return NativeImageResourceFileSystemProvider.toResourcePath(path).newOutputStream(options);
    }

    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return NativeImageResourceFileSystemProvider.toResourcePath(path).newFileChannel(options, attrs);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        return NativeImageResourceFileAttributesView.get(NativeImageResourceFileSystemProvider.toResourcePath(path), type);
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        if (type == BasicFileAttributes.class || type == NativeImageResourceFileAttributes.class) {
            return (A)NativeImageResourceFileSystemProvider.toResourcePath(path).getAttributes();
        }
        return null;
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        return NativeImageResourceFileSystemProvider.toResourcePath(path).readAttributes(attributes);
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        NativeImageResourceFileSystemProvider.toResourcePath(path).setAttribute(attribute, value);
    }

    void removeFileSystem() {
        try {
            this.writeLock.lock();
            this.fileSystem = null;
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

