/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.jdk.ResourcesHelper;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;

@TargetClass(className="jdk.internal.loader.Loader", onlyWith={JDK11OrLater.class})
final class Target_jdk_internal_loader_Loader {
    Target_jdk_internal_loader_Loader() {
    }

    @Substitute
    protected URL findResource(String mn, String name) {
        return ResourcesHelper.nameToResourceURL(name);
    }

    @Substitute
    public URL findResource(String name) {
        return ResourcesHelper.nameToResourceURL(name);
    }

    @Substitute
    public Enumeration<URL> findResources(String name) {
        return ResourcesHelper.nameToResourceEnumerationURLs(name);
    }

    @Substitute
    public URL getResource(String name) {
        return ResourcesHelper.nameToResourceURL(name);
    }

    @Substitute
    public Enumeration<URL> getResources(String name) throws IOException {
        return ResourcesHelper.nameToResourceEnumerationURLs(name);
    }

    @Substitute
    private List<URL> findResourcesAsList(String name) {
        return ResourcesHelper.nameToResourceListURLs(name);
    }
}

