/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.jdk.ResourcesHelper;
import com.oracle.svm.core.jdk.Target_java_lang_module_ModuleReference;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;

@TargetClass(className="jdk.internal.loader.BuiltinClassLoader", onlyWith={JDK11OrLater.class})
final class Target_jdk_internal_loader_BuiltinClassLoader {
    Target_jdk_internal_loader_BuiltinClassLoader() {
    }

    @Substitute
    public URL findResource(String mn, String name) {
        return ResourcesHelper.nameToResourceURL(name);
    }

    @Substitute
    public InputStream findResourceAsStream(String mn, String name) throws IOException {
        return ResourcesHelper.nameToResourceInputStream(name);
    }

    @Substitute
    public URL findResource(String name) {
        return ResourcesHelper.nameToResourceURL(name);
    }

    @Substitute
    public Enumeration<URL> findResources(String name) {
        return ResourcesHelper.nameToResourceEnumerationURLs(name);
    }

    @Substitute
    private List<URL> findMiscResource(String name) {
        return ResourcesHelper.nameToResourceListURLs(name);
    }

    @Substitute
    private URL findResource(Target_java_lang_module_ModuleReference mref, String name) {
        return ResourcesHelper.nameToResourceURL(name);
    }

    @Substitute
    private URL findResourceOnClassPath(String name) {
        return ResourcesHelper.nameToResourceURL(name);
    }

    @Substitute
    private Enumeration<URL> findResourcesOnClassPath(String name) {
        return ResourcesHelper.nameToResourceEnumerationURLs(name);
    }
}

