/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.hub.ClassForNameSupport;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.PredefinedClassesSupport;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.jdk.JDK14OrEarlier;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.jdk.NativeLibrarySupport;
import com.oracle.svm.core.jdk.PackageFieldTransformer;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.jdk.ResourcesHelper;
import com.oracle.svm.core.jdk.Target_java_lang_AssertionStatusDirectives;
import com.oracle.svm.core.jdk.Target_java_lang_Module;
import com.oracle.svm.core.util.VMError;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

@TargetClass(value=ClassLoader.class)
public final class Target_java_lang_ClassLoader {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private Vector<Class<?>> classes;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private ConcurrentHashMap<String, Object> parallelLockMap;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=PackageFieldTransformer.class)
    @TargetElement(name="packages", onlyWith={JDK8OrEarlier.class})
    private HashMap<String, Package> packagesJDK8;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=PackageFieldTransformer.class)
    @TargetElement(name="packages", onlyWith={JDK11OrLater.class})
    private ConcurrentHashMap<String, Package> packagesJDK11;
    @Alias
    private static ClassLoader scl;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.NewInstance, declClass=ConcurrentHashMap.class)
    @TargetElement(onlyWith={JDK11OrLater.class})
    ConcurrentHashMap<?, ?> classLoaderValueMap;

    @Substitute
    public static ClassLoader getSystemClassLoader() {
        VMError.guarantee(scl != null);
        return scl;
    }

    @Alias
    @TargetElement(onlyWith={JDK11OrLater.class})
    native Stream<Package> packages();

    @Delete
    private static native void initSystemClassLoader();

    @Substitute
    private URL getResource(String name) {
        return ResourcesHelper.nameToResourceURL(name);
    }

    @Substitute
    private Enumeration<URL> getResources(String name) {
        return ResourcesHelper.nameToResourceEnumerationURLs(name);
    }

    @Substitute
    public InputStream getResourceAsStream(String name) {
        return Resources.createInputStream(name);
    }

    @Substitute
    public static InputStream getSystemResourceAsStream(String name) {
        return Resources.createInputStream(name);
    }

    @Substitute
    @TargetElement(onlyWith={JDK14OrEarlier.class})
    static void loadLibrary(Class<?> fromClass, String name, boolean isAbsolute) {
        if (isAbsolute) {
            NativeLibrarySupport.singleton().loadLibraryAbsolute(new File(name));
        } else {
            NativeLibrarySupport.singleton().loadLibraryRelative(name);
        }
    }

    @Substitute
    private Class<?> loadClass(String name) throws ClassNotFoundException {
        if (!this.checkName(name)) {
            throw new ClassNotFoundException(name);
        }
        return ClassForNameSupport.forName(name, false, SubstrateUtil.cast(this, ClassLoader.class));
    }

    @Alias
    private native boolean checkName(String var1);

    @Substitute
    Class<?> loadClass(String name, boolean resolve) {
        throw VMError.unsupportedFeature("Target_java_lang_ClassLoader.loadClass(String, boolean)");
    }

    @Delete
    native Class<?> findBootstrapClassOrNull(String var1);

    @Substitute
    static void checkClassLoaderPermission(ClassLoader cl, Class<?> caller) {
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    Class<?> loadClass(Target_java_lang_Module module, String name) {
        return ClassForNameSupport.forNameOrNull(name, false, SubstrateUtil.cast(this, ClassLoader.class));
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    private boolean trySetObjectField(String name, Object obj) {
        throw VMError.unsupportedFeature("JDK11OrLater: Target_java_lang_ClassLoader.trySetObjectField(String name, Object obj)");
    }

    @Substitute
    Object getClassLoadingLock(String className) {
        throw VMError.unsupportedFeature("Target_java_lang_ClassLoader.getClassLoadingLock(String)");
    }

    @Substitute
    private Class<?> findLoadedClass0(String name) {
        if (name == null) {
            return null;
        }
        return ClassForNameSupport.forNameOrNull(name, false, SubstrateUtil.cast(this, ClassLoader.class));
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    public Target_java_lang_Module getUnnamedModule() {
        return DynamicHub.singleModuleReference.get();
    }

    @Substitute
    private void setDefaultAssertionStatus(boolean enabled) {
        throw VMError.unsupportedFeature("The assertion status of classes is fixed at image build time.");
    }

    @Substitute
    private void setPackageAssertionStatus(String packageName, boolean enabled) {
        throw VMError.unsupportedFeature("The assertion status of classes is fixed at image build time.");
    }

    @Substitute
    private void setClassAssertionStatus(String className, boolean enabled) {
        throw VMError.unsupportedFeature("The assertion status of classes is fixed at image build time.");
    }

    @Substitute
    private void clearAssertionStatus() {
        throw VMError.unsupportedFeature("The assertion status of classes is fixed at image build time.");
    }

    @Delete
    private static native void registerNatives();

    @Substitute
    Class<?> defineClass(byte[] b, int off, int len) throws ClassFormatError {
        return PredefinedClassesSupport.loadClass(SubstrateUtil.cast(this, ClassLoader.class), null, b, off, len, null);
    }

    @Substitute
    Class<?> defineClass(String name, byte[] b, int off, int len) throws ClassFormatError {
        return PredefinedClassesSupport.loadClass(SubstrateUtil.cast(this, ClassLoader.class), name, b, off, len, null);
    }

    @Substitute
    private Class<?> defineClass(String name, byte[] b, int off, int len, ProtectionDomain protectionDomain) {
        return PredefinedClassesSupport.loadClass(SubstrateUtil.cast(this, ClassLoader.class), name, b, off, len, protectionDomain);
    }

    @Substitute
    private Class<?> defineClass(String name, ByteBuffer b, ProtectionDomain protectionDomain) {
        int off;
        byte[] array;
        int len = b.remaining();
        if (b.hasArray()) {
            array = b.array();
            off = b.position() + b.arrayOffset();
        } else {
            array = new byte[len];
            b.get(array);
            off = 0;
        }
        return PredefinedClassesSupport.loadClass(SubstrateUtil.cast(this, ClassLoader.class), name, array, off, len, null);
    }

    @Delete
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private native Class<?> defineClass0(String var1, byte[] var2, int var3, int var4, ProtectionDomain var5);

    @Delete
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private native Class<?> defineClass1(String var1, byte[] var2, int var3, int var4, ProtectionDomain var5, String var6);

    @Delete
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private native Class<?> defineClass2(String var1, ByteBuffer var2, int var3, int var4, ProtectionDomain var5, String var6);

    @Delete
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private native void resolveClass0(Class<?> var1);

    @Delete
    @TargetElement(onlyWith={JDK11OrLater.class})
    private static native Class<?> defineClass1(ClassLoader var0, String var1, byte[] var2, int var3, int var4, ProtectionDomain var5, String var6);

    @Delete
    @TargetElement(onlyWith={JDK11OrLater.class})
    private static native Class<?> defineClass2(ClassLoader var0, String var1, ByteBuffer var2, int var3, int var4, ProtectionDomain var5, String var6);

    @Delete
    private native Class<?> findBootstrapClass(String var1);

    @Delete
    @TargetElement(onlyWith={JDK14OrEarlier.class})
    private static native String findBuiltinLib(String var0);

    @Delete
    private static native Target_java_lang_AssertionStatusDirectives retrieveDirectives();
}

