/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.JavaMemoryUtil;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.hub.PredefinedClassesSupport;
import com.oracle.svm.core.jdk.JDK11OrEarlier;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.jdk.Package_jdk_internal_misc;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Field;
import java.security.ProtectionDomain;
import org.graalvm.compiler.nodes.extended.MembarNode;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@TargetClass(classNameProvider=Package_jdk_internal_misc.class, className="Unsafe")
final class Target_Unsafe_Core {
    Target_Unsafe_Core() {
    }

    @TargetElement(onlyWith={JDK8OrEarlier.class})
    @Substitute
    private long allocateMemory(long bytes) {
        if (bytes < 0L || this.addressSize() == 4 && bytes > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        Pointer result = (Pointer)UnmanagedMemory.malloc((UnsignedWord)WordFactory.unsigned((long)bytes));
        return result.rawValue();
    }

    @TargetElement(onlyWith={JDK11OrLater.class})
    @Substitute
    private long allocateMemory0(long bytes) {
        return UnmanagedMemory.malloc((UnsignedWord)WordFactory.unsigned((long)bytes)).rawValue();
    }

    @TargetElement(onlyWith={JDK8OrEarlier.class})
    @Substitute
    private long reallocateMemory(long address, long bytes) {
        if (bytes == 0L) {
            return 0L;
        }
        if (bytes < 0L || this.addressSize() == 4 && bytes > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        Pointer result = address != 0L ? (Pointer)UnmanagedMemory.realloc((PointerBase)((PointerBase)WordFactory.unsigned((long)address)), (UnsignedWord)WordFactory.unsigned((long)bytes)) : (Pointer)UnmanagedMemory.malloc((UnsignedWord)WordFactory.unsigned((long)bytes));
        return result.rawValue();
    }

    @TargetElement(onlyWith={JDK11OrLater.class})
    @Substitute
    private long reallocateMemory0(long address, long bytes) {
        return UnmanagedMemory.realloc((PointerBase)((PointerBase)WordFactory.unsigned((long)address)), (UnsignedWord)WordFactory.unsigned((long)bytes)).rawValue();
    }

    @TargetElement(onlyWith={JDK8OrEarlier.class})
    @Substitute
    private void freeMemory(long address) {
        if (address != 0L) {
            UnmanagedMemory.free((PointerBase)((PointerBase)WordFactory.unsigned((long)address)));
        }
    }

    @TargetElement(onlyWith={JDK11OrLater.class})
    @Substitute
    private void freeMemory0(long address) {
        UnmanagedMemory.free((PointerBase)((PointerBase)WordFactory.unsigned((long)address)));
    }

    @TargetElement(onlyWith={JDK8OrEarlier.class})
    @Substitute
    private void copyMemory(Object srcBase, long srcOffset, Object destBase, long destOffset, long bytes) {
        JavaMemoryUtil.unsafeCopyMemory(srcBase, srcOffset, destBase, destOffset, bytes);
    }

    @TargetElement(onlyWith={JDK11OrLater.class})
    @Substitute
    private void copyMemory0(Object srcBase, long srcOffset, Object destBase, long destOffset, long bytes) {
        JavaMemoryUtil.unsafeCopyMemory(srcBase, srcOffset, destBase, destOffset, bytes);
    }

    @TargetElement(onlyWith={JDK11OrLater.class})
    @Substitute
    private void copySwapMemory0(Object srcBase, long srcOffset, Object destBase, long destOffset, long bytes, long elemSize) {
        JavaMemoryUtil.unsafeCopySwapMemory(srcBase, srcOffset, destBase, destOffset, bytes, elemSize);
    }

    @TargetElement(onlyWith={JDK8OrEarlier.class})
    @Substitute
    private void setMemory(Object destBase, long destOffset, long bytes, byte bvalue) {
        JavaMemoryUtil.unsafeSetMemory(destBase, destOffset, bytes, bvalue);
    }

    @TargetElement(onlyWith={JDK11OrLater.class})
    @Substitute
    private void setMemory0(Object destBase, long destOffset, long bytes, byte bvalue) {
        JavaMemoryUtil.unsafeSetMemory(destBase, destOffset, bytes, bvalue);
    }

    @Substitute
    private int addressSize() {
        return ConfigurationValues.getTarget().wordSize;
    }

    @Substitute
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    int pageSize() {
        return (int)VirtualMemoryProvider.get().getGranularity().rawValue();
    }

    @Substitute
    public int arrayBaseOffset(Class<?> clazz) {
        return (int)LayoutEncoding.getArrayBaseOffset(DynamicHub.fromClass(clazz).getLayoutEncoding()).rawValue();
    }

    @Substitute
    public int arrayIndexScale(Class<?> clazz) {
        return LayoutEncoding.getArrayIndexScale(DynamicHub.fromClass(clazz).getLayoutEncoding());
    }

    @Substitute
    private void throwException(Throwable t) throws Throwable {
        throw t;
    }

    @Substitute
    public void loadFence() {
        int fence = 3;
        MembarNode.memoryBarrier((int)3);
    }

    @Substitute
    public void storeFence() {
        int fence = 10;
        MembarNode.memoryBarrier((int)10);
    }

    @Substitute
    public void fullFence() {
        int fence = 15;
        MembarNode.memoryBarrier((int)15);
    }

    @Substitute
    boolean shouldBeInitialized(Class<?> c) {
        return !DynamicHub.fromClass(c).isInitialized();
    }

    @Substitute
    public void ensureClassInitialized(Class<?> c) {
        DynamicHub.fromClass(c).ensureInitialized();
    }

    @Substitute
    private Class<?> defineClass(String name, byte[] b, int off, int len, ClassLoader loader, ProtectionDomain protectionDomain) {
        return PredefinedClassesSupport.loadClass(loader, name, b, off, len, protectionDomain);
    }

    @Substitute
    private Class<?> defineAnonymousClass(Class<?> hostClass, byte[] data, Object[] cpPatches) {
        throw VMError.unsupportedFeature("Defining anonymous classes at runtime is not supported.");
    }

    @Substitute
    private int getLoadAverage(double[] loadavg, int nelems) {
        throw VMError.unsupportedFeature("Unsupported method of Unsafe");
    }

    @Substitute
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private void monitorEnter(Object o) {
        throw VMError.unsupportedFeature("Unsupported method of Unsafe");
    }

    @Substitute
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private void monitorExit(Object o) {
        throw VMError.unsupportedFeature("Unsupported method of Unsafe");
    }

    @Substitute
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private boolean tryMonitorEnter(Object o) {
        throw VMError.unsupportedFeature("Unsupported method of Unsafe");
    }

    @Delete
    private static native void registerNatives();

    @Delete
    @TargetElement(onlyWith={JDK11OrLater.class})
    private native long objectFieldOffset0(Field var1);

    @Delete
    @TargetElement(onlyWith={JDK11OrLater.class})
    private native long objectFieldOffset1(Class<?> var1, String var2);

    @Delete
    @TargetElement(onlyWith={JDK11OrLater.class})
    private native long staticFieldOffset0(Field var1);

    @Delete
    @TargetElement(onlyWith={JDK11OrLater.class})
    private native Object staticFieldBase0(Field var1);

    @Delete
    @TargetElement(onlyWith={JDK11OrLater.class})
    private native boolean shouldBeInitialized0(Class<?> var1);

    @Delete
    @TargetElement(onlyWith={JDK11OrLater.class})
    private native void ensureClassInitialized0(Class<?> var1);

    @Delete
    @TargetElement(onlyWith={JDK11OrLater.class})
    private native int arrayBaseOffset0(Class<?> var1);

    @Delete
    @TargetElement(onlyWith={JDK11OrLater.class})
    private native int arrayIndexScale0(Class<?> var1);

    @Delete
    @TargetElement(onlyWith={JDK11OrLater.class, JDK11OrEarlier.class})
    private native int addressSize0();

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    private Class<?> defineClass0(String name, byte[] b, int off, int len, ClassLoader loader, ProtectionDomain protectionDomain) {
        throw VMError.unsupportedFeature("Target_Unsafe_Core.defineClass0(String, byte[], int, int, ClassLoader, ProtectionDomain)");
    }

    @Delete
    @TargetElement(onlyWith={JDK11OrLater.class})
    private native Class<?> defineAnonymousClass0(Class<?> var1, byte[] var2, Object[] var3);

    @Delete
    @TargetElement(onlyWith={JDK11OrLater.class})
    private native int getLoadAverage0(double[] var1, int var2);

    @Delete
    @TargetElement(onlyWith={JDK11OrLater.class, JDK11OrEarlier.class})
    private native boolean unalignedAccess0();

    @Delete
    @TargetElement(onlyWith={JDK11OrLater.class, JDK11OrEarlier.class})
    private native boolean isBigEndian0();
}

